/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addon.files.mongodb;

import io.automatiko.addon.files.mongodb.GridFSStore;
import io.automatiko.engine.api.event.process.DefaultProcessEventListener;
import io.automatiko.engine.api.event.process.ProcessCompletedEvent;
import io.automatiko.engine.api.runtime.process.ProcessInstance;
import io.automatiko.engine.workflow.file.ByteArrayFile;
import io.quarkus.arc.properties.UnlessBuildProperty;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;

@ApplicationScoped
@UnlessBuildProperty(name="quarkus.automatiko.on-instance-end", stringValue="keep", enableIfMissing=true)
public class CleanFilesEventListener
extends DefaultProcessEventListener {
    private GridFSStore store;

    @Inject
    public CleanFilesEventListener(GridFSStore store) {
        this.store = store;
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        ProcessInstance pi = event.getProcessInstance();
        for (Map.Entry variable : pi.getVariables().entrySet()) {
            if (variable.getValue() instanceof ByteArrayFile) {
                ByteArrayFile file = (ByteArrayFile)variable.getValue();
                this.store.remove(pi.getProcess().getId(), pi.getProcess().getVersion(), pi.getId(), (String)variable.getKey(), file.name());
                continue;
            }
            if (!(variable.getValue() instanceof Collection)) continue;
            for (Object potentialFile : (Collection)variable.getValue()) {
                if (!(potentialFile instanceof ByteArrayFile)) continue;
                ByteArrayFile file = (ByteArrayFile)potentialFile;
                this.store.remove(pi.getProcess().getId(), pi.getProcess().getVersion(), pi.getId(), (String)variable.getKey(), file.name());
            }
        }
    }
}

