/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager.resource.internal;

import io.atomix.catalyst.util.Assert;
import io.atomix.resource.ResourceType;
import java.util.Properties;
import java.util.function.Consumer;

public final class ResourceInstance
implements AutoCloseable {
    private final String key;
    private final ResourceType type;
    private final Properties config;
    private final Consumer<ResourceInstance> closer;

    public ResourceInstance(String key, ResourceType type, Properties config, Consumer<ResourceInstance> closer) {
        this.key = (String)Assert.notNull((Object)key, (String)"key");
        this.type = (ResourceType)Assert.notNull((Object)type, (String)"type");
        this.config = (Properties)Assert.notNull((Object)config, (String)"config");
        this.closer = (Consumer)Assert.notNull(closer, (String)"closer");
    }

    public String key() {
        return this.key;
    }

    public ResourceType type() {
        return this.type;
    }

    public Properties config() {
        return this.config;
    }

    @Override
    public void close() {
        this.closer.accept(this);
    }

    public String toString() {
        return String.format("%s[key=%s, type=%s]", this.getClass().getSimpleName(), this.key, this.type);
    }
}

