/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.inspect;

import io.atlasmap.core.AtlasUtil;
import io.atlasmap.java.core.ClassHelper;
import io.atlasmap.java.core.JdkPackages;
import io.atlasmap.java.core.StringUtil;
import io.atlasmap.java.inspect.InspectionException;
import io.atlasmap.java.inspect.JarClassLoader;
import io.atlasmap.java.v2.AtlasJavaModelFactory;
import io.atlasmap.java.v2.JavaClass;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.java.v2.Modifier;
import io.atlasmap.java.v2.ModifierList;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.StringList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInspectionService {
    public static final int MAX_REENTRY_LIMIT = 1;
    public static final int MAX_ARRAY_DIM_LIMIT = 256;
    private static final Logger LOG = LoggerFactory.getLogger(ClassInspectionService.class);
    private List<String> listClasses = new ArrayList<String>(Arrays.asList("java.util.List", "java.util.ArrayList", "java.util.LinkedList", "java.util.Vector", "java.util.Stack", "java.util.AbstractList", "java.util.AbstractSequentialList"));
    private List<String> mapClasses = new ArrayList<String>(Arrays.asList("java.util.Map", "java.util.HashMap", "java.util.TreeMap", "java.util.Hashtable", "java.util.IdentityHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashMap", "java.util.SortedMap", "java.util.WeakHashMap", "java.util.Properties", "java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentMap"));
    private AtlasConversionService atlasConversionService = null;
    private List<String> fieldExclusions = new ArrayList<String>(Arrays.asList("serialVersionUID"));
    private List<String> classNameExclusions = new ArrayList<String>();
    private Boolean disablePackagePrivateOnlyFields = false;
    private Boolean disableProtectedOnlyFields = false;
    private Boolean disablePrivateOnlyFields = false;
    private Boolean disablePublicOnlyFields = false;
    private Boolean disablePublicGetterSetterFields = false;

    public List<String> getMapClasses() {
        return this.mapClasses;
    }

    public List<String> getListClasses() {
        return this.listClasses;
    }

    public List<String> getClassNameExclusions() {
        return this.classNameExclusions;
    }

    public List<String> getFieldExclusions() {
        return this.fieldExclusions;
    }

    public Boolean getDisableProtectedOnlyFields() {
        return this.disableProtectedOnlyFields;
    }

    public void setDisableProtectedOnlyFields(Boolean disableProtectedOnlyFields) {
        this.disableProtectedOnlyFields = disableProtectedOnlyFields;
    }

    public Boolean getDisablePackagePrivateOnlyFields() {
        return this.disablePackagePrivateOnlyFields;
    }

    public void setDisablePackagePrivateOnlyFields(Boolean disablePackagePrivateOnlyFields) {
        this.disablePackagePrivateOnlyFields = disablePackagePrivateOnlyFields;
    }

    public Boolean getDisablePrivateOnlyFields() {
        return this.disablePrivateOnlyFields;
    }

    public void setDisablePrivateOnlyFields(Boolean disablePrivateOnlyFields) {
        this.disablePrivateOnlyFields = disablePrivateOnlyFields;
    }

    public Boolean getDisablePublicOnlyFields() {
        return this.disablePublicOnlyFields;
    }

    public void setDisablePublicOnlyFields(Boolean disablePublicOnlyFields) {
        this.disablePublicOnlyFields = disablePublicOnlyFields;
    }

    public Boolean getDisablePublicGetterSetterFields() {
        return this.disablePublicGetterSetterFields;
    }

    public void setDisablePublicGetterSetterFields(Boolean disablePublicGetterSetterFields) {
        this.disablePublicGetterSetterFields = disablePublicGetterSetterFields;
    }

    public JavaClass inspectClass(String className, CollectionType collectionType, String collectionClassName) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return this.inspectClass(classLoader, className, collectionType, collectionClassName);
    }

    public JavaClass inspectClass(ClassLoader classLoader, String className, CollectionType collectionType, String collectionClassName) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(className);
        return this.inspectClass(classLoader, clazz, collectionType, collectionClassName);
    }

    public JavaClass inspectClass(String className, CollectionType collectionType, String collectionClassName, String classpath) throws InspectionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting class: " + className + ", classPath: " + classpath);
        }
        if (className == null || classpath == null) {
            throw new InspectionException("ClassName and Classpath must be specified");
        }
        JavaClass d = null;
        try {
            JarClassLoader jcl = new JarClassLoader("target/reference-jars");
            Class<?> clazz = jcl.loadClass(className);
            d = this.inspectClass((ClassLoader)jcl, clazz, collectionType, collectionClassName);
        }
        catch (ClassNotFoundException cnfe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Class was not found: " + className);
            }
            d = AtlasJavaModelFactory.createJavaClass();
            d.setClassName(className);
            d.setStatus(FieldStatus.NOT_FOUND);
        }
        return d;
    }

    public JavaClass inspectClass(Class<?> clazz, CollectionType collectionType, String collectionClassName) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must be specified");
        }
        return this.inspectClass(clazz.getClassLoader(), clazz, collectionType, collectionClassName);
    }

    public JavaClass inspectClass(ClassLoader classLoader, Class<?> clazz, CollectionType collectionType, String collectionClassName) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must be specified");
        }
        JavaClass javaClass = AtlasJavaModelFactory.createJavaClass();
        javaClass.setCollectionType(collectionType);
        String rootPath = "/";
        if (collectionType == CollectionType.LIST) {
            rootPath = rootPath + "<>";
        } else if (collectionType == CollectionType.ARRAY) {
            rootPath = rootPath + "[]";
        } else if (collectionType == CollectionType.MAP) {
            rootPath = rootPath + "{}";
        }
        if (collectionClassName != null && !collectionClassName.isEmpty()) {
            javaClass.setCollectionClassName(collectionClassName);
        }
        javaClass.setPath(rootPath);
        HashSet<String> cachedClasses = new HashSet<String>();
        cachedClasses.add(clazz.getName());
        this.inspectClass(classLoader, clazz, javaClass, cachedClasses, rootPath);
        javaClass.setFieldType(this.getConversionService().fieldTypeFromClass(javaClass.getClassName()));
        return javaClass;
    }

    private void inspectClass(ClassLoader classLoader, Class<?> clazz, JavaClass javaClass, Set<String> cachedClasses, String pathPrefix) {
        Class<?> clz = clazz;
        if (clazz.isArray()) {
            javaClass.setArrayDimensions(this.detectArrayDimensions(clazz));
            javaClass.setCollectionType(CollectionType.ARRAY);
            clz = this.detectArrayClass(clazz);
            if (!javaClass.getPath().endsWith("]")) {
                javaClass.setPath(javaClass.getPath() + "[" + "]");
            }
        } else {
            clz = clazz;
        }
        if (this.isFieldMap(clz.getName())) {
            javaClass.setCollectionType(CollectionType.MAP);
        }
        javaClass.setClassName(clz.getName());
        javaClass.setCanonicalClassName(clz.getCanonicalName());
        javaClass.setPackageName(clz.getPackage() != null ? clz.getPackage().getName() : null);
        javaClass.setAnnotation(Boolean.valueOf(clz.isAnnotation()));
        javaClass.setAnnonymous(Boolean.valueOf(clz.isAnonymousClass()));
        javaClass.setEnumeration(Boolean.valueOf(clz.isEnum()));
        javaClass.setInterface(Boolean.valueOf(clz.isInterface()));
        javaClass.setLocalClass(Boolean.valueOf(clz.isLocalClass()));
        javaClass.setMemberClass(Boolean.valueOf(clz.isMemberClass()));
        javaClass.setPrimitive(Boolean.valueOf(clz.isPrimitive()));
        javaClass.setSynthetic(Boolean.valueOf(clz.isSynthetic()));
        if (javaClass.getUri() == null) {
            javaClass.setUri(String.format("atlas:java?className=%s", AtlasUtil.escapeForUri((String)clz.getName())));
        }
        if (clz.isPrimitive() || JdkPackages.contains(clz.getPackage().getName()).booleanValue()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Skipping class " + clz.getName() + " which is a Jdk core class");
            }
            return;
        }
        Class<?> tmpClazz = clz;
        Class<?> superClazz = tmpClazz.getSuperclass();
        while (superClazz != null) {
            if (JdkPackages.contains(superClazz.getPackage().getName()).booleanValue()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Skipping SuperClass " + superClazz.getName() + " which is a Jdk core class");
                }
                superClazz = null;
                continue;
            }
            this.inspectClassFields(classLoader, superClazz, javaClass, cachedClasses, pathPrefix);
            this.inspectClassMethods(classLoader, superClazz, javaClass, cachedClasses, pathPrefix);
            tmpClazz = superClazz;
            superClazz = tmpClazz.getSuperclass();
        }
        this.inspectClassFields(classLoader, clz, javaClass, cachedClasses, pathPrefix);
        ?[] enumConstants = clz.getEnumConstants();
        if (enumConstants != null) {
            javaClass.setEnumeration(Boolean.valueOf(true));
            for (Object o : enumConstants) {
                JavaEnumField out = new JavaEnumField();
                if (o instanceof Enum) {
                    Enum in = (Enum)o;
                    out.setName(in.name());
                    out.setOrdinal(Integer.valueOf(in.ordinal()));
                    javaClass.getJavaEnumFields().getJavaEnumField().add(out);
                    out.setStatus(FieldStatus.SUPPORTED);
                    continue;
                }
                out.setClassName(o.getClass().getName());
                out.setStatus(FieldStatus.ERROR);
            }
        } else {
            javaClass.setEnumeration(Boolean.valueOf(false));
        }
        this.inspectClassMethods(classLoader, clz, javaClass, cachedClasses, pathPrefix);
        if (javaClass.getModifiers() == null) {
            javaClass.setModifiers(new ModifierList());
        } else {
            javaClass.getModifiers().getModifier().clear();
        }
        javaClass.getModifiers().getModifier().addAll(this.detectModifiers(clz.getModifiers()));
    }

    private JavaField inspectGetMethod(ClassLoader classLoader, Method m, JavaField s, Set<String> cachedClasses, String pathPrefix) {
        JavaField field = s;
        field.setName(StringUtil.getFieldNameFromGetter(m.getName()));
        if (pathPrefix != null && pathPrefix.length() > 0) {
            field.setPath(pathPrefix + (pathPrefix.endsWith("/") ? "" : "/") + StringUtil.getFieldNameFromGetter(m.getName()));
        } else {
            field.setPath(StringUtil.getFieldNameFromGetter(m.getName()));
        }
        if (m.getParameterCount() != 0) {
            field.setStatus(FieldStatus.UNSUPPORTED);
            return field;
        }
        if (m.getReturnType().equals(Void.TYPE)) {
            field.setStatus(FieldStatus.UNSUPPORTED);
            return field;
        }
        Class<?> returnType = m.getReturnType();
        if (returnType.isArray()) {
            field.setCollectionType(CollectionType.ARRAY);
            field.setArrayDimensions(this.detectArrayDimensions(returnType));
            field.setPath(field.getPath() + "[" + "]");
            returnType = this.detectArrayClass(returnType);
        } else if (Collection.class.isAssignableFrom(returnType)) {
            field.setCollectionType(CollectionType.LIST);
            field.setCollectionClassName(returnType.getName());
            field.setPath(field.getPath() + "<" + ">");
            returnType = this.detectListClassFromMethodReturn(m);
        }
        field.setClassName(returnType.getName());
        field.setCanonicalClassName(returnType.getCanonicalName());
        field.setGetMethod(m.getName());
        field.setFieldType(this.getConversionService().fieldTypeFromClass(returnType));
        if (this.getConversionService().isPrimitive(returnType).booleanValue() || this.getConversionService().isBoxedPrimitive(returnType).booleanValue()) {
            field.setPrimitive(Boolean.valueOf(true));
            field.setStatus(FieldStatus.SUPPORTED);
        } else if (field.getFieldType() != FieldType.COMPLEX) {
            field.setPrimitive(Boolean.valueOf(false));
            field.setStatus(FieldStatus.SUPPORTED);
        } else {
            field.setPrimitive(Boolean.valueOf(false));
            Class<?> complexClazz = null;
            JavaClass tmpField = this.convertJavaFieldToJavaClass(field);
            field = tmpField;
            if (returnType.getName() == null) {
                field.setStatus(FieldStatus.UNSUPPORTED);
            } else if (!cachedClasses.contains(returnType.getName())) {
                try {
                    complexClazz = classLoader.loadClass(returnType.getName());
                    cachedClasses.add(returnType.getName());
                    this.inspectClass(classLoader, complexClazz, tmpField, cachedClasses, field.getPath());
                    if (tmpField.getStatus() == null) {
                        field.setStatus(FieldStatus.SUPPORTED);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    field.setStatus(FieldStatus.NOT_FOUND);
                }
            } else {
                field.setStatus(FieldStatus.CACHED);
            }
        }
        return field;
    }

    private JavaField inspectSetMethod(ClassLoader classLoader, Method m, JavaField s, Set<String> cachedClasses, String pathPrefix) {
        JavaField field = s;
        field.setName(StringUtil.getFieldNameFromSetter(m.getName()));
        if (pathPrefix != null && pathPrefix.length() > 0) {
            field.setPath(pathPrefix + (pathPrefix.endsWith("/") ? "" : "/") + StringUtil.getFieldNameFromSetter(m.getName()));
        } else {
            field.setPath(StringUtil.getFieldNameFromSetter(m.getName()));
        }
        if (m.getParameterCount() != 1) {
            field.setStatus(FieldStatus.UNSUPPORTED);
            return field;
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            field.setStatus(FieldStatus.UNSUPPORTED);
            return field;
        }
        Class<?>[] params = m.getParameterTypes();
        if (params == null || params.length != 1) {
            field.setStatus(FieldStatus.UNSUPPORTED);
            return field;
        }
        Class<?> paramType = params[0];
        if (paramType.isArray()) {
            field.setCollectionType(CollectionType.ARRAY);
            field.setArrayDimensions(this.detectArrayDimensions(paramType));
            field.setPath(field.getPath() + "[" + "]");
            paramType = this.detectArrayClass(paramType);
        } else if (Collection.class.isAssignableFrom(paramType)) {
            field.setCollectionType(CollectionType.LIST);
            field.setCollectionClassName(paramType.getName());
            field.setPath(field.getPath() + "<" + ">");
            paramType = this.detectListClassFromMethodParameter(m);
        }
        field.setClassName(paramType.getName());
        field.setCanonicalClassName(paramType.getCanonicalName());
        field.setSetMethod(m.getName());
        field.setFieldType(this.getConversionService().fieldTypeFromClass(paramType));
        if (this.getConversionService().isPrimitive(paramType).booleanValue() || this.getConversionService().isBoxedPrimitive(paramType).booleanValue()) {
            field.setPrimitive(Boolean.valueOf(true));
            field.setStatus(FieldStatus.SUPPORTED);
        } else if (field.getFieldType() != FieldType.COMPLEX) {
            field.setPrimitive(Boolean.valueOf(false));
            field.setStatus(FieldStatus.SUPPORTED);
        } else {
            field.setPrimitive(Boolean.valueOf(false));
            Class<?> complexClazz = null;
            JavaClass tmpField = this.convertJavaFieldToJavaClass(field);
            field = tmpField;
            if (paramType.getName() == null) {
                field.setStatus(FieldStatus.UNSUPPORTED);
            } else if (!cachedClasses.contains(paramType.getName())) {
                try {
                    complexClazz = classLoader.loadClass(paramType.getName());
                    cachedClasses.add(paramType.getName());
                    this.inspectClass(classLoader, complexClazz, tmpField, cachedClasses, field.getPath());
                    if (tmpField.getStatus() == null) {
                        field.setStatus(FieldStatus.SUPPORTED);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    field.setStatus(FieldStatus.NOT_FOUND);
                }
            } else {
                field.setStatus(FieldStatus.CACHED);
            }
        }
        return field;
    }

    private JavaField inspectField(ClassLoader classLoader, Field f, Set<String> cachedClasses, String pathPrefix) {
        JavaField s = AtlasJavaModelFactory.createJavaField();
        Class<?> clazz = f.getType();
        s.setName(f.getName());
        if (pathPrefix != null && pathPrefix.length() > 0) {
            s.setPath(pathPrefix + (pathPrefix.endsWith("/") ? "" : "/") + f.getName());
        } else {
            s.setPath(f.getName());
        }
        if (this.isFieldMap(clazz.getName())) {
            s.setCollectionType(CollectionType.MAP);
            s.setPath(s.getPath() + "{" + "}");
        }
        if (clazz.isArray()) {
            s.setCollectionType(CollectionType.ARRAY);
            s.setArrayDimensions(this.detectArrayDimensions(clazz));
            s.setPath(s.getPath() + "[" + "]");
            clazz = this.detectArrayClass(clazz);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            s.setCollectionType(CollectionType.LIST);
            s.setCollectionClassName(clazz.getName());
            s.setPath(s.getPath() + "<" + ">");
            try {
                clazz = this.detectListClass(classLoader, f);
                if (clazz == null) {
                    s.setStatus(FieldStatus.ERROR);
                    return s;
                }
            }
            catch (ClassCastException | ClassNotFoundException cce) {
                LOG.debug("Error detecting inner listClass: " + cce.getMessage() + " for field: " + f.getName(), (Throwable)cce);
                s.setStatus(FieldStatus.ERROR);
                return s;
            }
        }
        s.setFieldType(this.getConversionService().fieldTypeFromClass(clazz));
        if (this.getConversionService().isPrimitive(clazz).booleanValue() || this.getConversionService().isBoxedPrimitive(clazz).booleanValue()) {
            s.setPrimitive(Boolean.valueOf(true));
            s.setStatus(FieldStatus.SUPPORTED);
        } else if (s.getFieldType() != FieldType.COMPLEX) {
            s.setPrimitive(Boolean.valueOf(false));
            s.setStatus(FieldStatus.SUPPORTED);
        } else {
            s.setPrimitive(Boolean.valueOf(false));
            Class<?> complexClazz = null;
            Annotation[] tmpField = this.convertJavaFieldToJavaClass(s);
            s = tmpField;
            if (clazz.getName() == null) {
                s.setStatus(FieldStatus.UNSUPPORTED);
            } else if (!cachedClasses.contains(clazz.getName())) {
                try {
                    complexClazz = classLoader.loadClass(clazz.getName());
                    cachedClasses.add(clazz.getName());
                    this.inspectClass(classLoader, complexClazz, (JavaClass)tmpField, cachedClasses, s.getPath());
                    if (tmpField.getStatus() == null) {
                        s.setStatus(FieldStatus.SUPPORTED);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    s.setStatus(FieldStatus.NOT_FOUND);
                }
            } else {
                s.setStatus(FieldStatus.CACHED);
            }
        }
        s.setClassName(clazz.getName());
        s.setCanonicalClassName(clazz.getCanonicalName());
        s.setSynthetic(Boolean.valueOf(f.isSynthetic()));
        Annotation[] annotations = f.getAnnotations();
        if (annotations != null) {
            for (Annotation a : annotations) {
                if (s.getAnnotations() == null) {
                    s.setAnnotations(new StringList());
                }
                s.getAnnotations().getString().add(a.annotationType().getName());
            }
        }
        if (s.getModifiers() == null) {
            s.setModifiers(new ModifierList());
        }
        s.getModifiers().getModifier().addAll(this.detectModifiers(f.getModifiers()));
        List<String> pTypes = this.detectParameterizedTypes(f, false);
        if (pTypes != null) {
            if (s.getParameterizedTypes() == null) {
                s.setParameterizedTypes(new StringList());
            }
            s.getParameterizedTypes().getString().addAll(pTypes);
        }
        this.populateGetterSetter(clazz, f, s);
        return s;
    }

    private void populateGetterSetter(Class<?> clazz, Field reflectionField, JavaField atlasField) {
        block9: {
            block8: {
                String getterName;
                block7: {
                    try {
                        getterName = "get" + StringUtil.capitalizeFirstLetter(reflectionField.getName());
                        reflectionField.getDeclaringClass().getMethod(getterName, new Class[0]);
                        atlasField.setGetMethod(getterName);
                    }
                    catch (NoSuchMethodException e) {
                        if (!LOG.isDebugEnabled()) break block7;
                        LOG.debug("No 'get' method for field named: " + reflectionField.getName() + " in class: " + reflectionField.getDeclaringClass().getName());
                    }
                }
                if (atlasField.getGetMethod() == null && ("boolean".equals(atlasField.getClassName()) || "java.lang.Boolean".equals(atlasField.getClassName()))) {
                    try {
                        getterName = "is" + StringUtil.capitalizeFirstLetter(reflectionField.getName());
                        reflectionField.getDeclaringClass().getMethod(getterName, new Class[0]);
                        atlasField.setGetMethod(getterName);
                    }
                    catch (NoSuchMethodException e) {
                        if (!LOG.isDebugEnabled()) break block8;
                        LOG.debug("No 'is' method for field named: " + reflectionField.getName() + " in class: " + reflectionField.getDeclaringClass().getName());
                    }
                }
            }
            try {
                String setterName = "set" + StringUtil.capitalizeFirstLetter(reflectionField.getName());
                reflectionField.getDeclaringClass().getMethod(setterName, clazz);
                atlasField.setSetMethod(setterName);
            }
            catch (NoSuchMethodException e) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug("No 'set' method for field named: " + reflectionField.getName() + " in class: " + reflectionField.getDeclaringClass().getName());
            }
        }
    }

    private void inspectClassFields(ClassLoader classLoader, Class<?> clazz, JavaClass javaClass, Set<String> cachedClasses, String pathPrefix) {
        Set existing = javaClass.getJavaFields().getJavaField().stream().map(io.atlasmap.v2.Field::getName).collect(Collectors.toSet());
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null && !javaClass.isEnumeration().booleanValue()) {
            for (Field f : fields) {
                JavaField s = this.inspectField(classLoader, f, cachedClasses, pathPrefix);
                if (existing.contains(f.getName())) {
                    LOG.warn("Ignoring hidden Java field: " + s.getName());
                    continue;
                }
                if (this.getFieldExclusions().contains(f.getName())) {
                    s.setStatus(FieldStatus.EXCLUDED);
                }
                if (s.isSynthetic() != null && s.isSynthetic().booleanValue()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Synthetic field class detected: " + s.getName());
                    continue;
                }
                if (s.getGetMethod() == null && s.getSetMethod() == null) {
                    if (s.getModifiers().getModifier().contains(Modifier.PRIVATE) && !this.getDisablePrivateOnlyFields().booleanValue()) {
                        javaClass.getJavaFields().getJavaField().add(s);
                        continue;
                    }
                    if (s.getModifiers().getModifier().contains(Modifier.PROTECTED) && !this.getDisableProtectedOnlyFields().booleanValue()) {
                        javaClass.getJavaFields().getJavaField().add(s);
                        continue;
                    }
                    if (s.getModifiers().getModifier().contains(Modifier.PUBLIC) && !this.getDisablePublicOnlyFields().booleanValue()) {
                        javaClass.getJavaFields().getJavaField().add(s);
                        continue;
                    }
                    if (!s.getModifiers().getModifier().contains(Modifier.PACKAGE_PRIVATE) || this.getDisablePackagePrivateOnlyFields().booleanValue()) continue;
                    javaClass.getJavaFields().getJavaField().add(s);
                    continue;
                }
                if (this.getDisablePublicGetterSetterFields().booleanValue()) continue;
                javaClass.getJavaFields().getJavaField().add(s);
            }
        }
    }

    private void inspectClassMethods(ClassLoader classLoader, Class<?> clazz, JavaClass javaClass, Set<String> cachedClasses, String pathPrefix) {
        Method[] methods = clazz.getDeclaredMethods();
        if (methods != null && !javaClass.isEnumeration().booleanValue()) {
            for (Method m : methods) {
                JavaField s = AtlasJavaModelFactory.createJavaField();
                s.setName(m.getName());
                s.setSynthetic(Boolean.valueOf(m.isSynthetic()));
                if (m.isVarArgs() || m.isBridge() || m.isSynthetic() || m.isDefault()) {
                    s.setStatus(FieldStatus.UNSUPPORTED);
                    LOG.warn("VarArg, Bridge, Synthetic or Default method " + m.getName() + " detected");
                    continue;
                }
                s.setSynthetic(Boolean.valueOf(m.isSynthetic()));
                if (m.getName().startsWith("get") || m.getName().startsWith("is")) {
                    s = this.inspectGetMethod(classLoader, m, s, cachedClasses, pathPrefix);
                }
                if (m.getName().startsWith("set")) {
                    s = this.inspectSetMethod(classLoader, m, s, cachedClasses, pathPrefix);
                }
                boolean found = false;
                for (int i = 0; i < javaClass.getJavaFields().getJavaField().size(); ++i) {
                    JavaField exists = (JavaField)javaClass.getJavaFields().getJavaField().get(i);
                    if (!s.getName().equals(exists.getName())) continue;
                    found = true;
                    if (exists.getGetMethod() == null && s.getGetMethod() != null) {
                        exists.setGetMethod(s.getGetMethod());
                    }
                    if (exists.getSetMethod() != null || s.getSetMethod() == null) continue;
                    exists.setSetMethod(s.getSetMethod());
                }
                if (found) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Field already defined for method: " + m.getName() + " class: " + clazz.getName());
                    continue;
                }
                if (s.getGetMethod() != null || s.getSetMethod() != null) {
                    javaClass.getJavaFields().getJavaField().add(s);
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Ignoring non-field method: " + m.getName() + " class: " + clazz.getName());
            }
        }
    }

    protected boolean isFieldMap(String fieldType) {
        return this.getMapClasses().contains(fieldType);
    }

    private Integer detectArrayDimensions(Class<?> clazz) {
        Integer arrayDim = 0;
        if (clazz == null) {
            return null;
        }
        if (!clazz.isArray()) {
            return arrayDim;
        }
        Integer n = arrayDim;
        Integer n2 = arrayDim = Integer.valueOf(arrayDim + 1);
        for (Class<?> tmpClazz = clazz.getComponentType(); tmpClazz != null && tmpClazz.isArray() && arrayDim < 256; tmpClazz = tmpClazz.getComponentType()) {
            n2 = arrayDim;
            Integer n3 = arrayDim = Integer.valueOf(arrayDim + 1);
        }
        return arrayDim;
    }

    private List<Modifier> detectModifiers(int m) {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        if (java.lang.reflect.Modifier.isAbstract(m)) {
            modifiers.add(Modifier.ABSTRACT);
        }
        if (java.lang.reflect.Modifier.isFinal(m)) {
            modifiers.add(Modifier.FINAL);
        }
        if (java.lang.reflect.Modifier.isInterface(m)) {
            modifiers.add(Modifier.INTERFACE);
        }
        if (java.lang.reflect.Modifier.isNative(m)) {
            modifiers.add(Modifier.NATIVE);
        }
        if (java.lang.reflect.Modifier.isPrivate(m)) {
            modifiers.add(Modifier.PRIVATE);
        }
        if (java.lang.reflect.Modifier.isProtected(m)) {
            modifiers.add(Modifier.PROTECTED);
        }
        if (java.lang.reflect.Modifier.isPublic(m)) {
            modifiers.add(Modifier.PUBLIC);
        }
        if (!(java.lang.reflect.Modifier.isPrivate(m) || java.lang.reflect.Modifier.isProtected(m) || java.lang.reflect.Modifier.isPublic(m))) {
            modifiers.add(Modifier.PACKAGE_PRIVATE);
        }
        if (java.lang.reflect.Modifier.isStatic(m)) {
            modifiers.add(Modifier.STATIC);
        }
        if (java.lang.reflect.Modifier.isStrict(m)) {
            modifiers.add(Modifier.STRICT);
        }
        if (java.lang.reflect.Modifier.isSynchronized(m)) {
            modifiers.add(Modifier.SYNCHRONIZED);
        }
        if (java.lang.reflect.Modifier.isTransient(m)) {
            modifiers.add(Modifier.TRANSIENT);
        }
        if (java.lang.reflect.Modifier.isVolatile(m)) {
            modifiers.add(Modifier.VOLATILE);
        }
        return modifiers;
    }

    private Class<?> detectListClass(ClassLoader classLoader, Field field) throws ClassNotFoundException {
        List<String> types = this.detectParameterizedTypes(field, true);
        if (types != null && !types.isEmpty()) {
            return classLoader.loadClass(types.get(0));
        }
        return null;
    }

    private Class<?> detectListClassFromMethodReturn(Method m) {
        return ClassHelper.detectClassFromTypeArgument(m.getGenericReturnType());
    }

    private Class<?> detectListClassFromMethodParameter(Method m) {
        return ClassHelper.detectClassFromTypeArgument(m.getGenericParameterTypes()[0]);
    }

    private Class<?> detectArrayClass(Class<?> clazz) {
        Class<?> tmpClazz;
        Integer arrayDim = new Integer(0);
        if (clazz == null) {
            return null;
        }
        if (!clazz.isArray()) {
            return clazz;
        }
        Integer n = arrayDim;
        Integer n2 = arrayDim = Integer.valueOf(arrayDim + 1);
        for (tmpClazz = clazz.getComponentType(); tmpClazz != null && tmpClazz.isArray() && arrayDim < 256; tmpClazz = tmpClazz.getComponentType()) {
            n2 = arrayDim;
            Integer n3 = arrayDim = Integer.valueOf(arrayDim + 1);
        }
        return tmpClazz;
    }

    private List<String> detectParameterizedTypes(Field field, boolean onlyClasses) {
        ArrayList<String> pTypes = null;
        if (field == null || field.getGenericType() == null || !(field.getGenericType() instanceof ParameterizedType)) {
            return null;
        }
        Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        if (types.length == 0) {
            return null;
        }
        for (Type t : types) {
            if (pTypes == null) {
                pTypes = new ArrayList<String>();
            }
            if (!onlyClasses && t instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)t;
                Type type = tv.getAnnotatedBounds()[0].getType();
                if (type instanceof Class) {
                    pTypes.add(((Class)type).getName());
                } else {
                    pTypes.add(type.getTypeName());
                }
            }
            if (!onlyClasses && t instanceof WildcardType) {
                WildcardType wc = (WildcardType)t;
                Type[] upperBounds = wc.getUpperBounds();
                Type[] lowerBounds = wc.getLowerBounds();
                if (upperBounds != null && upperBounds.length > 0) {
                    pTypes.add(wc.getUpperBounds()[0].getClass().getName());
                } else if (lowerBounds != null && lowerBounds.length > 0) {
                    pTypes.add(wc.getLowerBounds()[0].getClass().getName());
                }
            }
            if (!(t instanceof Class)) continue;
            pTypes.add(((Class)t).getName());
        }
        return pTypes;
    }

    private JavaClass convertJavaFieldToJavaClass(JavaField javaField) {
        JavaClass javaClass = AtlasJavaModelFactory.createJavaClass();
        javaClass.setArrayDimensions(javaField.getArrayDimensions());
        javaClass.setArraySize(javaField.getArraySize());
        javaClass.setCollectionClassName(javaField.getCollectionClassName());
        javaClass.setCollectionType(javaField.getCollectionType());
        javaClass.setDocId(javaField.getDocId());
        javaClass.setPrimitive(javaField.isPrimitive());
        javaClass.setSynthetic(javaField.isSynthetic());
        javaClass.setClassName(javaField.getClassName());
        javaClass.setGetMethod(javaField.getGetMethod());
        javaClass.setName(javaField.getName());
        javaClass.setPath(javaField.getPath());
        javaClass.setRequired(javaField.isRequired());
        javaClass.setSetMethod(javaField.getSetMethod());
        javaClass.setStatus(javaField.getStatus());
        javaClass.setFieldType(javaField.getFieldType());
        if (javaField.getClassName() != null) {
            javaClass.setUri(String.format("atlas:java?className=%s", AtlasUtil.escapeForUri((String)javaField.getClassName())));
        }
        javaClass.setValue(javaField.getValue());
        javaClass.setAnnotations(javaField.getAnnotations());
        javaClass.setModifiers(javaField.getModifiers());
        javaClass.setParameterizedTypes(javaField.getParameterizedTypes());
        return javaClass;
    }

    private AtlasConversionService getConversionService() {
        return this.atlasConversionService;
    }

    public void setConversionService(AtlasConversionService atlasConversionService) {
        this.atlasConversionService = atlasConversionService;
    }
}

