package arrow.core.extensions.`try`.applicativeError

import arrow.Kind
import arrow.core.Either
import arrow.core.ForOption
import arrow.core.ForTry
import arrow.core.Try
import arrow.core.Try.Companion
import arrow.core.extensions.TryApplicativeError
import arrow.typeclasses.ApplicativeError
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("handleErrorWith")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForTry, A>.handleErrorWith(arg1: Function1<Throwable, Kind<ForTry, A>>): Try<A> = arrow.core.Try.applicativeError().run {
  this@handleErrorWith.handleErrorWith<A>(arg1) as arrow.core.Try<A>
}

@JvmName("raiseError1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Throwable.raiseError(): Try<A> = arrow.core.Try.applicativeError().run {
  this@raiseError.raiseError<A>() as arrow.core.Try<A>
}

@JvmName("fromOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForOption, A>.fromOption(arg1: Function0<Throwable>): Try<A> = arrow.core.Try.applicativeError().run {
  this@fromOption.fromOption<A>(arg1) as arrow.core.Try<A>
}

@JvmName("fromEither")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, EE> Either<EE, A>.fromEither(arg1: Function1<EE, Throwable>): Try<A> = arrow.core.Try.applicativeError().run {
  this@fromEither.fromEither<A, EE>(arg1) as arrow.core.Try<A>
}

@JvmName("fromTry")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForTry, A>.fromTry(arg1: Function1<Throwable, Throwable>): Try<A> = arrow.core.Try.applicativeError().run {
  this@fromTry.fromTry<A>(arg1) as arrow.core.Try<A>
}

@JvmName("handleError")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForTry, A>.handleError(arg1: Function1<Throwable, A>): Try<A> = arrow.core.Try.applicativeError().run {
  this@handleError.handleError<A>(arg1) as arrow.core.Try<A>
}

@JvmName("attempt")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForTry, A>.attempt(): Try<Either<Throwable, A>> = arrow.core.Try.applicativeError().run {
  this@attempt.attempt<A>() as arrow.core.Try<arrow.core.Either<kotlin.Throwable, A>>
}

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> catch(arg0: Function1<Throwable, Throwable>, arg1: Function0<A>): Try<A> = arrow.core.Try
   .applicativeError()
   .catch<A>(arg0, arg1) as arrow.core.Try<A>

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> ApplicativeError<ForTry, Throwable>.catch(arg1: Function0<A>): Try<A> = arrow.core.Try.applicativeError().run {
  this@catch.catch<A>(arg1) as arrow.core.Try<A>
}

fun Companion.applicativeError(): TryApplicativeError = object : arrow.core.extensions.TryApplicativeError {  }