package arrow.core.extensions.function1.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.ForFunction1
import arrow.core.Function1.Companion
import arrow.core.Tuple2
import arrow.core.extensions.Function1Monad
import arrow.typeclasses.MonadContinuation
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, A>.flatMap(arg1: Function1<A, Kind<Kind<ForFunction1, I>, B>>): arrow.core.Function1<I, B> = arrow.core.Function1.monad<I>().run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.core.Function1<I, B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> tailRecM(arg0: A, arg1: Function1<A, Kind<Kind<ForFunction1, I>, Either<A, B>>>): arrow.core.Function1<I, B> = arrow.core.Function1
   .monad<I>()
   .tailRecM<A, B>(arg0, arg1) as arrow.core.Function1<I, B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, A>.map(arg1: Function1<A, B>): arrow.core.Function1<I, B> = arrow.core.Function1.monad<I>().run {
  this@map.map<A, B>(arg1) as arrow.core.Function1<I, B>
}

/**
 * @see [Applicative.ap]
 */
@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, A>.ap(arg1: Kind<Kind<ForFunction1, I>, Function1<A, B>>): arrow.core.Function1<I, B> = arrow.core.Function1.monad<I>().run {
  this@ap.ap<A, B>(arg1) as arrow.core.Function1<I, B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A> Kind<Kind<ForFunction1, I>, Kind<Kind<ForFunction1, I>, A>>.flatten(): arrow.core.Function1<I, A> = arrow.core.Function1.monad<I>().run {
  this@flatten.flatten<A>() as arrow.core.Function1<I, A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, A>.followedBy(arg1: Kind<Kind<ForFunction1, I>, B>): arrow.core.Function1<I, B> = arrow.core.Function1.monad<I>().run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.core.Function1<I, B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, A>.followedByEval(arg1: Eval<Kind<Kind<ForFunction1, I>, B>>): arrow.core.Function1<I, B> = arrow.core.Function1.monad<I>().run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.core.Function1<I, B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, A>.effectM(arg1: Function1<A, Kind<Kind<ForFunction1, I>, B>>): arrow.core.Function1<I, A> = arrow.core.Function1.monad<I>().run {
  this@effectM.effectM<A, B>(arg1) as arrow.core.Function1<I, A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, A>.forEffect(arg1: Kind<Kind<ForFunction1, I>, B>): arrow.core.Function1<I, A> = arrow.core.Function1.monad<I>().run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.core.Function1<I, A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, A>.forEffectEval(arg1: Eval<Kind<Kind<ForFunction1, I>, B>>): arrow.core.Function1<I, A> = arrow.core.Function1.monad<I>().run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.core.Function1<I, A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, A>.mproduct(arg1: Function1<A, Kind<Kind<ForFunction1, I>, B>>): arrow.core.Function1<I, Tuple2<A, B>> = arrow.core.Function1.monad<I>().run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.core.Function1<I, arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, B> Kind<Kind<ForFunction1, I>, Boolean>.ifM(arg1: Function0<Kind<Kind<ForFunction1, I>, B>>, arg2: Function0<Kind<Kind<ForFunction1, I>, B>>): arrow.core.Function1<I, B> = arrow.core.Function1.monad<I>().run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.core.Function1<I, B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, Either<A, B>>.selectM(arg1: Kind<Kind<ForFunction1, I>, Function1<A, B>>): arrow.core.Function1<I, B> = arrow.core.Function1.monad<I>().run {
  this@selectM.selectM<A, B>(arg1) as arrow.core.Function1<I, B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A, B> Kind<Kind<ForFunction1, I>, Either<A, B>>.select(arg1: Kind<Kind<ForFunction1, I>, Function1<A, B>>): arrow.core.Function1<I, B> = arrow.core.Function1.monad<I>().run {
  this@select.select<A, B>(arg1) as arrow.core.Function1<I, B>
}

/**
 * Entry point for monad bindings which enables for comprehension. The underlying implementation is based on coroutines.
 * A coroutine is initiated and suspended inside [MonadErrorContinuation] yielding to [Monad.flatMap]. Once all the flatMap binds are completed
 * the underlying monad is returned from the act of executing the coroutine
 */
@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <I, A> binding(arg0: suspend MonadContinuation<Kind<ForFunction1, I>, *>.() -> A): arrow.core.Function1<I, A> = arrow.core.Function1
   .monad<I>()
   .binding<A>(arg0) as arrow.core.Function1<I, A>

/**
 * ank_macro_hierarchy(arrow.typeclasses.Monad)
 *
 * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
 * the results of previous computations.
 *
 * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
 * `Kind<F, ?>` where `?` denotes a value being transformed.
 *
 * This is true for all type constructors that can support the [Monad] type class including and not limited to
 * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
 *
 * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
 *
 */
fun <I> Companion.monad(): Function1Monad<I> = object : arrow.core.extensions.Function1Monad<I> {  }