package arrow.core.extensions.const.traverse

import arrow.Kind
import arrow.core.extensions.ConstTraverse
import arrow.typeclasses.Applicative
import arrow.typeclasses.Const
import arrow.typeclasses.Const.Companion
import arrow.typeclasses.ForConst
import arrow.typeclasses.Monad
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("traverse")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, G, A, B> Kind<Kind<ForConst, X>, A>.traverse(arg1: Applicative<G>, arg2: Function1<A, Kind<G, B>>): Kind<G, Kind<Kind<ForConst, X>, B>> = arrow.typeclasses.Const.traverse<X>().run {
  this@traverse.traverse<G, A, B>(arg1, arg2) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.typeclasses.ForConst, X>, B>>
}

@JvmName("sequence")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, G, A> Kind<Kind<ForConst, X>, Kind<G, A>>.sequence(arg1: Applicative<G>): Kind<G, Kind<Kind<ForConst, X>, A>> = arrow.typeclasses.Const.traverse<X>().run {
  this@sequence.sequence<G, A>(arg1) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.typeclasses.ForConst, X>, A>>
}

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForConst, X>, A>.map(arg1: Function1<A, B>): Const<X, B> = arrow.typeclasses.Const.traverse<X>().run {
  this@map.map<A, B>(arg1) as arrow.typeclasses.Const<X, B>
}

@JvmName("flatTraverse")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, G, A, B> Kind<Kind<ForConst, X>, A>.flatTraverse(
    arg1: Monad<Kind<ForConst, X>>,
    arg2: Applicative<G>,
    arg3: Function1<A, Kind<G, Kind<Kind<ForConst, X>, B>>>
): Kind<G, Kind<Kind<ForConst, X>, B>> = arrow.typeclasses.Const.traverse<X>().run {
  this@flatTraverse.flatTraverse<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.typeclasses.ForConst, X>, B>>
}

fun <X> Companion.traverse(): ConstTraverse<X> = object : arrow.core.extensions.ConstTraverse<X> {  }