package arrow.core.extensions.const.applicative

import arrow.Kind
import arrow.core.Eval
import arrow.core.Tuple10
import arrow.core.Tuple2
import arrow.core.Tuple3
import arrow.core.Tuple4
import arrow.core.Tuple5
import arrow.core.Tuple6
import arrow.core.Tuple7
import arrow.core.Tuple8
import arrow.core.Tuple9
import arrow.core.extensions.ConstApplicative
import arrow.typeclasses.Const
import arrow.typeclasses.Const.Companion
import arrow.typeclasses.ForConst
import arrow.typeclasses.Monoid
import java.math.BigDecimal
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("just1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> A.just(MA: Monoid<A>): Const<A, A> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@just.just<A>() as arrow.typeclasses.Const<A, A>
}

@JvmName("unit")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> unit(MA: Monoid<A>): Const<A, Unit> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .unit() as arrow.typeclasses.Const<A, kotlin.Unit>

@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<Kind<ForConst, A>, A>.ap(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, Function1<A, B>>): Const<A, B> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@ap.ap<A, B>(arg1) as arrow.typeclasses.Const<A, B>
}

@JvmName("product")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<Kind<ForConst, A>, A>.product(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, B>): Const<A, Tuple2<A, B>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@product.product<A, B>(arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple2<A, B>>
}

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<Kind<ForConst, A>, A>.map(MA: Monoid<A>, arg1: Function1<A, B>): Const<A, B> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@map.map<A, B>(arg1) as arrow.typeclasses.Const<A, B>
}

@JvmName("map2")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, Z> Kind<Kind<ForConst, A>, A>.map2(
    MA: Monoid<A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Function1<Tuple2<A, B>, Z>
): Const<A, Z> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@map2.map2<A, B, Z>(arg1, arg2) as arrow.typeclasses.Const<A, Z>
}

@JvmName("map2Eval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, Z> Kind<Kind<ForConst, A>, A>.map2Eval(
    MA: Monoid<A>,
    arg1: Eval<Kind<Kind<ForConst, A>, B>>,
    arg2: Function1<Tuple2<A, B>, Z>
): Eval<Kind<Kind<ForConst, A>, Z>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@map2Eval.map2Eval<A, B, Z>(arg1, arg2) as arrow.core.Eval<arrow.Kind<arrow.Kind<arrow.typeclasses.ForConst, A>, Z>>
}

@JvmName("product1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, Z> Kind<Kind<ForConst, A>, Tuple2<A, B>>.product(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, Z>): Const<A, Tuple3<A, B, Z>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@product.product<A, B, Z>(arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple3<A, B, Z>>
}

@JvmName("product2")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, Z> Kind<Kind<ForConst, A>, Tuple3<A, B, C>>.product(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, Z>): Const<A, Tuple4<A, B, C, Z>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@product.product<A, B, C, Z>(arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple4<A, B, C, Z>>
}

@JvmName("product3")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, Z> Kind<Kind<ForConst, A>, Tuple4<A, B, C, D>>.product(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, Z>): Const<A, Tuple5<A, B, C, D, Z>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@product.product<A, B, C, D, Z>(arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple5<A, B, C, D, Z>>
}

@JvmName("product4")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, Z> Kind<Kind<ForConst, A>, Tuple5<A, B, C, D, E>>.product(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, Z>): Const<A, Tuple6<A, B, C, D, E, Z>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@product.product<A, B, C, D, E, Z>(arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple6<A, B, C, D, E, Z>>
}

@JvmName("product5")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, Z> Kind<Kind<ForConst, A>, Tuple6<A, B, C, D, E, FF>>.product(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, Z>): Const<A, Tuple7<A, B, C, D, E, FF, Z>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@product.product<A, B, C, D, E, FF, Z>(arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple7<A, B, C, D, E, FF, Z>>
}

@JvmName("product6")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, Z> Kind<Kind<ForConst, A>, Tuple7<A, B, C, D, E, FF, G>>.product(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, Z>): Const<A, Tuple8<A, B, C, D, E, FF, G, Z>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@product.product<A, B, C, D, E, FF, G, Z>(arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple8<A, B, C, D, E, FF, G, Z>>
}

@JvmName("product7")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, H, Z> Kind<Kind<ForConst, A>, Tuple8<A, B, C, D, E, FF, G, H>>.product(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, Z>): Const<A, Tuple9<A, B, C, D, E, FF, G, H, Z>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@product.product<A, B, C, D, E, FF, G, H, Z>(arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple9<A, B, C, D, E, FF, G, H, Z>>
}

@JvmName("product8")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, H, I, Z> Kind<Kind<ForConst, A>, Tuple9<A, B, C, D, E, FF, G, H, I>>.product(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, Z>): Const<A, Tuple10<A, B, C, D, E, FF, G, H, I, Z>> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@product.product<A, B, C, D, E, FF, G, H, I, Z>(arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple10<A, B, C, D, E, FF, G, H, I, Z>>
}

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> tupled(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>
): Const<A, Tuple2<A, B>> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .tupled<A, B>(arg0, arg1) as arrow.typeclasses.Const<A, arrow.core.Tuple2<A, B>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C> tupled(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>
): Const<A, Tuple3<A, B, C>> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .tupled<A, B, C>(arg0, arg1, arg2) as arrow.typeclasses.Const<A, arrow.core.Tuple3<A, B, C>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D> tupled(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>
): Const<A, Tuple4<A, B, C, D>> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .tupled<A, B, C, D>(arg0, arg1, arg2, arg3) as arrow.typeclasses.Const<A, arrow.core.Tuple4<A, B, C, D>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E> tupled(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>
): Const<A, Tuple5<A, B, C, D, E>> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .tupled<A, B, C, D, E>(arg0, arg1, arg2, arg3, arg4) as arrow.typeclasses.Const<A, arrow.core.Tuple5<A, B, C, D, E>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF> tupled(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>
): Const<A, Tuple6<A, B, C, D, E, FF>> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .tupled<A, B, C, D, E, FF>(arg0, arg1, arg2, arg3, arg4, arg5) as arrow.typeclasses.Const<A, arrow.core.Tuple6<A, B, C, D, E, FF>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G> tupled(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>,
    arg6: Kind<Kind<ForConst, A>, G>
): Const<A, Tuple7<A, B, C, D, E, FF, G>> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .tupled<A, B, C, D, E, FF, G>(arg0, arg1, arg2, arg3, arg4, arg5, arg6) as arrow.typeclasses.Const<A, arrow.core.Tuple7<A, B, C, D, E, FF, G>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, H> tupled(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>,
    arg6: Kind<Kind<ForConst, A>, G>,
    arg7: Kind<Kind<ForConst, A>, H>
): Const<A, Tuple8<A, B, C, D, E, FF, G, H>> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .tupled<A, B, C, D, E, FF, G, H>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7) as arrow.typeclasses.Const<A, arrow.core.Tuple8<A, B, C, D, E, FF, G, H>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, H, I> tupled(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>,
    arg6: Kind<Kind<ForConst, A>, G>,
    arg7: Kind<Kind<ForConst, A>, H>,
    arg8: Kind<Kind<ForConst, A>, I>
): Const<A, Tuple9<A, B, C, D, E, FF, G, H, I>> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .tupled<A, B, C, D, E, FF, G, H, I>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) as arrow.typeclasses.Const<A, arrow.core.Tuple9<A, B, C, D, E, FF, G, H, I>>

@JvmName("tupled")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, H, I, J> tupled(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>,
    arg6: Kind<Kind<ForConst, A>, G>,
    arg7: Kind<Kind<ForConst, A>, H>,
    arg8: Kind<Kind<ForConst, A>, I>,
    arg9: Kind<Kind<ForConst, A>, J>
): Const<A, Tuple10<A, B, C, D, E, FF, G, H, I, J>> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .tupled<A, B, C, D, E, FF, G, H, I, J>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) as arrow.typeclasses.Const<A, arrow.core.Tuple10<A, B, C, D, E, FF, G, H, I, J>>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, Z> map(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Function1<Tuple2<A, B>, Z>
): Const<A, Z> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .map<A, B, Z>(arg0, arg1, arg2) as arrow.typeclasses.Const<A, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, Z> map(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Function1<Tuple3<A, B, C>, Z>
): Const<A, Z> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .map<A, B, C, Z>(arg0, arg1, arg2, arg3) as arrow.typeclasses.Const<A, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, Z> map(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Function1<Tuple4<A, B, C, D>, Z>
): Const<A, Z> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .map<A, B, C, D, Z>(arg0, arg1, arg2, arg3, arg4) as arrow.typeclasses.Const<A, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, Z> map(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Function1<Tuple5<A, B, C, D, E>, Z>
): Const<A, Z> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .map<A, B, C, D, E, Z>(arg0, arg1, arg2, arg3, arg4, arg5) as arrow.typeclasses.Const<A, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, Z> map(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>,
    arg6: Function1<Tuple6<A, B, C, D, E, FF>, Z>
): Const<A, Z> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .map<A, B, C, D, E, FF, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6) as arrow.typeclasses.Const<A, Z>

@JvmName("plus")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<Kind<ForConst, A>, BigDecimal>.plus(MA: Monoid<A>, arg1: Kind<Kind<ForConst, A>, BigDecimal>): Const<A, BigDecimal> = arrow.typeclasses.Const.applicative<A>(MA).run {
  this@plus.plus(arg1) as arrow.typeclasses.Const<A, java.math.BigDecimal>
}

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, Z> map(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>,
    arg6: Kind<Kind<ForConst, A>, G>,
    arg7: Function1<Tuple7<A, B, C, D, E, FF, G>, Z>
): Const<A, Z> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .map<A, B, C, D, E, FF, G, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7) as arrow.typeclasses.Const<A, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, H, Z> map(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>,
    arg6: Kind<Kind<ForConst, A>, G>,
    arg7: Kind<Kind<ForConst, A>, H>,
    arg8: Function1<Tuple8<A, B, C, D, E, FF, G, H>, Z>
): Const<A, Z> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .map<A, B, C, D, E, FF, G, H, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) as arrow.typeclasses.Const<A, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, H, I, Z> map(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>,
    arg6: Kind<Kind<ForConst, A>, G>,
    arg7: Kind<Kind<ForConst, A>, H>,
    arg8: Kind<Kind<ForConst, A>, I>,
    arg9: Function1<Tuple9<A, B, C, D, E, FF, G, H, I>, Z>
): Const<A, Z> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .map<A, B, C, D, E, FF, G, H, I, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) as arrow.typeclasses.Const<A, Z>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B, C, D, E, FF, G, H, I, J, Z> map(
    MA: Monoid<A>,
    arg0: Kind<Kind<ForConst, A>, A>,
    arg1: Kind<Kind<ForConst, A>, B>,
    arg2: Kind<Kind<ForConst, A>, C>,
    arg3: Kind<Kind<ForConst, A>, D>,
    arg4: Kind<Kind<ForConst, A>, E>,
    arg5: Kind<Kind<ForConst, A>, FF>,
    arg6: Kind<Kind<ForConst, A>, G>,
    arg7: Kind<Kind<ForConst, A>, H>,
    arg8: Kind<Kind<ForConst, A>, I>,
    arg9: Kind<Kind<ForConst, A>, J>,
    arg10: Function1<Tuple10<A, B, C, D, E, FF, G, H, I, J>, Z>
): Const<A, Z> = arrow.typeclasses.Const
   .applicative<A>(MA)
   .map<A, B, C, D, E, FF, G, H, I, J, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) as arrow.typeclasses.Const<A, Z>

fun <A> Companion.applicative(MA: Monoid<A>): ConstApplicative<A> = object : arrow.core.extensions.ConstApplicative<A> { override fun MA(): arrow.typeclasses.Monoid<A> = MA }