/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.proxy;

import com.google.common.base.Preconditions;
import io.appium.java_client.proxy.HasMethodCallListeners;
import io.appium.java_client.proxy.Interceptor;
import io.appium.java_client.proxy.MethodCallListener;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Helpers {
    public static final Set<String> OBJECT_METHOD_NAMES = Stream.of(Object.class.getMethods()).map(Method::getName).collect(Collectors.toSet());

    private Helpers() {
    }

    public static <T> T createProxy(Class<T> cls, Object[] constructorArgs, Class<?>[] constructorArgTypes, Collection<MethodCallListener> listeners) {
        ElementMatcher.Junction extraMatcher = ElementMatchers.not((ElementMatcher)ElementMatchers.namedOneOf((String[])OBJECT_METHOD_NAMES.toArray(new String[0])));
        return Helpers.createProxy(cls, constructorArgs, constructorArgTypes, listeners, (ElementMatcher<MethodDescription>)extraMatcher);
    }

    public static <T> T createProxy(Class<T> cls, Object[] constructorArgs, Class<?>[] constructorArgTypes, Collection<MethodCallListener> listeners, @Nullable ElementMatcher<MethodDescription> extraMethodMatcher) {
        Preconditions.checkArgument((constructorArgs.length == constructorArgTypes.length ? 1 : 0) != 0, (Object)String.format("Constructor arguments array length %d must be equal to the types array length %d", constructorArgs.length, constructorArgTypes.length));
        Preconditions.checkArgument((!listeners.isEmpty() ? 1 : 0) != 0, (Object)"The collection of listeners must not be empty");
        Objects.requireNonNull(cls, "Class must not be null");
        Preconditions.checkArgument((!cls.isInterface() ? 1 : 0) != 0, (Object)"Class must not be an interface");
        ElementMatcher.Junction matcher = ElementMatchers.isPublic();
        Class<T> proxy = new ByteBuddy().subclass(cls).method((ElementMatcher)(extraMethodMatcher == null ? matcher : matcher.and(extraMethodMatcher))).intercept((Implementation)MethodDelegation.to(Interceptor.class)).defineField("methodCallListeners", MethodCallListener[].class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{HasMethodCallListeners.class}).intercept((Implementation)FieldAccessor.ofBeanProperty()).make().load(ClassLoader.getSystemClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded().asSubclass(cls);
        try {
            T result = cls.cast(proxy.getConstructor(constructorArgTypes).newInstance(constructorArgs));
            ((HasMethodCallListeners)result).setMethodCallListeners((MethodCallListener[])listeners.toArray(MethodCallListener[]::new));
            return result;
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException(String.format("Unable to create a proxy of %s", cls.getName()), e);
        }
    }

    public static <T> T createProxy(Class<T> cls, Collection<MethodCallListener> listeners) {
        return Helpers.createProxy(cls, new Object[0], new Class[0], listeners);
    }

    public static <T> T createProxy(Class<T> cls, MethodCallListener listener) {
        return Helpers.createProxy(cls, new Object[0], new Class[0], Collections.singletonList(listener));
    }

    public static <T> T createProxy(Class<T> cls, Object[] constructorArgs, Class<?>[] constructorArgTypes, MethodCallListener listener) {
        return Helpers.createProxy(cls, constructorArgs, constructorArgTypes, Collections.singletonList(listener));
    }
}

