/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.FindsByIosUIAutomation;
import io.appium.java_client.MobileElement;
import io.appium.java_client.ios.GetsNamedTextField;
import io.appium.java_client.ios.IOSDeviceActionShortcuts;
import io.appium.java_client.ios.IOSElement;
import io.appium.java_client.ios.internal.JsonToIOSElementConverter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebElement;

public class IOSDriver
extends AppiumDriver
implements IOSDeviceActionShortcuts,
GetsNamedTextField,
FindsByIosUIAutomation {
    private static final String IOS_PLATFORM = "iOS";

    public IOSDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
        this.setElementConverter(new JsonToIOSElementConverter(this));
    }

    @Override
    public MobileElement scrollTo(String text) {
        return ((IOSElement)this.findElementByClassName("UIATableView")).scrollTo(text);
    }

    @Override
    public MobileElement scrollToExact(String text) {
        return ((IOSElement)this.findElementByClassName("UIATableView")).scrollToExact(text);
    }

    @Override
    public void hideKeyboard(String strategy, String keyName) {
        String[] parameters = new String[]{"strategy", "key"};
        Object[] values = new Object[]{strategy, keyName};
        this.execute("hideKeyboard", (Map<String, ?>)IOSDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void hideKeyboard(String keyName) {
        this.execute("hideKeyboard", (Map<String, ?>)ImmutableMap.of((Object)"keyName", (Object)keyName));
    }

    @Override
    public void shake() {
        this.execute("shake");
    }

    @Override
    public WebElement getNamedTextField(String name) {
        MobileElement element = (MobileElement)this.findElementByAccessibilityId(name);
        if (element.getTagName() != "TextField") {
            return element.findElementByAccessibilityId(name);
        }
        return element;
    }

    @Override
    public WebElement findElementByIosUIAutomation(String using) {
        return this.findElement("-ios uiautomation", using);
    }

    @Override
    public List<WebElement> findElementsByIosUIAutomation(String using) {
        return this.findElements("-ios uiautomation", using);
    }
}

