/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.rack;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.airlift.rack.RackServletConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyObjectAdapter;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RackServlet
implements Servlet {
    private final IRubyObject rackApplication;
    private final Ruby runtime;
    private final RubyObjectAdapter adapter = JavaEmbedUtils.newObjectAdapter();
    private ServletConfig servletConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public RackServlet(RackServletConfig config) throws IOException {
        Preconditions.checkNotNull((Object)config);
        File rackScriptFile = new File(config.getRackConfigPath());
        Preconditions.checkArgument((boolean)rackScriptFile.canRead(), (Object)("Could not find rack script specified by [" + config.getRackConfigPath() + "] and resolved to [" + rackScriptFile.getAbsolutePath() + "]"));
        this.runtime = JavaEmbedUtils.initialize((List)ImmutableList.of((Object)rackScriptFile.getParentFile().getCanonicalPath()), (RubyInstanceConfig)this.createRuntimeConfig());
        RubyHash env = this.runtime.evalScriptlet("ENV").convertToHash();
        env.remove((Object)"GEM_HOME");
        env.remove((Object)"GEM_PATH");
        try (InputStream stream = Resources.getResource((String)"io/airlift/rack.rb").openStream();){
            this.runtime.loadFile("rack.rb", stream, false);
        }
        IRubyObject builder = this.runtime.evalScriptlet("Airlift::RackServer::Builder.new");
        this.rackApplication = this.adapter.callMethod(builder, "build", new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)this.runtime, (Object)rackScriptFile.getCanonicalPath())});
    }

    private RubyInstanceConfig createRuntimeConfig() {
        RubyInstanceConfig config = new RubyInstanceConfig();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        config.setClassCache(JavaEmbedUtils.createClassCache((ClassLoader)classLoader));
        URL resource = RubyInstanceConfig.class.getResource("/META-INF/jruby.home");
        if (resource != null && resource.getProtocol().equals("jar")) {
            try {
                config.setJRubyHome(resource.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                config.setJRubyHome(resource.getPath());
            }
        }
        return config;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)response);
        Preconditions.checkArgument((boolean)(request instanceof HttpServletRequest), (Object)"Expected a servlet request that implements HttpServletRequest, this servlet only supports Http(s)");
        Preconditions.checkArgument((boolean)(response instanceof HttpServletResponse), (Object)"Expected a servlet response that implements HttpServletResponse, this servlet only supports Http(s)");
        this.adapter.callMethod(this.rackApplication, "call", new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)this.runtime, (Object)request), JavaEmbedUtils.javaToRuby((Ruby)this.runtime, (Object)response)});
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return "RackServlet, a servlet for running rack applications.  Copyright 2010 Proofpoint, Inc.";
    }

    public void destroy() {
    }
}

