/*
 * Decompiled with CFR 0.152.
 */
package uk.co.codezen.maven.redlinerpm.rpm;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.DirectoryScanner;
import org.redline_rpm.Builder;
import org.redline_rpm.payload.Directive;
import uk.co.codezen.maven.redlinerpm.mojo.RpmMojo;
import uk.co.codezen.maven.redlinerpm.rpm.BaseOwnedObject;
import uk.co.codezen.maven.redlinerpm.rpm.DirectoryScannerFactory;
import uk.co.codezen.maven.redlinerpm.rpm.RpmPackage;
import uk.co.codezen.maven.redlinerpm.rpm.RpmPackageRuleDirective;
import uk.co.codezen.maven.redlinerpm.rpm.exception.AbstractRpmException;
import uk.co.codezen.maven.redlinerpm.rpm.exception.CanonicalScanPathOutsideBuildPathException;
import uk.co.codezen.maven.redlinerpm.rpm.exception.InvalidPathException;
import uk.co.codezen.maven.redlinerpm.rpm.exception.InvalidRpmPackageRuleDirectiveException;

public final class RpmPackageRule
extends BaseOwnedObject {
    private RpmPackage rpmPackage = null;
    private String base = File.separator;
    private String destination = null;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private Directive directive = new Directive();

    public void setPackage(RpmPackage rpmPackage) {
        this.rpmPackage = rpmPackage;
    }

    @Override
    public RpmPackage getPackage() {
        return this.rpmPackage;
    }

    public void setBase(String base) {
        if (null == base || base.equals("")) {
            base = File.separator;
        }
        this.base = base;
    }

    public String getBase() {
        return this.base;
    }

    public void setDestination(String destination) {
        if (null != destination && destination.equals("")) {
            destination = null;
        }
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getDestinationOrDefault() {
        if (null == this.destination) {
            return this.getPackage().getMojo().getDefaultDestination();
        }
        return this.destination;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setDirectives(List<String> directives) throws InvalidRpmPackageRuleDirectiveException {
        this.directive = RpmPackageRuleDirective.newDirective(directives);
    }

    public Directive getDirectives() {
        return this.directive;
    }

    public String getScanPath() throws InvalidPathException {
        String scanPath = String.format("%s%s%s", this.rpmPackage.getMojo().getBuildPath(), File.separator, this.getBase());
        try {
            return new File(scanPath).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new InvalidPathException(scanPath, ex);
        }
    }

    public Log getLog() {
        return this.getPackage().getMojo().getLog();
    }

    public String[] listFiles() throws AbstractRpmException {
        RpmMojo mojo = this.rpmPackage.getMojo();
        String buildPath = mojo.getBuildPath();
        String scanPath = this.getScanPath();
        if (!String.format("%s%s", scanPath, File.separator).startsWith(String.format("%s%s", buildPath, File.separator))) {
            throw new CanonicalScanPathOutsideBuildPathException(scanPath, buildPath);
        }
        DirectoryScanner ds = DirectoryScannerFactory.factory(scanPath, this.getIncludes().toArray(new String[0]), this.getExcludes().toArray(new String[0]));
        this.getLog().debug((CharSequence)"Scanning for files for package rule");
        ds.scan();
        return ds.getIncludedFiles();
    }

    public String[] addFiles(Builder builder) throws IOException, NoSuchAlgorithmException, AbstractRpmException {
        String[] includedFiles = this.listFiles();
        String scanPath = this.getScanPath();
        this.getLog().debug((CharSequence)String.format("Adding %d files found to package.", includedFiles.length));
        for (String includedFile : includedFiles) {
            String destinationPath = this.getDestinationOrDefault() + File.separator + includedFile;
            String sourcePath = String.format("%s%s%s", scanPath, File.separator, includedFile);
            String owner = this.getOwnerOrDefault();
            String group = this.getGroupOrDefault();
            int fileMode = this.getModeOrDefault();
            File source = new File(sourcePath);
            if (Files.isSymbolicLink(source.toPath())) {
                Path targetPath = Files.readSymbolicLink(source.toPath());
                this.getLog().debug((CharSequence)String.format("Adding symlink: %s -> %s to path %s with owner '%s', group '%s', with file mode %o.", sourcePath, targetPath, destinationPath, owner, group, fileMode));
                builder.addLink(destinationPath, targetPath.toString(), fileMode, owner, group);
                continue;
            }
            this.getLog().debug((CharSequence)String.format("Adding file: %s to path %s with owner '%s', group '%s', with file mode %o.", sourcePath, destinationPath, owner, group, fileMode));
            builder.addFile(destinationPath, source, fileMode, this.getDirectives(), owner, group);
        }
        return includedFiles;
    }
}

