/*
 * Decompiled with CFR 0.152.
 */
package info.macias.sse.events;

public class MessageEvent {
    private final String data;
    private final String event;
    private final Integer retry;
    private final String id;
    private final String toStringCache;

    private MessageEvent(String event, String data, Integer retry, String id, String toStringCache) {
        this.data = data;
        this.event = event;
        this.toStringCache = toStringCache;
        this.retry = retry;
        this.id = id;
    }

    public final String getData() {
        return this.data;
    }

    public final String getEvent() {
        return this.event;
    }

    public Integer getRetry() {
        return this.retry;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.toStringCache;
    }

    public static class Builder {
        private String data = null;
        private String event = null;
        private Integer retry = null;
        private String id = null;

        public Builder setData(String data) {
            this.data = data;
            return this;
        }

        public Builder setEvent(String event) {
            this.event = event;
            return this;
        }

        public Builder setRetry(int retry) {
            this.retry = retry;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public MessageEvent build() {
            StringBuilder sb = new StringBuilder();
            if (this.event != null) {
                sb.append("event: ").append(this.event.replace("\n", "")).append('\n');
            }
            if (this.data != null) {
                for (String s : this.data.split("\n")) {
                    sb.append("data: ").append(s).append('\n');
                }
            }
            if (this.retry != null) {
                sb.append("retry: ").append(this.retry).append('\n');
            }
            if (this.id != null) {
                sb.append("id: ").append(this.id.replace("\n", "")).append('\n');
            }
            sb.append('\n');
            return new MessageEvent(this.event, this.data, this.retry, this.id, sb.toString());
        }
    }
}

