/*
 * Decompiled with CFR 0.152.
 */
package info.macias.sse;

import info.macias.sse.events.MessageEvent;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SseDispatcher {
    private final AsyncContext asyncContext;
    private boolean completed = false;

    public SseDispatcher(HttpServletRequest request) {
        this.asyncContext = request.startAsync();
        this.asyncContext.setTimeout(0L);
        this.asyncContext.addListener((AsyncListener)new AsyncListenerImpl());
    }

    public SseDispatcher ok() {
        HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
        response.setStatus(200);
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        return this;
    }

    public SseDispatcher open() throws IOException {
        HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
        response.getOutputStream().print("event: open\n\n");
        response.getOutputStream().flush();
        return this;
    }

    public SseDispatcher send(String event, String data) throws IOException {
        HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
        response.getOutputStream().print(new MessageEvent.Builder().setData(data).setEvent(event).build().toString());
        response.getOutputStream().flush();
        return this;
    }

    public SseDispatcher send(MessageEvent messageEvent) throws IOException {
        HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
        response.getOutputStream().print(messageEvent.toString());
        response.getOutputStream().flush();
        return this;
    }

    public void close() {
        if (!this.completed) {
            this.completed = true;
            this.asyncContext.complete();
        }
    }

    private class AsyncListenerImpl
    implements AsyncListener {
        private AsyncListenerImpl() {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            SseDispatcher.this.completed = true;
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }
}

