/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.elm_modelinfo.r1.serializing;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.hl7.elm_modelinfo.r1.serializing.ModelInfoReader;
import org.hl7.elm_modelinfo.r1.serializing.ModelInfoReaderProvider;

public class ModelInfoReaderFactory {
    private ModelInfoReaderFactory() {
    }

    public static Iterator<ModelInfoReaderProvider> providers(boolean refresh) {
        ServiceLoader<ModelInfoReaderProvider> loader = ServiceLoader.load(ModelInfoReaderProvider.class);
        if (refresh) {
            loader.reload();
        }
        return loader.iterator();
    }

    public static ModelInfoReader getReader(String contentType) {
        Iterator<ModelInfoReaderProvider> providers = ModelInfoReaderFactory.providers(false);
        if (providers.hasNext()) {
            ModelInfoReaderProvider p = providers.next();
            if (providers.hasNext()) {
                throw new RuntimeException(String.join((CharSequence)" ", "Multiple ModelInfoReaderProviders found on the classpath.", "You need to remove a reference to either the 'model-jackson' or the 'model-jaxb' package"));
            }
            return p.create(contentType);
        }
        throw new RuntimeException(String.join((CharSequence)" ", "No ModelInfoReaderProviders found on the classpath.", "You need to add a reference to one of the 'model-jackson' or 'model-jaxb' packages,", "or provide your own implementation."));
    }
}

