/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsd.display;

import javax.xml.namespace.QName;
import jlibs.core.graph.visitors.PathReflectionVisitor;
import jlibs.core.lang.ImpossibleException;
import jlibs.core.lang.StringUtil;
import jlibs.xml.XMLUtil;
import jlibs.xml.sax.helpers.MyNamespaceSupport;
import jlibs.xml.xsd.XSUtil;
import jlibs.xml.xsd.display.XSPathDiplayFilter;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSWildcard;

public class XSDisplayNameVisitor
extends PathReflectionVisitor<Object, String> {
    XSPathDiplayFilter filter;
    private MyNamespaceSupport nsSupport;

    public XSDisplayNameVisitor(MyNamespaceSupport nsSupport, XSPathDiplayFilter filter) {
        this.nsSupport = nsSupport;
        this.filter = filter;
    }

    protected String getDefault(Object elem) {
        return StringUtil.toString((Object)elem);
    }

    protected String process(XSNamespaceItem nsItem) {
        return StringUtil.toString((Object)nsItem.getSchemaNamespace());
    }

    protected String process(XSObject obj) {
        return XMLUtil.getQName((QName)XSUtil.getQName(obj, this.nsSupport));
    }

    private String addCardinal(String str) {
        if (!this.filter.select(this.path.getParentPath())) {
            XSParticle particle = (XSParticle)this.path.getParentPath().getElement();
            return str + this.process(particle);
        }
        return str;
    }

    protected String process(XSElementDeclaration elem) {
        String str = '<' + this.process((XSObject)elem) + '>';
        return this.addCardinal(str);
    }

    protected String process(XSAttributeUse attrUse) {
        String str = '@' + this.process((XSObject)attrUse);
        if (!attrUse.getRequired()) {
            str = str + '?';
        }
        return str;
    }

    protected String process(XSParticle particle) {
        if (particle.getMinOccurs() == 0 && particle.getMaxOccursUnbounded()) {
            return "*";
        }
        if (particle.getMinOccurs() == 1 && particle.getMaxOccursUnbounded()) {
            return "+";
        }
        if (particle.getMaxOccursUnbounded()) {
            return particle.getMinOccurs() + "+";
        }
        if (particle.getMinOccurs() == 0 && particle.getMaxOccurs() == 1) {
            return "?";
        }
        return "[" + particle.getMinOccurs() + "," + particle.getMaxOccurs() + "]";
    }

    protected String process(XSModelGroup modelGroup) {
        String str;
        switch (modelGroup.getCompositor()) {
            case 3: {
                str = "[ALL]";
                break;
            }
            case 2: {
                str = "[OR]";
                break;
            }
            case 1: {
                str = "[SEQUENCE]";
                break;
            }
            default: {
                throw new ImpossibleException("Invalid Compositor: " + modelGroup.getCompositor());
            }
        }
        return this.addCardinal(str);
    }

    protected String process(XSWildcard wildcard) {
        XSElementDeclaration elem;
        String str;
        switch (wildcard.getConstraintType()) {
            case 1: {
                str = "*:*";
                break;
            }
            case 3: {
                StringBuilder buff = new StringBuilder();
                StringList list = wildcard.getNsConstraintList();
                for (int i = 0; i < list.getLength(); ++i) {
                    String prefix;
                    String item = list.item(i);
                    if (item == null) {
                        item = "";
                    }
                    if (buff.length() > 0) {
                        buff.append('|');
                    }
                    if ((prefix = this.nsSupport.findPrefix(item)) != null) {
                        buff.append(prefix);
                        continue;
                    }
                    buff.append('{').append(item).append('}');
                }
                if (buff.toString().equals("{}")) {
                    str = "*";
                    break;
                }
                str = buff + ":*";
                break;
            }
            case 2: {
                StringBuilder buff = new StringBuilder();
                StringList list = wildcard.getNsConstraintList();
                for (int i = 0; i < list.getLength(); ++i) {
                    String item = list.item(i);
                    if (item == null) {
                        item = "";
                    }
                    String prefix = this.nsSupport.findPrefix(item);
                    if (buff.length() > 0) {
                        buff.append(',');
                    }
                    if (!StringUtil.isEmpty((CharSequence)prefix)) {
                        buff.append(prefix);
                        continue;
                    }
                    buff.append('{').append(item).append('}');
                }
                if (!buff.toString().contains(",")) {
                    str = "!" + buff + ":*";
                    break;
                }
                str = "!(" + buff + "):*";
                break;
            }
            default: {
                throw new ImpossibleException("Invalid Constraint: " + wildcard.getConstraintType());
            }
        }
        boolean attribute = false;
        if (this.path.getParentPath().getElement() instanceof XSElementDeclaration && ((XSComplexTypeDefinition)(elem = (XSElementDeclaration)this.path.getParentPath().getElement()).getTypeDefinition()).getAttributeWildcard() == wildcard) {
            attribute = true;
        }
        str = attribute ? '@' + str : '<' + str + '>';
        return this.addCardinal(str);
    }
}

