/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;

public class WebSphereTransactionManagerLookup
implements TransactionManagerLookup {
    private static final Log log = LogFactory.getLog(WebSphereTransactionManagerLookup.class);
    private final int wsVersion;
    private final Class tmfClass;

    public WebSphereTransactionManagerLookup() {
        try {
            int version;
            Class<?> clazz;
            try {
                clazz = Class.forName("com.ibm.ws.Transaction.TransactionManagerFactory");
                version = 5;
                log.info((Object)"WebSphere 5.1");
            }
            catch (Exception e) {
                try {
                    clazz = Class.forName("com.ibm.ejs.jts.jta.TransactionManagerFactory");
                    version = 5;
                    log.info((Object)"WebSphere 5.0");
                }
                catch (Exception e2) {
                    clazz = Class.forName("com.ibm.ejs.jts.jta.JTSXA");
                    version = 4;
                    log.info((Object)"WebSphere 4");
                }
            }
            this.tmfClass = clazz;
            this.wsVersion = version;
        }
        catch (Exception e) {
            throw new HibernateException("Could not obtain WebSphere TransactionManagerFactory instance", e);
        }
    }

    public TransactionManager getTransactionManager(Properties props) throws HibernateException {
        try {
            return (TransactionManager)this.tmfClass.getMethod("getTransactionManager", null).invoke(null, null);
        }
        catch (Exception e) {
            throw new HibernateException("Could not obtain WebSphere TransactionManager", e);
        }
    }

    public String getUserTransactionName() {
        return this.wsVersion == 5 ? "java:comp/UserTransaction" : "jta/usertransaction";
    }
}

