/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;

public class TransactionalCache
implements CacheConcurrencyStrategy {
    private static final Log log = LogFactory.getLog(TransactionalCache.class);
    private Cache cache;

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cache lookup: " + key));
        }
        Object result = this.cache.read(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)(result == null ? "cache miss" : "cache hit"));
        }
        return result;
    }

    public boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator, boolean minimalPut) throws CacheException {
        if (minimalPut && this.cache.read(key) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("item already cached: " + key));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("caching: " + key));
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeLoad(key, value, version);
        } else {
            this.cache.put(key, value);
        }
        return true;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object key, Object version) throws CacheException {
        return null;
    }

    public void release(Object key, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating: " + key));
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeUpdate(key, value, currentVersion, previousVersion);
        } else {
            this.cache.update(key, value);
        }
        return true;
    }

    public boolean insert(Object key, Object value, Object currentVersion) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("inserting: " + key));
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeInsert(key, value, currentVersion);
        } else {
            this.cache.update(key, value);
        }
        return true;
    }

    public void evict(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void remove(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing: " + key));
        }
        this.cache.remove(key);
    }

    public void clear() throws CacheException {
        log.debug((Object)"clearing");
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy cache", (Throwable)e);
        }
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean afterUpdate(Object key, Object value, Object version, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        return false;
    }

    public String toString() {
        return this.cache + "(transactional)";
    }
}

