/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odp;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.document.AbstractXDocReport;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.document.odp.ODPConstants;
import fr.opensagres.xdocreport.document.odp.images.ODPImageRegistry;
import java.io.IOException;
import java.io.Reader;

public class ODPReport
extends AbstractXDocReport
implements ODPConstants {
    private static final long serialVersionUID = -8323654563409226895L;
    private static final String[] DEFAULT_XML_ENTRIES = new String[]{"content.xml", "styles.xml"};

    public String getKind() {
        return DocumentKind.ODP.name();
    }

    protected void registerPreprocessors() {
    }

    protected String[] getDefaultXMLEntries() {
        return DEFAULT_XML_ENTRIES;
    }

    public MimeMapping getMimeMapping() {
        return MIME_MAPPING;
    }

    public static boolean isODP(XDocArchive documentArchive) {
        try {
            if (!documentArchive.hasEntry("mimetype")) {
                return false;
            }
            return "application/vnd.oasis.opendocument.presentation".equals(IOUtils.toString((Reader)documentArchive.getEntryReader("mimetype")));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected IImageRegistry createImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider) {
        return new ODPImageRegistry(readerProvider, writerProvider, outputStreamProvider, this.getFieldsMetadata());
    }
}

