/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.pdf.internal;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.draw.DottedLineSeparator;
import com.lowagie.text.pdf.draw.DrawInterface;
import com.lowagie.text.pdf.draw.LineSeparator;
import com.lowagie.text.pdf.draw.VerticalPositionMark;
import com.microsoft.schemas.vml.CTImageData;
import com.microsoft.schemas.vml.CTShape;
import fr.opensagres.poi.xwpf.converter.core.BorderSide;
import fr.opensagres.poi.xwpf.converter.core.Color;
import fr.opensagres.poi.xwpf.converter.core.ImageShapeStyle;
import fr.opensagres.poi.xwpf.converter.core.ListItemContext;
import fr.opensagres.poi.xwpf.converter.core.MultiValueTriplet;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.core.ParagraphLineSpacing;
import fr.opensagres.poi.xwpf.converter.core.TableCellBorder;
import fr.opensagres.poi.xwpf.converter.core.TableHeight;
import fr.opensagres.poi.xwpf.converter.core.TableWidth;
import fr.opensagres.poi.xwpf.converter.core.XWPFDocumentVisitor;
import fr.opensagres.poi.xwpf.converter.core.styles.paragraph.ParagraphIndentationHangingValueProvider;
import fr.opensagres.poi.xwpf.converter.core.styles.paragraph.ParagraphIndentationLeftValueProvider;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.core.utils.StringUtils;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import fr.opensagres.poi.xwpf.converter.pdf.internal.Converter;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableAnchor;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableDocument;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableHeaderFooter;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableMasterPage;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableParagraph;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableTable;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableTableCell;
import fr.opensagres.xdocreport.itext.extension.ExtendedChunk;
import fr.opensagres.xdocreport.itext.extension.ExtendedDocument;
import fr.opensagres.xdocreport.itext.extension.ExtendedImage;
import fr.opensagres.xdocreport.itext.extension.ExtendedParagraph;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPCell;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPTable;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import fr.opensagres.xdocreport.itext.extension.font.FontGroup;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STWrapText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPTab;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPicture;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabStop;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabs;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextDirection;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTabJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTabTlc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class PdfMapper
extends XWPFDocumentVisitor<IITextContainer, PdfOptions, StylableMasterPage> {
    private static final String TAB = "\t";
    private static final Logger LOGGER = Logger.getLogger(PdfMapper.class.getName());
    private final OutputStream out;
    private StylableDocument pdfDocument;
    private Font currentRunFontAscii;
    private Font currentRunFontEastAsia;
    private Font currentRunFontHAnsi;
    private UnderlinePatterns currentRunUnderlinePatterns;
    private Color currentRunBackgroundColor;
    private Float currentRunX;
    private Float currentPageWidth;
    private StylableHeaderFooter pdfHeader;
    private StylableHeaderFooter pdfFooter;
    private Integer expectedPageCount;
    private VerticalAlign currentRunVerticalAlign = VerticalAlign.BASELINE;
    private Map<MultiValueTriplet<XWPFPictureData, Long, Long>, Image> imageCache;

    public PdfMapper(XWPFDocument document, OutputStream out, PdfOptions options, Integer expectedPageCount) throws Exception {
        super(document, (Options)(options != null ? options : PdfOptions.getDefault()));
        this.out = out;
        this.expectedPageCount = expectedPageCount;
    }

    protected IITextContainer startVisitDocument() throws Exception {
        this.pdfDocument = new StylableDocument(this.out, ((PdfOptions)this.options).getConfiguration());
        this.pdfDocument.setMasterPageManager(this.getMasterPageManager());
        return this.pdfDocument;
    }

    protected void endVisitDocument() throws Exception {
        this.pdfDocument.close();
        this.out.close();
    }

    protected IITextContainer startVisitSDT(XWPFSDT contents, IITextContainer container) {
        return null;
    }

    protected void endVisitSDT(XWPFSDT contents, IITextContainer container, IITextContainer sdtContainer) {
    }

    protected void visitSDTBody(XWPFSDT contents, IITextContainer sdtContainer) throws Exception {
    }

    protected void visitHeader(XWPFHeader header, CTHdrFtrRef headerRef, CTSectPr sectPr, StylableMasterPage masterPage) throws Exception {
        BigInteger headerY = sectPr.getPgMar() != null ? sectPr.getPgMar().getHeader() : null;
        this.currentPageWidth = sectPr.getPgMar() != null ? Float.valueOf(DxaUtil.dxa2points((BigInteger)sectPr.getPgSz().getW())) : null;
        this.pdfHeader = new StylableHeaderFooter(this.pdfDocument, headerY, true);
        List bodyElements = super.getBodyElements((XWPFHeaderFooter)header);
        StylableTableCell tableCell = this.getHeaderFooterTableCell(this.pdfHeader, bodyElements);
        this.visitBodyElements(bodyElements, (Object)tableCell);
        masterPage.setHeader(this.pdfHeader);
        this.currentPageWidth = null;
        this.pdfHeader = null;
    }

    protected void visitFooter(XWPFFooter footer, CTHdrFtrRef footerRef, CTSectPr sectPr, StylableMasterPage masterPage) throws Exception {
        BigInteger footerY = sectPr.getPgMar() != null ? sectPr.getPgMar().getFooter() : null;
        this.currentPageWidth = sectPr.getPgMar() != null ? Float.valueOf(DxaUtil.dxa2points((BigInteger)sectPr.getPgSz().getW())) : null;
        this.pdfFooter = new StylableHeaderFooter(this.pdfDocument, footerY, false);
        List bodyElements = super.getBodyElements((XWPFHeaderFooter)footer);
        StylableTableCell tableCell = this.getHeaderFooterTableCell(this.pdfFooter, bodyElements);
        this.visitBodyElements(bodyElements, (Object)tableCell);
        masterPage.setFooter(this.pdfFooter);
        this.currentPageWidth = null;
        this.pdfFooter = null;
    }

    private StylableTableCell getHeaderFooterTableCell(StylableHeaderFooter pdfHeaderFooter, List<IBodyElement> bodyElements) throws DocumentException {
        return pdfHeaderFooter.getTableCell();
    }

    public void setActiveMasterPage(StylableMasterPage masterPage) {
        this.pdfDocument.setActiveMasterPage(masterPage);
    }

    public StylableMasterPage createMasterPage(CTSectPr sectPr) {
        return new StylableMasterPage(sectPr);
    }

    protected IITextContainer startVisitParagraph(XWPFParagraph docxParagraph, ListItemContext itemContext, IITextContainer pdfParentContainer) throws Exception {
        Color backgroundColor;
        ParagraphAlignment alignment;
        ParagraphLineSpacing lineSpacing;
        Float spacingAfter;
        Float spacingBefore;
        Float indentationHanging;
        Float indentationFirstLine;
        Float indentationRight;
        this.currentRunX = null;
        StylableParagraph pdfParagraph = this.pdfDocument.createParagraph(pdfParentContainer);
        Float indentationLeft = this.stylesDocument.getIndentationLeft(docxParagraph);
        if (indentationLeft != null) {
            pdfParagraph.setIndentationLeft(indentationLeft.floatValue());
        }
        if ((indentationRight = this.stylesDocument.getIndentationRight(docxParagraph)) != null) {
            pdfParagraph.setIndentationRight(indentationRight.floatValue());
        }
        if ((indentationFirstLine = this.stylesDocument.getIndentationFirstLine(docxParagraph)) != null) {
            pdfParagraph.setFirstLineIndent(indentationFirstLine.floatValue());
        }
        if ((indentationHanging = this.stylesDocument.getIndentationHanging(docxParagraph)) != null) {
            pdfParagraph.setFirstLineIndent(-indentationHanging.floatValue());
        }
        if ((spacingBefore = this.stylesDocument.getSpacingBefore(docxParagraph)) != null) {
            pdfParagraph.setSpacingBefore(spacingBefore.floatValue());
        }
        if ((spacingAfter = this.stylesDocument.getSpacingAfter(docxParagraph)) != null) {
            pdfParagraph.setSpacingAfter(spacingAfter.floatValue());
        }
        if ((lineSpacing = this.stylesDocument.getParagraphSpacing(docxParagraph)) != null) {
            if (lineSpacing.getLeading() != null && lineSpacing.getMultipleLeading() != null) {
                pdfParagraph.setLeading(lineSpacing.getLeading().floatValue(), lineSpacing.getMultipleLeading().floatValue());
            } else {
                if (lineSpacing.getLeading() != null) {
                    pdfParagraph.setLeading(lineSpacing.getLeading().floatValue());
                }
                if (lineSpacing.getMultipleLeading() != null) {
                    pdfParagraph.setMultipliedLeading(lineSpacing.getMultipleLeading().floatValue());
                }
            }
        }
        if ((alignment = this.stylesDocument.getParagraphAlignment(docxParagraph)) != null) {
            switch (alignment) {
                case LEFT: {
                    pdfParagraph.setAlignment(0);
                    break;
                }
                case RIGHT: {
                    pdfParagraph.setAlignment(2);
                    break;
                }
                case CENTER: {
                    pdfParagraph.setAlignment(1);
                    break;
                }
                case BOTH: {
                    pdfParagraph.setAlignment(3);
                    break;
                }
            }
        }
        if ((backgroundColor = this.stylesDocument.getBackgroundColor(docxParagraph)) != null) {
            pdfParagraph.setBackgroundColor(Converter.toAwtColor(backgroundColor));
        }
        CTBorder borderTop = this.stylesDocument.getBorderTop(docxParagraph);
        pdfParagraph.setBorder(borderTop, 1);
        CTBorder borderBottom = this.stylesDocument.getBorderBottom(docxParagraph);
        pdfParagraph.setBorder(borderBottom, 2);
        CTBorder borderLeft = this.stylesDocument.getBorderLeft(docxParagraph);
        pdfParagraph.setBorder(borderLeft, 4);
        CTBorder borderRight = this.stylesDocument.getBorderRight(docxParagraph);
        pdfParagraph.setBorder(borderRight, 8);
        if (itemContext != null) {
            CTRPr lvlRPr;
            CTLvl lvl = itemContext.getLvl();
            CTPPr lvlPPr = lvl.getPPr();
            if (lvlPPr != null) {
                Float hanging;
                Float indLeft;
                if (ParagraphIndentationLeftValueProvider.INSTANCE.getValue(docxParagraph.getCTP().getPPr()) == null && (indLeft = (Float)ParagraphIndentationLeftValueProvider.INSTANCE.getValue(lvlPPr)) != null) {
                    pdfParagraph.setIndentationLeft(indLeft.floatValue());
                }
                if (ParagraphIndentationHangingValueProvider.INSTANCE.getValue(docxParagraph.getCTP().getPPr()) == null && (hanging = this.stylesDocument.getIndentationHanging(lvlPPr)) != null) {
                    pdfParagraph.setFirstLineIndent(-hanging.floatValue());
                }
            }
            if ((lvlRPr = lvl.getRPr()) != null) {
                Boolean strike;
                Boolean italic;
                String listItemFontFamily = this.stylesDocument.getFontFamilyAscii(lvlRPr);
                Float listItemFontSize = this.stylesDocument.getFontSize(lvlRPr);
                int listItemFontStyle = 0;
                Boolean bold = this.stylesDocument.getFontStyleBold(lvlRPr);
                if (bold != null && bold.booleanValue()) {
                    listItemFontStyle |= 1;
                }
                if ((italic = this.stylesDocument.getFontStyleItalic(lvlRPr)) != null && italic.booleanValue()) {
                    listItemFontStyle |= 2;
                }
                if ((strike = this.stylesDocument.getFontStyleStrike(lvlRPr)) != null && strike.booleanValue()) {
                    listItemFontStyle |= 8;
                }
                Color listItemFontColor = this.stylesDocument.getFontColor(lvlRPr);
                pdfParagraph.setListItemFontFamily(listItemFontFamily);
                pdfParagraph.setListItemFontSize(listItemFontSize);
                pdfParagraph.setListItemFontStyle(listItemFontStyle);
                pdfParagraph.setListItemFontColor(Converter.toAwtColor(listItemFontColor));
            }
            pdfParagraph.setListItemText(itemContext.getText());
        }
        return pdfParagraph;
    }

    protected void endVisitParagraph(XWPFParagraph docxParagraph, IITextContainer pdfParentContainer, IITextContainer pdfParagraphContainer) throws Exception {
        ExtendedParagraph pdfParagraph = (ExtendedParagraph)pdfParagraphContainer;
        pdfParentContainer.addElement(pdfParagraph.getElement());
        this.currentRunX = null;
    }

    protected void visitEmptyRun(IITextContainer pdfParagraphContainer) throws Exception {
        StylableTableCell cell;
        StylableParagraph paragraph = (StylableParagraph)pdfParagraphContainer;
        IITextContainer parent = paragraph.getParent();
        if (parent instanceof StylableTableCell && (cell = (StylableTableCell)parent).getRotation() > 0) {
            return;
        }
        pdfParagraphContainer.addElement((Element)Chunk.NEWLINE);
    }

    protected void visitRun(XWPFRun docxRun, boolean pageNumber, String url, IITextContainer pdfParagraphContainer) throws Exception {
        Boolean strike;
        Boolean italic;
        String fontFamilyAscii = this.stylesDocument.getFontFamilyAscii(docxRun);
        String fontFamilyEastAsia = this.stylesDocument.getFontFamilyEastAsia(docxRun);
        String fontFamilyHAnsi = this.stylesDocument.getFontFamilyHAnsi(docxRun);
        Float fontSize = this.stylesDocument.getFontSize(docxRun);
        if (fontSize == null) {
            fontSize = Float.valueOf(-1.0f);
        }
        int fontStyle = 0;
        Boolean bold = this.stylesDocument.getFontStyleBold(docxRun);
        if (bold != null && bold.booleanValue()) {
            fontStyle |= 1;
        }
        if ((italic = this.stylesDocument.getFontStyleItalic(docxRun)) != null && italic.booleanValue()) {
            fontStyle |= 2;
        }
        if ((strike = this.stylesDocument.getFontStyleStrike(docxRun)) != null && strike.booleanValue()) {
            fontStyle |= 8;
        }
        Color fontColor = this.stylesDocument.getFontColor(docxRun);
        this.currentRunVerticalAlign = this.stylesDocument.getVerticalAlign(docxRun);
        switch (this.currentRunVerticalAlign) {
            case SUBSCRIPT: 
            case SUPERSCRIPT: {
                fontSize = Float.valueOf(fontSize.floatValue() * this.stylesDocument.getVerticalAlignFontFactor());
            }
        }
        this.currentRunFontAscii = this.getFont(fontFamilyAscii, fontSize, fontStyle, fontColor);
        this.currentRunFontEastAsia = this.getFont(fontFamilyEastAsia, fontSize, fontStyle, fontColor);
        this.currentRunFontHAnsi = this.getFont(fontFamilyHAnsi, fontSize, fontStyle, fontColor);
        this.currentRunUnderlinePatterns = this.stylesDocument.getUnderline(docxRun);
        this.currentRunBackgroundColor = this.stylesDocument.getBackgroundColor(docxRun);
        if (this.currentRunBackgroundColor == null) {
            this.currentRunBackgroundColor = this.stylesDocument.getTextHighlighting(docxRun);
        }
        StylableParagraph pdfParagraph = (StylableParagraph)pdfParagraphContainer;
        pdfParagraph.adjustMultipliedLeading(this.currentRunFontAscii);
        String listItemText = pdfParagraph.getListItemText();
        if (StringUtils.isNotEmpty((String)listItemText)) {
            listItemText = listItemText + "    ";
            String listItemFontFamily = pdfParagraph.getListItemFontFamily();
            Float listItemFontSize = pdfParagraph.getListItemFontSize();
            int listItemFontStyle = pdfParagraph.getListItemFontStyle();
            java.awt.Color listItemFontColor = pdfParagraph.getListItemFontColor();
            Font listItemFont = ((PdfOptions)this.options).getFontProvider().getFont(listItemFontFamily != null ? listItemFontFamily : fontFamilyAscii, ((PdfOptions)this.options).getFontEncoding(), (listItemFontSize != null ? listItemFontSize : fontSize).floatValue(), listItemFontStyle != 0 ? listItemFontStyle : fontStyle, listItemFontColor != null ? listItemFontColor : Converter.toAwtColor(fontColor));
            Chunk symbol = this.createTextChunk(listItemText, false, listItemFont, this.currentRunUnderlinePatterns, this.currentRunBackgroundColor);
            pdfParagraph.add(symbol);
            pdfParagraph.setListItemText(null);
        }
        IITextContainer container = pdfParagraphContainer;
        if (url != null) {
            StylableAnchor pdfAnchor = new StylableAnchor();
            pdfAnchor.setReference(url);
            pdfAnchor.setITextContainer(container);
            container = pdfAnchor;
        }
        super.visitRun(docxRun, pageNumber, url, (Object)container);
        if (url != null) {
            pdfParagraphContainer.addElement((Element)((StylableAnchor)container));
        }
        this.currentRunFontAscii = null;
        this.currentRunFontEastAsia = null;
        this.currentRunFontHAnsi = null;
        this.currentRunUnderlinePatterns = null;
        this.currentRunBackgroundColor = null;
        this.currentRunVerticalAlign = VerticalAlign.BASELINE;
    }

    protected boolean hasTextStyles(CTRPr rPr) {
        return rPr != null && (rPr.getHighlight() != null || rPr.getDstrike() != null);
    }

    private Font getFont(String fontFamily, Float fontSize, int fontStyle, Color fontColor) {
        String fontToUse = this.stylesDocument.getFontNameToUse(fontFamily);
        if (StringUtils.isNotEmpty((String)fontToUse)) {
            return ((PdfOptions)this.options).getFontProvider().getFont(fontToUse, ((PdfOptions)this.options).getFontEncoding(), fontSize.floatValue(), fontStyle, Converter.toAwtColor(fontColor));
        }
        Font font = ((PdfOptions)this.options).getFontProvider().getFont(fontFamily, ((PdfOptions)this.options).getFontEncoding(), fontSize.floatValue(), fontStyle, Converter.toAwtColor(fontColor));
        if (!this.isFontExists(font)) {
            try {
                List altNames = this.stylesDocument.getFontsAltName(fontFamily);
                if (altNames != null) {
                    for (String altName : altNames) {
                        if (fontFamily.equals(altName) || !this.isFontExists(font = this.getFont(altName, fontSize, fontStyle, fontColor))) continue;
                        this.stylesDocument.setFontNameToUse(fontFamily, altName);
                        return font;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }
        return font;
    }

    private boolean isFontExists(Font font) {
        return font != null && font.getBaseFont() != null;
    }

    protected void visitStyleText(XWPFRun run, String text, IITextContainer paragraphContainer, boolean pageNumber) throws Exception {
        this.createAndAddChunks(paragraphContainer, text, this.currentRunUnderlinePatterns, this.currentRunBackgroundColor, pageNumber, this.currentRunFontAscii, this.currentRunFontEastAsia, this.currentRunFontHAnsi);
    }

    protected void visitText(CTText docxText, boolean pageNumber, IITextContainer pdfParagraphContainer) throws Exception {
        Font font = this.currentRunFontAscii;
        Font fontAsian = this.currentRunFontEastAsia;
        Font fontComplex = this.currentRunFontHAnsi;
        this.createAndAddChunks(pdfParagraphContainer, docxText.getStringValue(), this.currentRunUnderlinePatterns, this.currentRunBackgroundColor, pageNumber, font, fontAsian, fontComplex);
    }

    private Chunk createTextChunk(String text, boolean pageNumber, Font currentRunFont, UnderlinePatterns currentRunUnderlinePatterns, Color currentRunBackgroundColor) {
        ExtendedChunk textChunk = null;
        if (this.processingTotalPageCountField && this.expectedPageCount != null) {
            textChunk = new Chunk(String.valueOf(this.expectedPageCount), currentRunFont);
        } else {
            Object object = textChunk = pageNumber ? new ExtendedChunk((ExtendedDocument)this.pdfDocument, true, currentRunFont) : new Chunk(text, currentRunFont);
        }
        if (currentRunUnderlinePatterns != null) {
            boolean singleUnderlined = false;
            switch (currentRunUnderlinePatterns) {
                case SINGLE: {
                    singleUnderlined = true;
                    break;
                }
            }
            if (singleUnderlined) {
                textChunk.setUnderline(1.0f, -2.0f);
            }
        }
        if (currentRunBackgroundColor != null) {
            textChunk.setBackground(Converter.toAwtColor(currentRunBackgroundColor));
        }
        if (this.currentRunX != null) {
            PdfMapper pdfMapper = this;
            pdfMapper.currentRunX = Float.valueOf(pdfMapper.currentRunX.floatValue() + textChunk.getWidthPoint());
        }
        switch (this.currentRunVerticalAlign) {
            case SUBSCRIPT: {
                textChunk.setTextRise(-currentRunFont.getSize() * this.stylesDocument.getVerticalAlignOffset());
                break;
            }
            case SUPERSCRIPT: {
                textChunk.setTextRise(currentRunFont.getSize() * this.stylesDocument.getVerticalAlignOffset());
            }
        }
        return textChunk;
    }

    private void createAndAddChunks(IITextContainer parent, String textContent, UnderlinePatterns underlinePatterns, Color backgroundColor, boolean pageNumber, Font font, Font fontAsian, Font fontComplex) {
        StringBuilder sbuf = new StringBuilder();
        FontGroup currentGroup = FontGroup.WESTERN;
        for (int i = 0; i < textContent.length(); ++i) {
            char ch = textContent.charAt(i);
            FontGroup group = FontGroup.getUnicodeGroup((char)ch, (Font)font, (Font)fontAsian, (Font)fontComplex);
            if (sbuf.length() == 0 || currentGroup.equals((Object)group)) {
                sbuf.append(ch);
            } else {
                Font chunkFont = this.getFont(font, fontAsian, fontComplex, currentGroup);
                Chunk chunk = this.createTextChunk(sbuf.toString(), pageNumber, chunkFont, underlinePatterns, backgroundColor);
                parent.addElement((Element)chunk);
                sbuf.setLength(0);
                sbuf.append(ch);
            }
            currentGroup = group;
        }
        Font chunkFont = this.getFont(font, fontAsian, fontComplex, currentGroup);
        Chunk chunk = this.createTextChunk(textContent.isEmpty() ? " " : sbuf.toString(), pageNumber, chunkFont, underlinePatterns, backgroundColor);
        parent.addElement((Element)chunk);
    }

    private Font getFont(Font font, Font fontAsian, Font fontComplex, FontGroup group) {
        switch (group) {
            case WESTERN: {
                return font;
            }
            case ASIAN: {
                return fontAsian;
            }
            case COMPLEX: {
                return fontComplex;
            }
        }
        return font;
    }

    protected void visitTab(CTPTab tab, IITextContainer pdfParagraphContainer) throws Exception {
    }

    protected void visitTabs(CTTabs tabs, IITextContainer pdfParagraphContainer) throws Exception {
        List tabList;
        CTTabStop tabStop;
        if (this.currentRunX == null) {
            Paragraph paragraph = null;
            paragraph = pdfParagraphContainer instanceof Paragraph ? (Paragraph)pdfParagraphContainer : (Paragraph)((StylableAnchor)pdfParagraphContainer).getITextContainer();
            this.currentRunX = Float.valueOf(paragraph.getFirstLineIndent());
            ArrayList chunks = paragraph.getChunks();
            for (Chunk chunk : chunks) {
                this.currentRunX = Float.valueOf(this.currentRunX.floatValue() + chunk.getWidthPoint());
            }
        } else if (this.currentRunX.floatValue() >= this.pdfDocument.getPageWidth()) {
            this.currentRunX = Float.valueOf(0.0f);
        }
        Float tabPosition = null;
        STTabTlc.Enum tabLeader = null;
        STTabJc.Enum tabVal = null;
        boolean useDefaultTabStop = false;
        if (tabs != null && (tabStop = this.getTabStop(tabList = tabs.getTabList())) != null) {
            float lastX = DxaUtil.dxa2points((float)tabStop.getPos().floatValue());
            if (lastX > this.currentRunX.floatValue()) {
                tabPosition = Float.valueOf(lastX);
                tabLeader = tabStop.getLeader();
                tabVal = tabStop.getVal();
            } else {
                useDefaultTabStop = true;
            }
        }
        if (tabs == null || useDefaultTabStop) {
            float defaultTabStop = this.stylesDocument.getDefaultTabStop();
            float pageWidth = this.pdfDocument.getPageWidth();
            int nbInterval = (int)(pageWidth / defaultTabStop);
            Float lastX = this.getTabStopPosition(this.currentRunX.floatValue(), defaultTabStop, nbInterval);
            if (lastX != null) {
                tabPosition = lastX;
            }
        }
        if (tabPosition != null) {
            this.currentRunX = tabPosition;
            VerticalPositionMark mark = this.createVerticalPositionMark(tabLeader);
            Chunk pdfTab = null;
            pdfTab = STTabJc.RIGHT.equals(tabVal) ? new Chunk((DrawInterface)mark) : new Chunk((DrawInterface)mark, this.currentRunX.floatValue());
            pdfParagraphContainer.addElement((Element)pdfTab);
        }
    }

    private Float getTabStopPosition(float currentPosition, float interval, int nbInterval) {
        Float nextPosition = null;
        float newPosition = 0.0f;
        for (int i = 1; i < nbInterval; ++i) {
            newPosition = interval * (float)i;
            if (!(currentPosition < newPosition)) continue;
            nextPosition = Float.valueOf(newPosition);
            break;
        }
        return nextPosition;
    }

    private VerticalPositionMark createVerticalPositionMark(STTabTlc.Enum leader) {
        if (leader != null) {
            if (leader == STTabTlc.DOT) {
                return new DottedLineSeparator();
            }
            if (leader == STTabTlc.UNDERSCORE) {
                return new LineSeparator();
            }
        }
        return new VerticalPositionMark();
    }

    private CTTabStop getTabStop(List<CTTabStop> tabList) {
        if (tabList.size() == 1) {
            CTTabStop tabStop = tabList.get(0);
            if (this.isClearTab(tabStop)) {
                return null;
            }
            return tabStop;
        }
        Object selectedTabStop = null;
        for (CTTabStop tabStop : tabList) {
            if (this.isClearTab(tabStop) || !this.canApplyTabStop(tabStop)) continue;
            return tabStop;
        }
        return null;
    }

    private boolean canApplyTabStop(CTTabStop tabStop) {
        if (tabStop.getVal().equals(STTabJc.LEFT)) {
            if (this.currentRunX.floatValue() < DxaUtil.dxa2points((float)tabStop.getPos().floatValue())) {
                return true;
            }
        } else if (tabStop.getVal().equals(STTabJc.RIGHT)) {
            if (this.isWordDocumentPartParsing()) {
                if (this.pdfDocument.getWidthLimit() - (this.currentRunX.floatValue() + DxaUtil.dxa2points((float)tabStop.getPos().floatValue())) <= 0.0f) {
                    return true;
                }
            } else {
                if (this.currentPageWidth == null) {
                    return true;
                }
                if (this.currentPageWidth.floatValue() - (this.currentRunX.floatValue() + DxaUtil.dxa2points((float)tabStop.getPos().floatValue())) <= 0.0f) {
                    return true;
                }
            }
        } else if (tabStop.getVal().equals(STTabJc.CENTER)) {
            // empty if block
        }
        return false;
    }

    private boolean isClearTab(CTTabStop tabStop) {
        STTabJc.Enum tabVal = tabStop.getVal();
        return tabVal != null && tabVal.equals(STTabJc.CLEAR);
    }

    protected void addNewLine(CTBr br, IITextContainer pdfParagraphContainer) throws Exception {
        pdfParagraphContainer.addElement((Element)Chunk.NEWLINE);
    }

    protected void visitBR(CTBr br, IITextContainer paragraphContainer) throws Exception {
        this.currentRunX = Float.valueOf(0.0f);
        super.visitBR(br, (Object)paragraphContainer);
    }

    protected void pageBreak() throws Exception {
        this.pdfDocument.pageBreak();
    }

    protected void visitBookmark(CTBookmark bookmark, XWPFParagraph paragraph, IITextContainer paragraphContainer) throws Exception {
        Chunk chunk = new Chunk(TAB);
        chunk.setLocalDestination(bookmark.getName());
        paragraphContainer.addElement((Element)chunk);
    }

    protected IITextContainer startVisitTable(XWPFTable table, float[] colWidths, IITextContainer pdfParentContainer) throws Exception {
        StylableTable pdfPTable = this.createPDFTable(table, colWidths, pdfParentContainer);
        return pdfPTable;
    }

    private StylableTable createPDFTable(XWPFTable table, float[] colWidths, IITextContainer pdfParentContainer) throws DocumentException {
        Float indentation;
        TableWidth tableWidth = this.stylesDocument.getTableWidth(table);
        StylableTable pdfPTable = this.pdfDocument.createTable(pdfParentContainer, colWidths.length);
        pdfPTable.setTotalWidth(colWidths);
        if (tableWidth != null && tableWidth.width > 0.0f) {
            if (tableWidth.percentUnit) {
                pdfPTable.setWidthPercentage(tableWidth.width);
            } else {
                pdfPTable.setTotalWidth(tableWidth.width);
            }
        }
        pdfPTable.setLockedWidth(true);
        ParagraphAlignment alignment = this.stylesDocument.getTableAlignment(table);
        if (alignment != null) {
            switch (alignment) {
                case LEFT: {
                    pdfPTable.setHorizontalAlignment(0);
                    break;
                }
                case RIGHT: {
                    pdfPTable.setHorizontalAlignment(2);
                    break;
                }
                case CENTER: {
                    pdfPTable.setHorizontalAlignment(1);
                    break;
                }
                case BOTH: {
                    pdfPTable.setHorizontalAlignment(3);
                    break;
                }
            }
        }
        if ((indentation = this.stylesDocument.getTableIndentation(table)) != null) {
            pdfPTable.setPaddingLeft(indentation.floatValue());
        }
        return pdfPTable;
    }

    protected void endVisitTable(XWPFTable table, IITextContainer pdfParentContainer, IITextContainer pdfTableContainer) throws Exception {
        pdfParentContainer.addElement(((ExtendedPdfPTable)pdfTableContainer).getElement());
    }

    protected void startVisitTableRow(XWPFTableRow row, IITextContainer tableContainer, int rowIndex, boolean headerRow) throws Exception {
        if (headerRow) {
            PdfPTable table = (PdfPTable)tableContainer;
            table.setHeaderRows(table.getHeaderRows() + 1);
        }
        super.startVisitTableRow(row, (Object)tableContainer, rowIndex, headerRow);
    }

    protected IITextContainer startVisitTableCell(XWPFTableCell cell, IITextContainer pdfTableContainer, boolean firstRow, boolean lastRow, boolean firstCol, boolean lastCol, List<XWPFTableCell> vMergeCells) throws Exception {
        Boolean noWrap;
        TableHeight tableHeight;
        Float marginRight;
        Float marginLeft;
        Float marginBottom;
        Float marginTop;
        STVerticalJc.Enum jc;
        Color backgroundColor;
        BigInteger gridSpan;
        XWPFTableRow row = cell.getTableRow();
        XWPFTable table = row.getTable();
        this.stylesDocument.getTableInfo(table).addCellInfo(cell, firstRow, lastRow, firstCol, lastCol);
        StylableTable pdfPTable = (StylableTable)pdfTableContainer;
        StylableTableCell pdfPCell = this.pdfDocument.createTableCell(pdfPTable);
        XWPFTableCell lastVMergedCell = null;
        if (vMergeCells != null) {
            pdfPCell.setRowspan(vMergeCells.size());
            lastVMergedCell = vMergeCells.get(vMergeCells.size() - 1);
            this.stylesDocument.getTableInfo(table).addCellInfo(lastVMergedCell, false, lastRow, firstCol, lastCol);
        }
        XWPFTableCell theCell = lastVMergedCell != null ? lastVMergedCell : cell;
        pdfPCell.setBorderTop(this.stylesDocument.getTableCellBorderWithConflicts(cell, BorderSide.TOP), this.stylesDocument.isBorderInside(theCell, BorderSide.TOP));
        TableCellBorder borderBottom = this.stylesDocument.getTableCellBorderWithConflicts(theCell, BorderSide.BOTTOM);
        pdfPCell.setBorderBottom(borderBottom, this.stylesDocument.isBorderInside(theCell, BorderSide.BOTTOM));
        TableCellBorder borderLeft = this.stylesDocument.getTableCellBorderWithConflicts(cell, BorderSide.LEFT);
        pdfPCell.setBorderLeft(borderLeft, this.stylesDocument.isBorderInside(cell, BorderSide.LEFT));
        TableCellBorder borderRight = this.stylesDocument.getTableCellBorderWithConflicts(cell, BorderSide.RIGHT);
        pdfPCell.setBorderRight(borderRight, this.stylesDocument.isBorderInside(cell, BorderSide.RIGHT));
        CTTextDirection direction = this.stylesDocument.getTextDirection(cell);
        if (direction != null) {
            int dir = direction.getVal().intValue();
            switch (dir) {
                case 3: {
                    pdfPCell.setRotation(90);
                    break;
                }
                case 2: {
                    pdfPCell.setRotation(270);
                }
            }
        }
        if ((gridSpan = this.stylesDocument.getTableCellGridSpan(cell)) != null) {
            pdfPCell.setColspan(gridSpan.intValue());
        }
        if ((backgroundColor = this.stylesDocument.getTableCellBackgroundColor(cell)) != null) {
            pdfPCell.setBackgroundColor(Converter.toAwtColor(backgroundColor));
        }
        if ((jc = this.stylesDocument.getTableCellVerticalAlignment(cell)) != null) {
            switch (jc.intValue()) {
                case 4: {
                    pdfPCell.setVerticalAlignment(6);
                    break;
                }
                case 2: {
                    pdfPCell.setVerticalAlignment(5);
                    break;
                }
                case 1: {
                    pdfPCell.setVerticalAlignment(4);
                }
            }
        }
        if ((marginTop = this.stylesDocument.getTableCellMarginTop(cell)) == null && (marginTop = this.stylesDocument.getTableRowMarginTop(row)) == null) {
            marginTop = this.stylesDocument.getTableMarginTop(table);
        }
        if (marginTop != null) {
            pdfPCell.setPaddingTop(marginTop.floatValue());
        }
        if ((marginBottom = this.stylesDocument.getTableCellMarginBottom(cell)) == null && (marginBottom = this.stylesDocument.getTableRowMarginBottom(row)) == null) {
            marginBottom = this.stylesDocument.getTableMarginBottom(table);
        }
        if (marginBottom != null) {
            pdfPCell.setPaddingBottom(marginBottom.floatValue());
        }
        if ((marginLeft = this.stylesDocument.getTableCellMarginLeft(cell)) == null && (marginLeft = this.stylesDocument.getTableRowMarginLeft(row)) == null) {
            marginLeft = this.stylesDocument.getTableMarginLeft(table);
        }
        if (marginLeft != null) {
            pdfPCell.setPaddingLeft(marginLeft.floatValue());
        }
        if ((marginRight = this.stylesDocument.getTableCellMarginRight(cell)) == null && (marginRight = this.stylesDocument.getTableRowMarginRight(row)) == null) {
            marginRight = this.stylesDocument.getTableMarginRight(table);
        }
        if (marginRight != null) {
            pdfPCell.setPaddingRight(marginRight.floatValue());
        }
        if ((tableHeight = this.stylesDocument.getTableRowHeight(row)) != null) {
            if (tableHeight.minimum) {
                pdfPCell.setMinimumHeight(tableHeight.height);
            } else {
                pdfPCell.setFixedHeight(tableHeight.height);
            }
        }
        if ((noWrap = this.stylesDocument.getTableCellNoWrap(cell)) != null) {
            pdfPCell.setNoWrap(noWrap);
        }
        return pdfPCell;
    }

    protected void endVisitTableCell(XWPFTableCell cell, IITextContainer tableContainer, IITextContainer tableCellContainer) {
        ExtendedPdfPTable pdfPTable = (ExtendedPdfPTable)tableContainer;
        ExtendedPdfPCell pdfPCell = (ExtendedPdfPCell)tableCellContainer;
        pdfPTable.addCell((PdfPCell)pdfPCell);
    }

    protected void visitVmlPicture(CTPicture picture, IITextContainer pdfParentContainer) throws Exception {
        XmlCursor pictureCur = picture.newCursor();
        pictureCur.selectPath("./*");
        while (pictureCur.toNextSelection()) {
            XmlObject obj = pictureCur.getObject();
            if (!(obj instanceof CTShape)) continue;
            CTShape shape = (CTShape)obj;
            List imagedataList = shape.getImagedataList();
            for (CTImageData imageData : imagedataList) {
                XWPFPictureData pictureData = this.getPictureDataByID(imageData.getId2());
                this.visitVmlPicture(pictureData, shape.getStyle(), pdfParentContainer);
            }
        }
        pictureCur.dispose();
    }

    protected void visitVmlPicture(XWPFPictureData pictureData, String style, IITextContainer pdfParentContainer) {
        if (pictureData == null) {
            return;
        }
        try {
            Image img = Image.getInstance((byte[])pictureData.getData());
            ImageShapeStyle imageStyle = ImageShapeStyle.parse((String)style);
            img.scaleAbsolute(imageStyle.getWidth(), imageStyle.getHeight());
            IITextContainer parentOfParentContainer = pdfParentContainer.getITextContainer();
            if (parentOfParentContainer != null && parentOfParentContainer instanceof PdfPCell) {
                pdfParentContainer.addElement((Element)img);
            } else {
                float chunkOffsetX = 0.0f;
                float chunkOffsetY = 0.0f;
                if (pdfParentContainer instanceof Paragraph) {
                    Paragraph paragraph = (Paragraph)pdfParentContainer;
                    paragraph.setSpacingBefore(paragraph.getSpacingBefore() + 5.0f);
                }
                pdfParentContainer.addElement((Element)new Chunk(img, chunkOffsetX, chunkOffsetY, false));
            }
        }
        catch (Exception ex) {
            LOGGER.severe(ex.getMessage());
        }
    }

    protected void visitPicture(org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture picture, Float offsetX, STRelFromH.Enum relativeFromH, Float offsetY, STRelFromV.Enum relativeFromV, STWrapText.Enum wrapText, IITextContainer pdfParentContainer) throws Exception {
        CTPositiveSize2D ext = picture.getSpPr().getXfrm().getExt();
        long x = ext.getCx();
        long y = ext.getCy();
        XWPFPictureData pictureData = super.getPictureData(picture);
        if (pictureData != null) {
            try {
                IITextContainer parentOfParentContainer;
                MultiValueTriplet key;
                Image img;
                if (this.imageCache == null) {
                    this.imageCache = new HashMap<MultiValueTriplet<XWPFPictureData, Long, Long>, Image>();
                }
                if ((img = this.imageCache.get(key = new MultiValueTriplet((Object)pictureData, (Object)x, (Object)y))) == null) {
                    img = Image.getInstance((byte[])pictureData.getData());
                    this.imageCache.put((MultiValueTriplet<XWPFPictureData, Long, Long>)key, img);
                    img.scaleAbsolute(DxaUtil.emu2points((long)x), DxaUtil.emu2points((long)y));
                }
                if ((parentOfParentContainer = pdfParentContainer.getITextContainer()) != null && parentOfParentContainer instanceof PdfPCell) {
                    parentOfParentContainer.addElement((Element)img);
                } else {
                    float chunkOffsetX = 0.0f;
                    if (offsetX != null) {
                        if (STRelFromH.CHARACTER.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.COLUMN.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.INSIDE_MARGIN.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.LEFT_MARGIN.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.MARGIN.equals(relativeFromH)) {
                            chunkOffsetX = this.pdfDocument.left() + offsetX.floatValue();
                        } else if (STRelFromH.OUTSIDE_MARGIN.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue();
                        } else if (STRelFromH.PAGE.equals(relativeFromH)) {
                            chunkOffsetX = offsetX.floatValue() - this.pdfDocument.left();
                        }
                    }
                    float chunkOffsetY = 0.0f;
                    boolean useExtendedImage = false;
                    if (STRelFromV.PARAGRAPH.equals(relativeFromV)) {
                        useExtendedImage = true;
                    }
                    if (useExtendedImage) {
                        ExtendedImage extImg = new ExtendedImage(img, -offsetY.floatValue());
                        if (STRelFromV.PARAGRAPH.equals(relativeFromV)) {
                            chunkOffsetY = -extImg.getScaledHeight();
                        }
                        Chunk chunk = new Chunk((Image)extImg, chunkOffsetX, chunkOffsetY, false);
                        pdfParentContainer.addElement((Element)chunk);
                    } else {
                        if (pdfParentContainer instanceof Paragraph) {
                            Paragraph paragraph = (Paragraph)pdfParentContainer;
                            paragraph.setSpacingBefore(paragraph.getSpacingBefore() + 5.0f);
                        }
                        pdfParentContainer.addElement((Element)new Chunk(img, chunkOffsetX, chunkOffsetY, false));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    public int getPageCount() {
        if (this.pdfDocument.isOpen()) {
            return this.pdfDocument.getPageNumber();
        }
        return this.pdfDocument.getPageNumber() - 1;
    }

    public boolean useTotalPageField() {
        return this.totalPageFieldUsed;
    }
}

