/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.publisher.apache;

import eu.maveniverse.maven.njord.publisher.apache.ApachePublisherConfig;
import eu.maveniverse.maven.njord.publisher.sonatype.SonatypeCentralRequirementsFactory;
import eu.maveniverse.maven.njord.publisher.sonatype.SonatypeNx2Publisher;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.publisher.MavenCentralPublisherFactory;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;

@Singleton
@Named(value="apache-rao")
public class ApacheRaoPublisherFactory
implements MavenCentralPublisherFactory {
    public static final String NAME = "apache-rao";
    private final RepositorySystem repositorySystem;
    private final SonatypeCentralRequirementsFactory centralRequirementsFactory;

    @Inject
    public ApacheRaoPublisherFactory(RepositorySystem repositorySystem, SonatypeCentralRequirementsFactory centralRequirementsFactory) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.centralRequirementsFactory = Objects.requireNonNull(centralRequirementsFactory);
    }

    public SonatypeNx2Publisher create(Session session) {
        ApachePublisherConfig raoConfig = new ApachePublisherConfig(session.config());
        RemoteRepository releasesRepository = raoConfig.releaseRepositoryId() != null && raoConfig.releaseRepositoryUrl() != null ? new RemoteRepository.Builder(raoConfig.releaseRepositoryId(), "default", raoConfig.releaseRepositoryUrl()).setSnapshotPolicy(new RepositoryPolicy(false, null, null)).build() : null;
        RemoteRepository snapshotsRepository = raoConfig.snapshotRepositoryId() != null && raoConfig.snapshotRepositoryUrl() != null ? new RemoteRepository.Builder(raoConfig.snapshotRepositoryId(), "default", raoConfig.snapshotRepositoryUrl()).setReleasePolicy(new RepositoryPolicy(false, null, null)).build() : null;
        return new SonatypeNx2Publisher(session, this.repositorySystem, NAME, "Publishes to ASF RAO", CENTRAL, snapshotsRepository, releasesRepository, snapshotsRepository, this.centralRequirementsFactory.create(session));
    }
}

