/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.diagnostic;

import eu.europa.esig.dss.diagnostic.jaxb.XmlAuthorityInformationAccess;
import eu.europa.esig.dss.diagnostic.jaxb.XmlAuthorityKeyIdentifier;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicConstraints;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCRLDistributionPoints;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateExtension;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificatePolicies;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificatePolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDistinguishedName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlEncapsulationType;
import eu.europa.esig.dss.diagnostic.jaxb.XmlExtendedKeyUsages;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundCertificates;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFreshestCRL;
import eu.europa.esig.dss.diagnostic.jaxb.XmlGeneralName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlGeneralSubtree;
import eu.europa.esig.dss.diagnostic.jaxb.XmlIdPkixOcspNoCheck;
import eu.europa.esig.dss.diagnostic.jaxb.XmlInhibitAnyPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlIssuerEntityKey;
import eu.europa.esig.dss.diagnostic.jaxb.XmlIssuerSerial;
import eu.europa.esig.dss.diagnostic.jaxb.XmlKeyUsages;
import eu.europa.esig.dss.diagnostic.jaxb.XmlNameConstraints;
import eu.europa.esig.dss.diagnostic.jaxb.XmlNoRevAvail;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificateToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocationToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanTokens;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicyConstraints;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocationRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlStructuralValidation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSubjectAlternativeNames;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSubjectKeyIdentifier;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustServiceProvider;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrusted;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.diagnostic.jaxb.XmlValAssuredShortTermCertificate;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureValidity;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.OidRepository;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.identifier.OriginalIdentifierProvider;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.tsl.CertificateTrustTime;
import eu.europa.esig.dss.model.tsl.DownloadInfoRecord;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.model.tsl.TrustProperties;
import eu.europa.esig.dss.model.tsl.TrustPropertiesCertificateSource;
import eu.europa.esig.dss.model.tsl.TrustedCertificateSourceWithTime;
import eu.europa.esig.dss.model.tsl.ValidationInfoRecord;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.TokenComparator;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.model.x509.extension.AuthorityInformationAccess;
import eu.europa.esig.dss.model.x509.extension.AuthorityKeyIdentifier;
import eu.europa.esig.dss.model.x509.extension.BasicConstraints;
import eu.europa.esig.dss.model.x509.extension.CRLDistributionPoints;
import eu.europa.esig.dss.model.x509.extension.CertificateExtension;
import eu.europa.esig.dss.model.x509.extension.CertificateExtensions;
import eu.europa.esig.dss.model.x509.extension.CertificatePolicies;
import eu.europa.esig.dss.model.x509.extension.CertificatePolicy;
import eu.europa.esig.dss.model.x509.extension.ExtendedKeyUsages;
import eu.europa.esig.dss.model.x509.extension.FreshestCRL;
import eu.europa.esig.dss.model.x509.extension.GeneralName;
import eu.europa.esig.dss.model.x509.extension.GeneralSubtree;
import eu.europa.esig.dss.model.x509.extension.InhibitAnyPolicy;
import eu.europa.esig.dss.model.x509.extension.KeyUsage;
import eu.europa.esig.dss.model.x509.extension.NameConstraints;
import eu.europa.esig.dss.model.x509.extension.NoRevAvail;
import eu.europa.esig.dss.model.x509.extension.OCSPNoCheck;
import eu.europa.esig.dss.model.x509.extension.PolicyConstraints;
import eu.europa.esig.dss.model.x509.extension.SubjectAlternativeNames;
import eu.europa.esig.dss.model.x509.extension.SubjectKeyIdentifier;
import eu.europa.esig.dss.model.x509.extension.ValidityAssuredShortTerm;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSPKUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.SignatureCertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateTokenRefMatcher;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import eu.europa.esig.dss.spi.x509.TokenIssuerSelector;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.diagnostic.XmlQcStatementsBuilder;
import eu.europa.esig.dss.validation.reports.diagnostic.XmlTrustServiceProviderBuilder;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiagnosticDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosticDataBuilder.class);
    protected Set<CertificateToken> usedCertificates;
    protected Set<RevocationToken<?>> usedRevocations;
    protected ListCertificateSource allCertificateSources = new ListCertificateSource();
    protected Date validationDate;
    protected TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    protected DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    protected TokenIdentifierProvider identifierProvider = new OriginalIdentifierProvider();
    protected Map<String, XmlCertificate> xmlCertsMap = new HashMap<String, XmlCertificate>();
    protected Map<String, XmlRevocation> xmlRevocationsMap = new HashMap<String, XmlRevocation>();
    protected Map<String, XmlTrustedList> xmlTrustedListsMap = new HashMap<String, XmlTrustedList>();
    protected Map<String, XmlOrphanCertificateToken> xmlOrphanCertificateTokensMap = new HashMap<String, XmlOrphanCertificateToken>();
    protected Map<String, XmlOrphanRevocationToken> xmlOrphanRevocationTokensMap = new HashMap<String, XmlOrphanRevocationToken>();
    protected Map<String, String> referenceMap = new HashMap<String, String>();
    protected Map<String, CertificateToken> certificateIdsMap = new HashMap<String, CertificateToken>();
    protected Map<String, CertificateToken> signingCertificateMap = new HashMap<String, CertificateToken>();
    protected Map<String, TLInfo> tlInfoMap = new HashMap<String, TLInfo>();

    protected DiagnosticDataBuilder() {
    }

    public DiagnosticDataBuilder usedCertificates(Set<CertificateToken> usedCertificates) {
        this.usedCertificates = usedCertificates;
        return this;
    }

    public DiagnosticDataBuilder usedRevocations(Set<RevocationToken<?>> usedRevocations) {
        this.usedRevocations = usedRevocations;
        return this;
    }

    public DiagnosticDataBuilder allCertificateSources(ListCertificateSource allCertificateSources) {
        if (allCertificateSources != null && !allCertificateSources.containsTrustedCertSources()) {
            LOG.warn("Provided CertificateSource configuration contains none of trusted sources of type TRUSTED_STORE or TRUSTED_LIST!");
        }
        this.allCertificateSources = allCertificateSources;
        return this;
    }

    public DiagnosticDataBuilder validationDate(Date validationDate) {
        this.validationDate = validationDate;
        return this;
    }

    public DiagnosticDataBuilder tokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        this.tokenExtractionStrategy = tokenExtractionStrategy;
        return this;
    }

    public DiagnosticDataBuilder tokenIdentifierProvider(TokenIdentifierProvider identifierProvider) {
        this.identifierProvider = identifierProvider;
        return this;
    }

    public DiagnosticDataBuilder defaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.defaultDigestAlgorithm = digestAlgorithm;
        return this;
    }

    public XmlDiagnosticData build() {
        XmlDiagnosticData diagnosticData = new XmlDiagnosticData();
        diagnosticData.setValidationDate(this.validationDate);
        Collection<XmlCertificate> xmlCertificates = this.buildXmlCertificates(this.usedCertificates);
        diagnosticData.getUsedCertificates().addAll(xmlCertificates);
        Collection<XmlRevocation> xmlRevocations = this.buildXmlRevocations(this.usedRevocations);
        diagnosticData.getUsedRevocations().addAll(xmlRevocations);
        this.linkSigningCertificateAndChains(this.usedCertificates);
        this.linkCertificatesAndRevocations(this.usedCertificates);
        if (this.isUseTrustedLists()) {
            Collection<XmlTrustedList> trustedLists = this.buildXmlTrustedLists(this.allCertificateSources);
            diagnosticData.getTrustedLists().addAll(trustedLists);
            this.linkCertificatesAndTrustServices(this.usedCertificates);
        }
        return diagnosticData;
    }

    private boolean isUseTrustedLists() {
        if (!this.allCertificateSources.isEmpty()) {
            for (CertificateSource certificateSource : this.allCertificateSources.getSources()) {
                if (!(certificateSource instanceof TrustPropertiesCertificateSource)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<XmlCertificate> buildXmlCertificates(Set<CertificateToken> certificates) {
        ArrayList<XmlCertificate> builtCertificates = new ArrayList<XmlCertificate>();
        if (Utils.isCollectionNotEmpty(certificates)) {
            ArrayList<CertificateToken> tokens = new ArrayList<CertificateToken>(certificates);
            tokens.sort((Comparator<CertificateToken>)new TokenComparator());
            for (CertificateToken certificateToken : tokens) {
                String id = certificateToken.getDSSIdAsString();
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(id);
                if (xmlCertificate == null) {
                    xmlCertificate = this.buildDetachedXmlCertificate(certificateToken);
                    this.xmlCertsMap.put(id, xmlCertificate);
                }
                this.certificateIdsMap.put(certificateToken.getDSSIdAsString(), certificateToken);
                builtCertificates.add(xmlCertificate);
            }
        }
        return builtCertificates;
    }

    protected void linkSigningCertificateAndChains(Set<CertificateToken> certificates) {
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateToken certificateToken : certificates) {
                XmlCertificate xmlCertificate = this.xmlCertsMap.get((certificateToken = this.getProcessedCertificateToken(certificateToken)).getDSSIdAsString());
                if (xmlCertificate.getSigningCertificate() != null) continue;
                xmlCertificate.setSigningCertificate(this.getXmlSigningCertificate((Token)certificateToken));
                xmlCertificate.setCertificateChain(this.getXmlForCertificateChain((Token)certificateToken));
                xmlCertificate.setBasicSignature(this.getXmlBasicSignature((Token)certificateToken));
                xmlCertificate.setIssuerEntityKey(this.getXmlIssuerEntityKey((Token)certificateToken));
            }
        }
    }

    private void linkCertificatesAndTrustServices(Set<CertificateToken> certificates) {
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateToken certificateToken : certificates) {
                List<XmlTrustServiceProvider> trustServiceProviders = new XmlTrustServiceProviderBuilder(this.xmlCertsMap, this.xmlTrustedListsMap, this.tlInfoMap).build(certificateToken, this.getRelatedTrustServices(certificateToken));
                if (!Utils.isCollectionNotEmpty(trustServiceProviders)) continue;
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(certificateToken.getDSSIdAsString());
                xmlCertificate.setTrustServiceProviders(trustServiceProviders);
            }
        }
    }

    private Map<CertificateToken, List<TrustProperties>> getRelatedTrustServices(CertificateToken certToken) {
        HashMap<CertificateToken, List<TrustProperties>> result = new HashMap<CertificateToken, List<TrustProperties>>();
        block0: for (CertificateSource trustedSource : this.allCertificateSources.getSources()) {
            if (!(trustedSource instanceof TrustPropertiesCertificateSource)) continue;
            TrustPropertiesCertificateSource trustedCertSource = (TrustPropertiesCertificateSource)trustedSource;
            HashSet<CertificateToken> processedTokens = new HashSet<CertificateToken>();
            CertificateToken currentCertificate = certToken;
            while (currentCertificate != null) {
                List trustServices = trustedCertSource.getTrustServices(currentCertificate);
                if (Utils.isCollectionNotEmpty((Collection)trustServices)) {
                    List certTrustServices = result.getOrDefault(currentCertificate, new ArrayList());
                    certTrustServices.addAll(trustServices);
                    result.put(currentCertificate, certTrustServices);
                }
                if (currentCertificate.isSelfSigned() || processedTokens.contains(currentCertificate)) continue block0;
                processedTokens.add(currentCertificate);
                CertificateToken issuerCertificate = this.getIssuerCertificate((Token)currentCertificate);
                if (issuerCertificate != null && currentCertificate.getIssuerEntityKey() != null && currentCertificate.getIssuerEntityKey().equals((Object)issuerCertificate.getEntityKey())) {
                    currentCertificate = issuerCertificate;
                    continue;
                }
                currentCertificate = null;
            }
        }
        return result;
    }

    private Collection<XmlRevocation> buildXmlRevocations(Set<RevocationToken<?>> revocations) {
        ArrayList<XmlRevocation> builtRevocations = new ArrayList<XmlRevocation>();
        if (Utils.isCollectionNotEmpty(revocations)) {
            ArrayList tokens = new ArrayList(revocations);
            tokens.sort((Comparator<RevocationToken<?>>)new TokenComparator());
            ArrayList<String> uniqueIds = new ArrayList<String>();
            for (RevocationToken revocationToken : tokens) {
                String id = revocationToken.getDSSIdAsString();
                if (uniqueIds.contains(id)) continue;
                XmlRevocation xmlRevocation = this.xmlRevocationsMap.get(id);
                if (xmlRevocation == null) {
                    xmlRevocation = this.buildDetachedXmlRevocation(revocationToken);
                    this.xmlRevocationsMap.put(id, xmlRevocation);
                    builtRevocations.add(xmlRevocation);
                }
                uniqueIds.add(id);
            }
        }
        return builtRevocations;
    }

    private void linkCertificatesAndRevocations(Set<CertificateToken> certificates) {
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateToken certificateToken : certificates) {
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(certificateToken.getDSSIdAsString());
                Set<RevocationToken<?>> revocationsForCert = this.getRevocationsForCert(certificateToken);
                for (RevocationToken<?> revocationToken : revocationsForCert) {
                    XmlRevocation xmlRevocation = this.xmlRevocationsMap.get(revocationToken.getDSSIdAsString());
                    XmlCertificateRevocation xmlCertificateRevocation = new XmlCertificateRevocation();
                    xmlCertificateRevocation.setRevocation(xmlRevocation);
                    xmlCertificateRevocation.setStatus(revocationToken.getStatus());
                    xmlCertificateRevocation.setRevocationDate(revocationToken.getRevocationDate());
                    xmlCertificateRevocation.setReason(revocationToken.getReason());
                    xmlCertificate.getRevocations().add(xmlCertificateRevocation);
                }
            }
        }
    }

    protected XmlOrphanTokens buildXmlOrphanTokens() {
        if (Utils.isMapNotEmpty(this.xmlOrphanCertificateTokensMap) || Utils.isMapNotEmpty(this.xmlOrphanRevocationTokensMap)) {
            XmlOrphanTokens xmlOrphanTokens = new XmlOrphanTokens();
            xmlOrphanTokens.getOrphanCertificates().addAll(this.xmlOrphanCertificateTokensMap.values());
            xmlOrphanTokens.getOrphanRevocations().addAll(this.xmlOrphanRevocationTokensMap.values());
            return xmlOrphanTokens;
        }
        return null;
    }

    private Collection<XmlTrustedList> buildXmlTrustedLists(ListCertificateSource trustedCertificateSources) {
        ArrayList<XmlTrustedList> trustedLists = new ArrayList<XmlTrustedList>();
        HashMap<Identifier, XmlTrustedList> mapTrustedLists = new HashMap<Identifier, XmlTrustedList>();
        HashMap<Identifier, XmlTrustedList> mapListOfTrustedLists = new HashMap<Identifier, XmlTrustedList>();
        for (CertificateSource certificateSource : trustedCertificateSources.getSources()) {
            if (!(certificateSource instanceof TrustPropertiesCertificateSource)) continue;
            TrustPropertiesCertificateSource tlCertSource = (TrustPropertiesCertificateSource)certificateSource;
            TLValidationJobSummary summary = tlCertSource.getSummary();
            if (summary != null) {
                mapTrustedLists.putAll(this.getTrustedListsMap(tlCertSource, summary));
                mapListOfTrustedLists.putAll(this.getListOfTrustedListsMap(tlCertSource, summary));
                continue;
            }
            LOG.warn("The TrustedListsCertificateSource does not contain TLValidationJobSummary. TLValidationJob is not performed!");
        }
        trustedLists.addAll(mapTrustedLists.values());
        trustedLists.addAll(mapListOfTrustedLists.values());
        return trustedLists;
    }

    private Map<Identifier, XmlTrustedList> getTrustedListsMap(TrustPropertiesCertificateSource tlCertSource, TLValidationJobSummary summary) {
        HashMap<Identifier, XmlTrustedList> mapTrustedLists = new HashMap<Identifier, XmlTrustedList>();
        Set<Identifier> tlIdentifiers = this.getTLIdentifiers(tlCertSource);
        for (Identifier tlId : tlIdentifiers) {
            TLInfo tlInfoById;
            if (mapTrustedLists.containsKey(tlId) || (tlInfoById = summary.getTLInfoById(tlId)) == null) continue;
            mapTrustedLists.put(tlId, this.getXmlTrustedList(tlInfoById));
        }
        return mapTrustedLists;
    }

    private Map<Identifier, XmlTrustedList> getListOfTrustedListsMap(TrustPropertiesCertificateSource tlCertSource, TLValidationJobSummary summary) {
        HashMap<Identifier, XmlTrustedList> mapListOfTrustedLists = new HashMap<Identifier, XmlTrustedList>();
        Set<Identifier> lotlIdentifiers = this.getLOTLIdentifiers(tlCertSource);
        for (Identifier lotlId : lotlIdentifiers) {
            LOTLInfo lotlInfoById;
            if (mapListOfTrustedLists.containsKey(lotlId) || (lotlInfoById = summary.getLOTLInfoById(lotlId)) == null) continue;
            mapListOfTrustedLists.put(lotlId, this.getXmlTrustedList((TLInfo)lotlInfoById));
        }
        return mapListOfTrustedLists;
    }

    private Set<Identifier> getTLIdentifiers(TrustPropertiesCertificateSource tlCS) {
        HashSet<Identifier> tlIdentifiers = new HashSet<Identifier>();
        for (CertificateToken certificateToken : this.usedCertificates) {
            List trustServices = tlCS.getTrustServices(certificateToken);
            for (TrustProperties trustProperties : trustServices) {
                TLInfo tlInfo = trustProperties.getTLInfo();
                if (tlInfo == null) continue;
                tlIdentifiers.add(tlInfo.getDSSId());
            }
        }
        return tlIdentifiers;
    }

    private Set<Identifier> getLOTLIdentifiers(TrustPropertiesCertificateSource tlCS) {
        HashSet<Identifier> lotlIdentifiers = new HashSet<Identifier>();
        for (CertificateToken certificateToken : this.usedCertificates) {
            List trustServices = tlCS.getTrustServices(certificateToken);
            for (TrustProperties trustProperties : trustServices) {
                LOTLInfo lotlInfo = trustProperties.getLOTLInfo();
                if (lotlInfo == null) continue;
                lotlIdentifiers.add(lotlInfo.getDSSId());
            }
        }
        return lotlIdentifiers;
    }

    private XmlTrustedList getXmlTrustedList(TLInfo tlInfo) {
        String id = tlInfo.getDSSIdAsString();
        XmlTrustedList result = this.xmlTrustedListsMap.get(id);
        if (result == null) {
            ValidationInfoRecord validationCacheInfo;
            DownloadInfoRecord downloadCacheInfo;
            ParsingInfoRecord parsingCacheInfo;
            result = new XmlTrustedList();
            if (tlInfo instanceof LOTLInfo) {
                result.setLOTL(Boolean.valueOf(true));
            }
            result.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)tlInfo));
            result.setUrl(tlInfo.getUrl());
            if (tlInfo.getParent() != null) {
                result.setParent(this.getXmlTrustedList(tlInfo.getParent()));
            }
            if ((parsingCacheInfo = tlInfo.getParsingCacheInfo()) != null) {
                if (parsingCacheInfo.getTSLType() != null) {
                    result.setTSLType(parsingCacheInfo.getTSLType().getUri());
                }
                result.setCountryCode(parsingCacheInfo.getTerritory());
                result.setIssueDate(parsingCacheInfo.getIssueDate());
                result.setNextUpdate(parsingCacheInfo.getNextUpdateDate());
                result.setSequenceNumber(parsingCacheInfo.getSequenceNumber());
                result.setVersion(parsingCacheInfo.getVersion());
                result.setStructuralValidation(this.getXmlStructuralValidation(parsingCacheInfo.getStructureValidationMessages()));
            }
            if ((downloadCacheInfo = tlInfo.getDownloadCacheInfo()) != null) {
                result.setLastLoading(downloadCacheInfo.getLastSuccessSynchronizationTime());
            }
            if ((validationCacheInfo = tlInfo.getValidationCacheInfo()) != null) {
                result.setWellSigned(validationCacheInfo.isValid());
            }
            if (tlInfo.getOtherTSLPointer() != null && tlInfo.getOtherTSLPointer().getMra() != null) {
                result.setMra(Boolean.valueOf(true));
            }
            this.tlInfoMap.put(id, tlInfo);
            this.xmlTrustedListsMap.put(id, result);
        }
        return result;
    }

    protected XmlStructuralValidation getXmlStructuralValidation(List<String> errorMessages) {
        XmlStructuralValidation xmlStructuralValidation = new XmlStructuralValidation();
        xmlStructuralValidation.setValid(Utils.isCollectionEmpty(errorMessages));
        if (Utils.isCollectionNotEmpty(errorMessages)) {
            xmlStructuralValidation.getMessages().addAll(errorMessages);
        }
        return xmlStructuralValidation;
    }

    protected XmlSignerInfo getXmlSignerInfo(SignerIdentifier signerIdentifier) {
        XmlSignerInfo xmlSignerInfo = new XmlSignerInfo();
        if (signerIdentifier.getIssuerName() != null) {
            xmlSignerInfo.setIssuerName(signerIdentifier.getIssuerName().toString());
        }
        xmlSignerInfo.setSerialNumber(signerIdentifier.getSerialNumber());
        xmlSignerInfo.setSki(signerIdentifier.getSki());
        if (signerIdentifier.isCurrent()) {
            xmlSignerInfo.setCurrent(Boolean.valueOf(signerIdentifier.isCurrent()));
        }
        return xmlSignerInfo;
    }

    private XmlSignerInfo getXmlSignerInfo(ResponderId responderId) {
        XmlSignerInfo xmlSignerInfo = new XmlSignerInfo();
        if (responderId.getX500Principal() != null) {
            xmlSignerInfo.setIssuerName(responderId.getX500Principal().toString());
        }
        xmlSignerInfo.setSki(responderId.getSki());
        return xmlSignerInfo;
    }

    protected XmlRevocation buildDetachedXmlRevocation(RevocationToken<?> revocationToken) {
        XmlRevocation xmlRevocation = new XmlRevocation();
        xmlRevocation.setId(this.identifierProvider.getIdAsString(revocationToken));
        if (revocationToken.isInternal()) {
            xmlRevocation.setOrigin(RevocationOrigin.INPUT_DOCUMENT);
        } else {
            xmlRevocation.setOrigin(revocationToken.getExternalOrigin());
        }
        xmlRevocation.setType(revocationToken.getRevocationType());
        xmlRevocation.setProductionDate(revocationToken.getProductionDate());
        xmlRevocation.setThisUpdate(revocationToken.getThisUpdate());
        xmlRevocation.setNextUpdate(revocationToken.getNextUpdate());
        xmlRevocation.setExpiredCertsOnCRL(revocationToken.getExpiredCertsOnCRL());
        xmlRevocation.setArchiveCutOff(revocationToken.getArchiveCutOff());
        String sourceURL = revocationToken.getSourceURL();
        if (Utils.isStringNotEmpty((String)sourceURL)) {
            xmlRevocation.setSourceAddress(sourceURL);
        }
        xmlRevocation.setBasicSignature(this.getXmlBasicSignature((Token)revocationToken));
        xmlRevocation.setSigningCertificate(this.getXmlSigningCertificate((Token)revocationToken, (CertificateSource)revocationToken.getCertificateSource()));
        xmlRevocation.setCertificateChain(this.getXmlForCertificateChain((Token)revocationToken, (CertificateSource)revocationToken.getCertificateSource()));
        xmlRevocation.setCertHashExtensionPresent(Boolean.valueOf(revocationToken.isCertHashPresent()));
        xmlRevocation.setCertHashExtensionMatch(Boolean.valueOf(revocationToken.isCertHashMatch()));
        if (revocationToken.getCertificateSource() != null) {
            xmlRevocation.setFoundCertificates(this.getXmlFoundCertificates((Identifier)revocationToken.getDSSId(), (TokenCertificateSource)revocationToken.getCertificateSource()));
        }
        if (this.tokenExtractionStrategy.isRevocationData()) {
            xmlRevocation.setBase64Encoded(revocationToken.getEncoded());
        } else {
            byte[] revocationDigest = revocationToken.getDigest(this.defaultDigestAlgorithm);
            xmlRevocation.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, revocationDigest));
        }
        return xmlRevocation;
    }

    protected <R extends Revocation> List<XmlRevocationRef> getXmlRevocationRefs(String tokenId, Map<RevocationRef<R>, Set<RevocationRefOrigin>> refsAndOrigins) {
        ArrayList<XmlRevocationRef> xmlRevocationRefs = new ArrayList<XmlRevocationRef>();
        for (Map.Entry<RevocationRef<R>, Set<RevocationRefOrigin>> entry : refsAndOrigins.entrySet()) {
            RevocationRef<R> ref = entry.getKey();
            Set<RevocationRefOrigin> origins = entry.getValue();
            XmlRevocationRef xmlRef = ref instanceof CRLRef ? this.getXmlCRLRevocationRef((CRLRef)ref, origins) : this.getXmlOCSPRevocationRef((OCSPRef)ref, origins);
            this.referenceMap.put(ref.getDSSIdAsString(), tokenId);
            xmlRevocationRefs.add(xmlRef);
        }
        return xmlRevocationRefs;
    }

    protected XmlRevocationRef getXmlCRLRevocationRef(CRLRef crlRef, Set<RevocationRefOrigin> origins) {
        XmlRevocationRef xmlRevocationRef = new XmlRevocationRef();
        xmlRevocationRef.getOrigins().addAll(origins);
        if (crlRef.getDigest() != null) {
            xmlRevocationRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(crlRef.getDigest()));
        }
        return xmlRevocationRef;
    }

    protected XmlRevocationRef getXmlOCSPRevocationRef(OCSPRef ocspRef, Set<RevocationRefOrigin> origins) {
        XmlRevocationRef xmlRevocationRef = new XmlRevocationRef();
        xmlRevocationRef.getOrigins().addAll(origins);
        if (ocspRef.getDigest() != null) {
            xmlRevocationRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(ocspRef.getDigest()));
        }
        xmlRevocationRef.setProducedAt(ocspRef.getProducedAt());
        ResponderId responderId = ocspRef.getResponderId();
        if (responderId != null) {
            xmlRevocationRef.setResponderId(this.getXmlSignerInfo(responderId));
        }
        return xmlRevocationRef;
    }

    protected List<XmlChainItem> getXmlForCertificateChain(Token token) {
        return this.getXmlForCertificateChain(token, null);
    }

    protected List<XmlChainItem> getXmlForCertificateChain(Token token, CertificateSource certificateSource) {
        if (token != null) {
            XmlChainItem xmlChainItem;
            ArrayList<XmlChainItem> certChainTokens = new ArrayList<XmlChainItem>();
            ArrayList<Token> processedTokens = new ArrayList<Token>();
            processedTokens.add(token);
            CertificateToken issuerToken = this.getIssuerCertificate(token, certificateSource);
            while (issuerToken != null && (xmlChainItem = this.getXmlChainItem(issuerToken)) != null) {
                certChainTokens.add(xmlChainItem);
                if (issuerToken.isSelfSigned() || processedTokens.contains(issuerToken)) {
                    processedTokens.add((Token)issuerToken);
                    break;
                }
                processedTokens.add((Token)issuerToken);
                issuerToken = this.getIssuerCertificate((Token)issuerToken, certificateSource);
            }
            this.ensureCertificateChain(token, certChainTokens, processedTokens);
            return certChainTokens;
        }
        return null;
    }

    private void ensureCertificateChain(Token token, List<XmlChainItem> certChain, List<Token> processedTokens) {
        if (Utils.isCollectionNotEmpty(certChain)) {
            XmlCertificate certificate = this.xmlCertsMap.get(token.getDSSIdAsString());
            if (certificate != null) {
                certificate.setSigningCertificate(this.getXmlSigningCertificateFromXmlCertificate(certChain.get(0).getCertificate()));
                certificate.setCertificateChain(this.getCertChainSinceIndex(certChain, 0));
                certificate.setBasicSignature(this.getXmlBasicSignature(token));
                certificate.setIssuerEntityKey(this.getXmlIssuerEntityKey(token));
            }
            for (int i = 0; i < certChain.size(); ++i) {
                XmlChainItem chainItem = certChain.get(i);
                XmlCertificate chainCertificate = chainItem.getCertificate();
                if (chainCertificate == null || chainCertificate.getSigningCertificate() != null || i + 1 >= certChain.size()) continue;
                chainCertificate.setSigningCertificate(this.getXmlSigningCertificateFromXmlCertificate(certChain.get(i + 1).getCertificate()));
                chainCertificate.setCertificateChain(this.getCertChainSinceIndex(certChain, i + 1));
                chainCertificate.setBasicSignature(this.getXmlBasicSignature(processedTokens.get(i + 1)));
                chainCertificate.setIssuerEntityKey(this.getXmlIssuerEntityKey(processedTokens.get(i + 1)));
            }
        }
    }

    private XmlSigningCertificate getXmlSigningCertificateFromXmlCertificate(XmlCertificate xmlCertificate) {
        XmlSigningCertificate xmlSigningCertificate = new XmlSigningCertificate();
        xmlSigningCertificate.setCertificate(xmlCertificate);
        return xmlSigningCertificate;
    }

    private List<XmlChainItem> getCertChainSinceIndex(List<XmlChainItem> certChain, int index) {
        ArrayList<XmlChainItem> result = new ArrayList<XmlChainItem>();
        for (int i = index; i < certChain.size(); ++i) {
            result.add(certChain.get(i));
        }
        return result;
    }

    protected List<XmlChainItem> getXmlForCertificateChain(CertificateValidity certificateValidity, CertificateSource certificateSource) {
        XmlChainItem signCertChainItem;
        CertificateToken signingCertificate;
        if (certificateValidity != null && (signingCertificate = this.getSigningCertificate(certificateValidity)) != null && (signCertChainItem = this.getXmlChainItem(signingCertificate)) != null) {
            ArrayList<XmlChainItem> certChainTokens = new ArrayList<XmlChainItem>();
            certChainTokens.add(signCertChainItem);
            List<XmlChainItem> certChain = this.getXmlForCertificateChain((Token)signingCertificate, certificateSource);
            if (Utils.isCollectionNotEmpty(certChain)) {
                for (XmlChainItem chainItem : certChain) {
                    if (chainItem.getCertificate() != null && signingCertificate.getDSSIdAsString().equals(chainItem.getCertificate().getId())) break;
                    certChainTokens.add(chainItem);
                }
            }
            return certChainTokens;
        }
        return null;
    }

    private XmlChainItem getXmlChainItem(CertificateToken token) {
        XmlCertificate xmlCertificate = this.xmlCertsMap.get(token.getDSSIdAsString());
        if (xmlCertificate != null) {
            XmlChainItem chainItem = new XmlChainItem();
            chainItem.setCertificate(xmlCertificate);
            return chainItem;
        }
        return null;
    }

    private XmlSigningCertificate getXmlSigningCertificate(Token token) {
        return this.getXmlSigningCertificate(token, null);
    }

    private XmlSigningCertificate getXmlSigningCertificate(Token token, CertificateSource certificateSource) {
        XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
        CertificateToken certificateByPubKey = this.getIssuerCertificate(token, certificateSource);
        if (certificateByPubKey != null) {
            xmlSignCertType.setCertificate(this.xmlCertsMap.get(certificateByPubKey.getDSSIdAsString()));
            this.signingCertificateMap.put(token.getDSSIdAsString(), certificateByPubKey);
        } else if (token.getPublicKeyOfTheSigner() != null) {
            xmlSignCertType.setPublicKey(token.getPublicKeyOfTheSigner().getEncoded());
        } else {
            return null;
        }
        return xmlSignCertType;
    }

    private CertificateToken getIssuerCertificate(Token token) {
        return this.getIssuerCertificate(token, null);
    }

    private CertificateToken getIssuerCertificate(Token token, CertificateSource certificateSource) {
        if (token != null && token.getPublicKeyOfTheSigner() != null) {
            CertificateToken issuer = null;
            if (certificateSource != null) {
                issuer = this.getBestCertificateFromCandidates(token, certificateSource.getCertificates());
            }
            if (issuer == null && this.signingCertificateMap.containsKey(token.getDSSIdAsString())) {
                issuer = this.signingCertificateMap.get(token.getDSSIdAsString());
            }
            if (issuer == null) {
                issuer = this.getBestCertificateFromCandidates(token, this.usedCertificates);
            }
            if (issuer != null) {
                issuer = this.getProcessedCertificateToken(issuer);
                if (!this.signingCertificateMap.containsKey(token.getDSSIdAsString())) {
                    this.signingCertificateMap.put(token.getDSSIdAsString(), issuer);
                }
            }
            return issuer;
        }
        return null;
    }

    private CertificateToken getBestCertificateFromCandidates(Token token, Collection<CertificateToken> candidates) {
        return new TokenIssuerSelector(token, candidates).getIssuer();
    }

    private List<CertificateToken> getCertsWithPublicKey(PublicKey publicKey, Collection<CertificateToken> candidates) {
        ArrayList<CertificateToken> founds = new ArrayList<CertificateToken>();
        if (publicKey != null) {
            for (CertificateToken cert : candidates) {
                if (!publicKey.equals((cert = this.getProcessedCertificateToken(cert)).getPublicKey())) continue;
                founds.add(cert);
                if (!this.allCertificateSources.isTrusted(cert)) continue;
                return Collections.singletonList(cert);
            }
        }
        return founds;
    }

    private CertificateToken getProcessedCertificateToken(CertificateToken certificateToken) {
        CertificateToken processedCertificateToken = this.certificateIdsMap.get(certificateToken.getDSSIdAsString());
        if (processedCertificateToken == null) {
            processedCertificateToken = certificateToken;
            this.certificateIdsMap.put(certificateToken.getDSSIdAsString(), certificateToken);
        }
        return processedCertificateToken;
    }

    protected XmlSigningCertificate getXmlSigningCertificate(Identifier tokenIdentifier, CertificateValidity certificateValidity) {
        XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
        CertificateToken signingCertificate = this.getSigningCertificate(certificateValidity);
        if (signingCertificate != null) {
            xmlSignCertType.setCertificate(this.xmlCertsMap.get(signingCertificate.getDSSIdAsString()));
            this.signingCertificateMap.put(tokenIdentifier.asXmlId(), signingCertificate);
        } else if (certificateValidity.getPublicKey() != null) {
            xmlSignCertType.setPublicKey(certificateValidity.getPublicKey().getEncoded());
        } else if (certificateValidity.getSignerInfo() != null) {
            // empty if block
        }
        return xmlSignCertType;
    }

    private CertificateToken getSigningCertificate(CertificateValidity certificateValidity) {
        CertificateToken signingCertificateToken = certificateValidity.getCertificateToken();
        if (signingCertificateToken == null && certificateValidity.getPublicKey() != null) {
            signingCertificateToken = this.getCertificateByPubKey(certificateValidity.getPublicKey());
        }
        if (signingCertificateToken == null && certificateValidity.getSignerInfo() != null) {
            signingCertificateToken = this.getCertificateByCertificateIdentifier(certificateValidity.getSignerInfo());
        }
        if (signingCertificateToken != null) {
            signingCertificateToken = this.getProcessedCertificateToken(signingCertificateToken);
        }
        return signingCertificateToken;
    }

    private CertificateToken getCertificateByPubKey(PublicKey publicKey) {
        List<CertificateToken> candidates;
        if (publicKey != null && Utils.isCollectionNotEmpty(candidates = this.getCertsWithPublicKey(publicKey, this.usedCertificates))) {
            return candidates.iterator().next();
        }
        return null;
    }

    private CertificateToken getCertificateByCertificateIdentifier(SignerIdentifier signerIdentifier) {
        if (signerIdentifier == null) {
            return null;
        }
        ArrayList<CertificateToken> founds = new ArrayList<CertificateToken>();
        for (CertificateToken cert : this.usedCertificates) {
            if (!signerIdentifier.isRelatedToCertificate(cert)) continue;
            founds.add(cert);
            if (!this.allCertificateSources.isTrusted(cert)) continue;
            return cert;
        }
        if (Utils.isCollectionNotEmpty(founds)) {
            return (CertificateToken)founds.iterator().next();
        }
        return null;
    }

    private XmlDistinguishedName getXmlDistinguishedName(String x500PrincipalFormat, String value) {
        XmlDistinguishedName xmlDistinguishedName = new XmlDistinguishedName();
        xmlDistinguishedName.setFormat(x500PrincipalFormat);
        xmlDistinguishedName.setValue(value);
        return xmlDistinguishedName;
    }

    private List<String> getCleanedUrls(List<String> urls) {
        ArrayList<String> cleanedUrls = new ArrayList<String>();
        for (String url : urls) {
            cleanedUrls.add(this.getCleanedUrl(url));
        }
        return cleanedUrls;
    }

    private String getCleanedUrl(String url) {
        return DSSUtils.removeControlCharacters((String)url);
    }

    protected XmlFoundCertificates getXmlFoundCertificates(TokenCertificateSource certificateSource) {
        return this.getXmlFoundCertificates(null, certificateSource);
    }

    protected XmlFoundCertificates getXmlFoundCertificates(Identifier tokenIdentifier, TokenCertificateSource certificateSource) {
        XmlFoundCertificates xmlFoundCertificates = new XmlFoundCertificates();
        xmlFoundCertificates.getRelatedCertificates().addAll(this.getXmlRelatedCertificates(certificateSource));
        List<XmlRelatedCertificate> xmlRelatedCertificatesForOrphanReferences = this.getXmlRelatedCertificateForOrphanReferences(certificateSource);
        for (XmlRelatedCertificate xmlRelatedCertificate : xmlRelatedCertificatesForOrphanReferences) {
            if (this.containsCertificate(xmlFoundCertificates.getRelatedCertificates(), xmlRelatedCertificate)) continue;
            xmlFoundCertificates.getRelatedCertificates().add(xmlRelatedCertificate);
        }
        if (tokenIdentifier != null) {
            CertificateToken signingCertificate = this.signingCertificateMap.get(tokenIdentifier.asXmlId());
            xmlFoundCertificates.getOrphanCertificates().addAll(this.getOrphanCertificates(certificateSource, signingCertificate));
            xmlFoundCertificates.getOrphanCertificates().addAll(this.getOrphanCertificateRefs(certificateSource, signingCertificate));
        }
        return xmlFoundCertificates;
    }

    private boolean containsCertificate(Collection<XmlRelatedCertificate> certificates, XmlRelatedCertificate xmlRelatedCertificate) {
        return certificates.stream().anyMatch(c -> xmlRelatedCertificate.getCertificate().getId().equals(c.getCertificate().getId()));
    }

    private List<XmlRelatedCertificate> getXmlRelatedCertificates(TokenCertificateSource certificateSource) {
        HashMap<String, XmlRelatedCertificate> relatedCertificatesMap = new HashMap<String, XmlRelatedCertificate>();
        if (CertificateSourceType.OCSP_RESPONSE.equals((Object)certificateSource.getCertificateSourceType())) {
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.BASIC_OCSP_RESP, certificateSource.getCertificates(), certificateSource);
        } else if (CertificateSourceType.EVIDENCE_RECORD.equals((Object)certificateSource.getCertificateSourceType())) {
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.EVIDENCE_RECORD, certificateSource.getCertificates(), certificateSource);
        } else {
            SignatureCertificateSource signatureCertificateSource = (SignatureCertificateSource)certificateSource;
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.KEY_INFO, signatureCertificateSource.getKeyInfoCertificates(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.SIGNED_DATA, signatureCertificateSource.getSignedDataCertificates(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.CERTIFICATE_VALUES, signatureCertificateSource.getCertificateValues(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.ATTR_AUTHORITIES_CERT_VALUES, signatureCertificateSource.getAttrAuthoritiesCertValues(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.TIMESTAMP_VALIDATION_DATA, signatureCertificateSource.getTimeStampValidationDataCertValues(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.ANY_VALIDATION_DATA, signatureCertificateSource.getAnyValidationDataCertValues(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.DSS_DICTIONARY, signatureCertificateSource.getDSSDictionaryCertValues(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.VRI_DICTIONARY, signatureCertificateSource.getVRIDictionaryCertValues(), certificateSource);
        }
        return new ArrayList<XmlRelatedCertificate>(relatedCertificatesMap.values());
    }

    protected void populateCertificateOriginMap(Map<String, XmlRelatedCertificate> relatedCertificatesMap, CertificateOrigin origin, List<CertificateToken> certificateTokens, TokenCertificateSource certificateSource) {
        for (CertificateToken certificateToken : certificateTokens) {
            if (!relatedCertificatesMap.containsKey(certificateToken.getDSSIdAsString())) {
                if (!this.xmlCertsMap.containsKey(certificateToken.getDSSIdAsString())) continue;
                XmlRelatedCertificate xmlFoundCertificate = this.populateXmlRelatedCertificatesList(origin, certificateToken, certificateSource);
                relatedCertificatesMap.put(certificateToken.getDSSIdAsString(), xmlFoundCertificate);
                continue;
            }
            XmlRelatedCertificate storedFoundCertificate = relatedCertificatesMap.get(certificateToken.getDSSIdAsString());
            if (storedFoundCertificate.getOrigins().contains(origin)) continue;
            storedFoundCertificate.getOrigins().add(origin);
        }
    }

    protected XmlRelatedCertificate populateXmlRelatedCertificatesList(CertificateOrigin origin, CertificateToken cert, TokenCertificateSource certificateSource) {
        XmlRelatedCertificate xrc = new XmlRelatedCertificate();
        xrc.getOrigins().add(origin);
        xrc.setCertificate(this.xmlCertsMap.get(cert.getDSSIdAsString()));
        List referencesForCertificateToken = certificateSource.getReferencesForCertificateToken(cert);
        for (CertificateRef certificateRef : referencesForCertificateToken) {
            for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(certificateRef)) {
                XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(certificateRef, refOrigin);
                this.verifyAgainstCertificateToken(xmlCertificateRef, certificateRef, cert);
                xrc.getCertificateRefs().add(xmlCertificateRef);
            }
            this.referenceMap.put(certificateRef.getDSSIdAsString(), cert.getDSSIdAsString());
        }
        return xrc;
    }

    protected void populateXmlRelatedCertificatesList(List<XmlRelatedCertificate> relatedCertificates, TokenCertificateSource certificateSource, CertificateToken cert, CertificateRef certificateRef) {
        XmlRelatedCertificate xrc = this.getXmlRelatedCertificateWithId(relatedCertificates, this.identifierProvider.getIdAsString((IdentifierBasedObject)cert));
        if (xrc == null) {
            xrc = new XmlRelatedCertificate();
            xrc.setCertificate(this.xmlCertsMap.get(cert.getDSSIdAsString()));
            relatedCertificates.add(xrc);
        }
        for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(certificateRef)) {
            XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(certificateRef, refOrigin);
            this.verifyAgainstCertificateToken(xmlCertificateRef, certificateRef, cert);
            xrc.getCertificateRefs().add(xmlCertificateRef);
        }
        this.referenceMap.put(certificateRef.getDSSIdAsString(), cert.getDSSIdAsString());
    }

    private XmlRelatedCertificate getXmlRelatedCertificateWithId(List<XmlRelatedCertificate> relatedCertificates, String certId) {
        for (XmlRelatedCertificate relatedCertificate : relatedCertificates) {
            if (!certId.equals(relatedCertificate.getCertificate().getId())) continue;
            return relatedCertificate;
        }
        return null;
    }

    protected XmlCertificateRef getXmlCertificateRef(CertificateRef ref, CertificateRefOrigin origin) {
        XmlCertificateRef certificateRef = new XmlCertificateRef();
        SignerIdentifier signerIdentifier = ref.getCertificateIdentifier();
        if (signerIdentifier != null) {
            certificateRef.setIssuerSerial(this.getXmlIssuerSerial(signerIdentifier));
        }
        Digest refDigest = ref.getCertDigest();
        ResponderId responderId = ref.getResponderId();
        if (refDigest != null) {
            certificateRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(refDigest.getAlgorithm(), refDigest.getValue()));
        } else if (signerIdentifier != null) {
            certificateRef.setSerialInfo(this.getXmlSignerInfo(signerIdentifier));
        } else if (responderId != null) {
            certificateRef.setSerialInfo(this.getXmlSignerInfo(responderId));
        }
        String x509Url = ref.getX509Url();
        if (x509Url != null) {
            certificateRef.setX509Url(x509Url);
        }
        certificateRef.setOrigin(origin);
        return certificateRef;
    }

    private List<XmlOrphanCertificate> getOrphanCertificates(TokenCertificateSource certificateSource, CertificateToken signingCertificate) {
        HashMap<String, XmlOrphanCertificate> orphanCertificatesMap = new HashMap<String, XmlOrphanCertificate>();
        if (CertificateSourceType.OCSP_RESPONSE.equals((Object)certificateSource.getCertificateSourceType())) {
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.BASIC_OCSP_RESP, certificateSource.getCertificates(), certificateSource, signingCertificate);
        } else {
            SignatureCertificateSource signatureCertificateSource = (SignatureCertificateSource)certificateSource;
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.KEY_INFO, signatureCertificateSource.getKeyInfoCertificates(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.SIGNED_DATA, signatureCertificateSource.getSignedDataCertificates(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.CERTIFICATE_VALUES, signatureCertificateSource.getCertificateValues(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.ATTR_AUTHORITIES_CERT_VALUES, signatureCertificateSource.getAttrAuthoritiesCertValues(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.TIMESTAMP_VALIDATION_DATA, signatureCertificateSource.getTimeStampValidationDataCertValues(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.ANY_VALIDATION_DATA, signatureCertificateSource.getAnyValidationDataCertValues(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.DSS_DICTIONARY, signatureCertificateSource.getDSSDictionaryCertValues(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.VRI_DICTIONARY, signatureCertificateSource.getVRIDictionaryCertValues(), certificateSource, signingCertificate);
        }
        return new ArrayList<XmlOrphanCertificate>(orphanCertificatesMap.values());
    }

    protected void populateOrphanCertificateOriginMap(Map<String, XmlOrphanCertificate> orphanCertificatesMap, CertificateOrigin origin, List<CertificateToken> certificateTokens, TokenCertificateSource certificateSource, CertificateToken signingCertificate) {
        for (CertificateToken certificateToken : certificateTokens) {
            if (this.xmlCertsMap.containsKey(certificateToken.getDSSIdAsString())) continue;
            if (!orphanCertificatesMap.containsKey(certificateToken.getDSSIdAsString())) {
                XmlOrphanCertificate xmlOrphanCertificate = this.getXmlOrphanCertificate(origin, certificateToken, certificateSource, signingCertificate);
                orphanCertificatesMap.put(certificateToken.getDSSIdAsString(), xmlOrphanCertificate);
                continue;
            }
            XmlOrphanCertificate storedFoundCertificate = orphanCertificatesMap.get(certificateToken.getDSSIdAsString());
            if (storedFoundCertificate.getOrigins().contains(origin)) continue;
            storedFoundCertificate.getOrigins().add(origin);
        }
    }

    protected XmlOrphanCertificate getXmlOrphanCertificate(CertificateOrigin origin, CertificateToken certificateToken, TokenCertificateSource certificateSource, CertificateToken signingCertificate) {
        XmlOrphanCertificate xoc = new XmlOrphanCertificate();
        xoc.getOrigins().add(origin);
        xoc.setToken(this.buildXmlOrphanCertificateToken(certificateToken));
        List referencesForCertificateToken = certificateSource.getReferencesForCertificateToken(certificateToken);
        for (CertificateRef certificateRef : referencesForCertificateToken) {
            for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(certificateRef)) {
                XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(certificateRef, refOrigin);
                this.verifyAgainstCertificateToken(xmlCertificateRef, certificateRef, signingCertificate);
                xoc.getCertificateRefs().add(xmlCertificateRef);
            }
            this.referenceMap.put(certificateRef.getDSSIdAsString(), certificateToken.getDSSIdAsString());
        }
        return xoc;
    }

    protected XmlOrphanCertificateToken buildXmlOrphanCertificateToken(CertificateToken certificateToken) {
        XmlOrphanCertificateToken orphanToken = this.xmlOrphanCertificateTokensMap.get(certificateToken.getDSSIdAsString());
        if (orphanToken == null) {
            orphanToken = new XmlOrphanCertificateToken();
            orphanToken.setEncapsulationType(XmlEncapsulationType.BINARIES);
            orphanToken.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)certificateToken));
            X500PrincipalHelper subject = certificateToken.getSubject();
            orphanToken.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", subject.getCanonical()));
            orphanToken.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", subject.getRFC2253()));
            X500PrincipalHelper issuer = certificateToken.getIssuer();
            orphanToken.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", issuer.getCanonical()));
            orphanToken.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", issuer.getRFC2253()));
            orphanToken.setSerialNumber(certificateToken.getSerialNumber());
            orphanToken.setNotAfter(certificateToken.getNotAfter());
            orphanToken.setNotBefore(certificateToken.getNotBefore());
            orphanToken.setEntityKey(certificateToken.getEntityKey().asXmlId());
            orphanToken.setSelfSigned(Boolean.valueOf(certificateToken.isSelfSigned()));
            orphanToken.setTrusted(Boolean.valueOf(this.allCertificateSources.isTrusted(certificateToken)));
            if (this.tokenExtractionStrategy.isCertificate()) {
                orphanToken.setBase64Encoded(certificateToken.getEncoded());
            } else {
                byte[] certDigest = certificateToken.getDigest(this.defaultDigestAlgorithm);
                orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, certDigest));
            }
            this.xmlOrphanCertificateTokensMap.put(certificateToken.getDSSIdAsString(), orphanToken);
        }
        return orphanToken;
    }

    private List<XmlOrphanCertificate> getOrphanCertificateRefs(TokenCertificateSource certificateSource, CertificateToken signingCertificate) {
        ArrayList<XmlOrphanCertificate> orphanCertificates = new ArrayList<XmlOrphanCertificate>();
        List orphanCertificateRefs = certificateSource.getOrphanCertificateRefs();
        for (CertificateRef orphanCertificateRef : orphanCertificateRefs) {
            if (!Utils.isCollectionEmpty(this.getUsedCertificatesByCertificateRef(orphanCertificateRef))) continue;
            orphanCertificates.add(this.createXmlOrphanCertificateFromRef(certificateSource, orphanCertificateRef, signingCertificate));
        }
        return orphanCertificates;
    }

    private XmlOrphanCertificate createXmlOrphanCertificateFromRef(TokenCertificateSource certificateSource, CertificateRef orphanCertificateRef, CertificateToken signingCertificate) {
        XmlOrphanCertificate orphanCertificate = new XmlOrphanCertificate();
        orphanCertificate.setToken(this.getXmlOrphanCertificateTokenFromRef(orphanCertificateRef));
        for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(orphanCertificateRef)) {
            XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(orphanCertificateRef, refOrigin);
            this.verifyAgainstCertificateToken(xmlCertificateRef, orphanCertificateRef, signingCertificate);
            orphanCertificate.getCertificateRefs().add(xmlCertificateRef);
        }
        return orphanCertificate;
    }

    private XmlOrphanCertificateToken getXmlOrphanCertificateTokenFromRef(CertificateRef orphanCertificateRef) {
        XmlOrphanCertificateToken orphanToken = this.xmlOrphanCertificateTokensMap.get(orphanCertificateRef.getDSSIdAsString());
        if (orphanToken == null) {
            orphanToken = new XmlOrphanCertificateToken();
            orphanToken.setEncapsulationType(XmlEncapsulationType.REFERENCE);
            orphanToken.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)orphanCertificateRef));
            if (orphanCertificateRef.getCertDigest() != null) {
                orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(orphanCertificateRef.getCertDigest()));
            }
            this.xmlOrphanCertificateTokensMap.put(orphanCertificateRef.getDSSIdAsString(), orphanToken);
        }
        return orphanToken;
    }

    protected List<XmlRelatedCertificate> getXmlRelatedCertificateForOrphanReferences(TokenCertificateSource certificateSource) {
        ArrayList<XmlRelatedCertificate> relatedCertificates = new ArrayList<XmlRelatedCertificate>();
        for (CertificateRef certificateRef : certificateSource.getOrphanCertificateRefs()) {
            Collection<CertificateToken> certificateTokens = this.getUsedCertificatesByCertificateRef(certificateRef);
            if (!Utils.isCollectionNotEmpty(certificateTokens)) continue;
            for (CertificateToken certificateToken : certificateTokens) {
                this.populateXmlRelatedCertificatesList(relatedCertificates, certificateSource, certificateToken, certificateRef);
            }
        }
        return relatedCertificates;
    }

    protected Collection<CertificateToken> getUsedCertificatesByCertificateRef(CertificateRef certificateRef) {
        CertificateTokenRefMatcher matcher = new CertificateTokenRefMatcher();
        Set tokensFromRefs = this.allCertificateSources.findTokensFromCertRef(certificateRef);
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        for (CertificateToken certificateToken : this.usedCertificates) {
            if (!tokensFromRefs.contains(certificateToken) && !matcher.match(certificateToken, certificateRef)) continue;
            certificates.add(certificateToken);
        }
        return certificates;
    }

    protected void verifyAgainstCertificateToken(XmlCertificateRef xmlCertificateRef, CertificateRef ref, CertificateToken signingCertificate) {
        XmlIssuerSerial issuerSerial;
        CertificateTokenRefMatcher tokenRefMatcher = new CertificateTokenRefMatcher();
        XmlDigestAlgoAndValue digestAlgoAndValue = xmlCertificateRef.getDigestAlgoAndValue();
        if (digestAlgoAndValue != null) {
            digestAlgoAndValue.setMatch(Boolean.valueOf(signingCertificate != null && tokenRefMatcher.matchByDigest(signingCertificate, ref)));
        }
        if ((issuerSerial = xmlCertificateRef.getIssuerSerial()) != null) {
            issuerSerial.setMatch(Boolean.valueOf(signingCertificate != null && tokenRefMatcher.matchByIssuerName(signingCertificate, ref) && tokenRefMatcher.matchBySerialNumber(signingCertificate, ref)));
        }
    }

    private XmlIssuerSerial getXmlIssuerSerial(SignerIdentifier signerIdentifier) {
        XmlIssuerSerial xmlIssuerSerial = new XmlIssuerSerial();
        xmlIssuerSerial.setValue(signerIdentifier.getIssuerSerialEncoded());
        return xmlIssuerSerial;
    }

    private XmlIssuerEntityKey getXmlIssuerEntityKey(Token token) {
        CertificateToken issuerCertificate;
        CertificateToken certificateToken = issuerCertificate = token.isSelfSigned() ? (CertificateToken)token : this.getIssuerCertificate(token);
        if (issuerCertificate != null) {
            XmlIssuerEntityKey xmlIssuerEntityKey = new XmlIssuerEntityKey();
            xmlIssuerEntityKey.setValue(token.getIssuerEntityKey().asXmlId());
            PublicKey publicKeyOfSigner = token.isSelfSigned() ? issuerCertificate.getPublicKey() : token.getPublicKeyOfTheSigner();
            xmlIssuerEntityKey.setKey(issuerCertificate.getPublicKey() != null && publicKeyOfSigner != null && Arrays.equals(publicKeyOfSigner.getEncoded(), issuerCertificate.getPublicKey().getEncoded()));
            xmlIssuerEntityKey.setSubjectName(new X500PrincipalHelper(token.getIssuerX500Principal()).equals((Object)issuerCertificate.getSubject()));
            return xmlIssuerEntityKey;
        }
        return null;
    }

    protected XmlBasicSignature getXmlBasicSignature(Token token) {
        XmlBasicSignature xmlBasicSignatureType = new XmlBasicSignature();
        SignatureAlgorithm signatureAlgorithm = token.getSignatureAlgorithm();
        if (signatureAlgorithm != null) {
            xmlBasicSignatureType.setEncryptionAlgoUsedToSignThisToken(signatureAlgorithm.getEncryptionAlgorithm());
            xmlBasicSignatureType.setDigestAlgoUsedToSignThisToken(signatureAlgorithm.getDigestAlgorithm());
        }
        xmlBasicSignatureType.setKeyLengthUsedToSignThisToken(DSSPKUtils.getStringPublicKeySize((Token)token));
        SignatureValidity signatureValidity = token.getSignatureValidity();
        if (SignatureValidity.NOT_EVALUATED != signatureValidity) {
            xmlBasicSignatureType.setSignatureIntact(Boolean.valueOf(token.isSignatureIntact()));
            xmlBasicSignatureType.setSignatureValid(Boolean.valueOf(token.isValid()));
        }
        return xmlBasicSignatureType;
    }

    protected XmlCertificate buildDetachedXmlCertificate(CertificateToken certToken) {
        XmlCertificate xmlCert = new XmlCertificate();
        xmlCert.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)certToken));
        X500PrincipalHelper subject = certToken.getSubject();
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", subject.getCanonical()));
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", subject.getRFC2253()));
        X500PrincipalHelper issuer = certToken.getIssuer();
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", issuer.getCanonical()));
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", issuer.getRFC2253()));
        xmlCert.setSerialNumber(certToken.getSerialNumber());
        xmlCert.setSubjectSerialNumber(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.SERIALNUMBER, (X500PrincipalHelper)subject));
        xmlCert.setTitle(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.T, (X500PrincipalHelper)subject));
        xmlCert.setCommonName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.CN, (X500PrincipalHelper)subject));
        xmlCert.setLocality(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.L, (X500PrincipalHelper)subject));
        xmlCert.setState(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.ST, (X500PrincipalHelper)subject));
        xmlCert.setCountryName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.C, (X500PrincipalHelper)subject));
        xmlCert.setOrganizationIdentifier(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.ORGANIZATION_IDENTIFIER, (X500PrincipalHelper)subject));
        xmlCert.setOrganizationName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.O, (X500PrincipalHelper)subject));
        xmlCert.setOrganizationalUnit(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.OU, (X500PrincipalHelper)subject));
        xmlCert.setGivenName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.GIVENNAME, (X500PrincipalHelper)subject));
        xmlCert.setSurname(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.SURNAME, (X500PrincipalHelper)subject));
        xmlCert.setPseudonym(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.PSEUDONYM, (X500PrincipalHelper)subject));
        xmlCert.setEmail(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.E, (X500PrincipalHelper)subject));
        xmlCert.setSources(this.getXmlCertificateSources(certToken));
        xmlCert.setNotAfter(certToken.getNotAfter());
        xmlCert.setNotBefore(certToken.getNotBefore());
        PublicKey publicKey = certToken.getPublicKey();
        xmlCert.setPublicKeySize(DSSPKUtils.getPublicKeySize((PublicKey)publicKey));
        xmlCert.setPublicKeyEncryptionAlgo(EncryptionAlgorithm.forKey((Key)publicKey));
        xmlCert.setEntityKey(certToken.getEntityKey().asXmlId());
        xmlCert.setCertificateExtensions(this.getXmlCertificateExtensions(certToken));
        xmlCert.setSelfSigned(certToken.isSelfSigned());
        xmlCert.setTrusted(this.getXmlTrusted(certToken));
        if (this.tokenExtractionStrategy.isCertificate()) {
            xmlCert.setBase64Encoded(certToken.getEncoded());
        } else {
            byte[] certDigest = certToken.getDigest(this.defaultDigestAlgorithm);
            xmlCert.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, certDigest));
        }
        return xmlCert;
    }

    private List<XmlCertificateExtension> getXmlCertificateExtensions(CertificateToken token) {
        CertificateExtensions certificateExtensions = CertificateExtensionsUtils.getCertificateExtensions((CertificateToken)token);
        ArrayList<XmlCertificateExtension> xmlCertificateExtensions = new ArrayList<XmlCertificateExtension>();
        if (certificateExtensions.getAuthorityKeyIdentifier() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlAuthorityKeyIdentifier(certificateExtensions.getAuthorityKeyIdentifier()));
        }
        if (certificateExtensions.getSubjectKeyIdentifier() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlSubjectKeyIdentifier(certificateExtensions.getSubjectKeyIdentifier()));
        }
        if (certificateExtensions.getBasicConstraints() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlBasicConstraints(certificateExtensions.getBasicConstraints()));
        }
        if (certificateExtensions.getKeyUsage() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlKeyUsages(certificateExtensions.getKeyUsage()));
        }
        if (certificateExtensions.getCertificatePolicies() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlCertificatePolicies(certificateExtensions.getCertificatePolicies()));
        }
        if (certificateExtensions.getSubjectAlternativeNames() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlSubjectAlternativeNames(certificateExtensions.getSubjectAlternativeNames()));
        }
        if (certificateExtensions.getPolicyConstraints() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlPolicyConstraints(certificateExtensions.getPolicyConstraints()));
        }
        if (certificateExtensions.getNameConstraints() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlNameConstraints(certificateExtensions.getNameConstraints()));
        }
        if (certificateExtensions.getExtendedKeyUsage() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlExtendedKeyUsages(certificateExtensions.getExtendedKeyUsage()));
        }
        if (certificateExtensions.getInhibitAnyPolicy() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlInhibitAnyPolicy(certificateExtensions.getInhibitAnyPolicy()));
        }
        if (certificateExtensions.getAuthorityInformationAccess() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlAuthorityInformationAccess(certificateExtensions.getAuthorityInformationAccess()));
        }
        if (certificateExtensions.getCRLDistributionPoints() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlCRLDistributionPoints(certificateExtensions.getCRLDistributionPoints()));
        }
        if (certificateExtensions.getFreshestCRL() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlFreshestCRL(certificateExtensions.getFreshestCRL()));
        }
        if (certificateExtensions.getOcspNoCheck() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlIdPkixOcspNoCheck(certificateExtensions.getOcspNoCheck()));
        }
        if (certificateExtensions.getValidityAssuredShortTerm() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlValAssuredShortTermCertificate(certificateExtensions.getValidityAssuredShortTerm()));
        }
        if (certificateExtensions.getNoRevAvail() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)this.getXmlNoRevAvail(certificateExtensions.getNoRevAvail()));
        }
        if (certificateExtensions.getQcStatements() != null) {
            xmlCertificateExtensions.add((XmlCertificateExtension)new XmlQcStatementsBuilder().build(certificateExtensions.getQcStatements()));
        }
        if (Utils.isCollectionNotEmpty((Collection)certificateExtensions.getOtherExtensions())) {
            xmlCertificateExtensions.addAll(this.getXmlOtherCertificateExtensions(certificateExtensions.getOtherExtensions()));
        }
        return xmlCertificateExtensions;
    }

    private XmlKeyUsages getXmlKeyUsages(KeyUsage keyUsage) {
        XmlKeyUsages xmlKeyUsages = new XmlKeyUsages();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlKeyUsages, (CertificateExtension)keyUsage);
        xmlKeyUsages.getKeyUsageBit().addAll(keyUsage.getKeyUsageBits());
        return xmlKeyUsages;
    }

    private XmlExtendedKeyUsages getXmlExtendedKeyUsages(ExtendedKeyUsages extendedKeyUsages) {
        XmlExtendedKeyUsages xmlExtendedKeyUsages = new XmlExtendedKeyUsages();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlExtendedKeyUsages, (CertificateExtension)extendedKeyUsages);
        xmlExtendedKeyUsages.getExtendedKeyUsageOid().addAll(this.getXmlOids(extendedKeyUsages.getOids()));
        return xmlExtendedKeyUsages;
    }

    private XmlCertificatePolicies getXmlCertificatePolicies(CertificatePolicies certificatePolicies) {
        XmlCertificatePolicies xmlCertificatePolicies = new XmlCertificatePolicies();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlCertificatePolicies, (CertificateExtension)certificatePolicies);
        xmlCertificatePolicies.getCertificatePolicy().addAll(this.getXmlCertificatePolicies(certificatePolicies.getPolicyList()));
        return xmlCertificatePolicies;
    }

    private List<XmlCertificatePolicy> getXmlCertificatePolicies(List<CertificatePolicy> certificatePolicies) {
        ArrayList<XmlCertificatePolicy> result = new ArrayList<XmlCertificatePolicy>();
        for (CertificatePolicy cp : certificatePolicies) {
            XmlCertificatePolicy xmlCP = new XmlCertificatePolicy();
            xmlCP.setValue(cp.getOid());
            xmlCP.setDescription(OidRepository.getDescription((String)cp.getOid()));
            xmlCP.setCpsUrl(this.getCleanedUrl(cp.getCpsUrl()));
            result.add(xmlCP);
        }
        return result;
    }

    private XmlSubjectAlternativeNames getXmlSubjectAlternativeNames(SubjectAlternativeNames subjectAlternativeNames) {
        XmlSubjectAlternativeNames xmlSubjectAlternativeNames = new XmlSubjectAlternativeNames();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlSubjectAlternativeNames, (CertificateExtension)subjectAlternativeNames);
        xmlSubjectAlternativeNames.getSubjectAlternativeName().addAll(this.getXmlGeneralNames(subjectAlternativeNames.getGeneralNames()));
        return xmlSubjectAlternativeNames;
    }

    private List<XmlGeneralName> getXmlGeneralNames(List<GeneralName> generalNames) {
        ArrayList<XmlGeneralName> result = new ArrayList<XmlGeneralName>();
        for (GeneralName generalName : generalNames) {
            result.add(this.getXmlGeneralName(generalName));
        }
        return result;
    }

    private XmlGeneralName getXmlGeneralName(GeneralName generalName) {
        XmlGeneralName xmlGeneralName = new XmlGeneralName();
        xmlGeneralName.setType(generalName.getGeneralNameType());
        xmlGeneralName.setValue(generalName.getValue());
        return xmlGeneralName;
    }

    private XmlBasicConstraints getXmlBasicConstraints(BasicConstraints basicConstraints) {
        XmlBasicConstraints xmlBasicConstraints = new XmlBasicConstraints();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlBasicConstraints, (CertificateExtension)basicConstraints);
        xmlBasicConstraints.setCA(basicConstraints.isCa());
        if (basicConstraints.getPathLenConstraint() != -1) {
            xmlBasicConstraints.setPathLenConstraint(Integer.valueOf(basicConstraints.getPathLenConstraint()));
        }
        return xmlBasicConstraints;
    }

    private XmlPolicyConstraints getXmlPolicyConstraints(PolicyConstraints policyConstraints) {
        XmlPolicyConstraints xmlPolicyConstraints = new XmlPolicyConstraints();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlPolicyConstraints, (CertificateExtension)policyConstraints);
        if (policyConstraints.getInhibitPolicyMapping() != -1) {
            xmlPolicyConstraints.setInhibitPolicyMapping(Integer.valueOf(policyConstraints.getInhibitPolicyMapping()));
        }
        if (policyConstraints.getRequireExplicitPolicy() != -1) {
            xmlPolicyConstraints.setRequireExplicitPolicy(Integer.valueOf(policyConstraints.getRequireExplicitPolicy()));
        }
        return xmlPolicyConstraints;
    }

    private XmlInhibitAnyPolicy getXmlInhibitAnyPolicy(InhibitAnyPolicy inhibitAnyPolicy) {
        XmlInhibitAnyPolicy xmlInhibitAnyPolicy = new XmlInhibitAnyPolicy();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlInhibitAnyPolicy, (CertificateExtension)inhibitAnyPolicy);
        if (inhibitAnyPolicy.getValue() != -1) {
            xmlInhibitAnyPolicy.setValue(Integer.valueOf(inhibitAnyPolicy.getValue()));
        }
        return xmlInhibitAnyPolicy;
    }

    private XmlNameConstraints getXmlNameConstraints(NameConstraints nameConstraints) {
        XmlNameConstraints xmlNameConstraints = new XmlNameConstraints();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlNameConstraints, (CertificateExtension)nameConstraints);
        if (Utils.isCollectionNotEmpty((Collection)nameConstraints.getPermittedSubtrees())) {
            xmlNameConstraints.getPermittedSubtrees().addAll(this.getXmlGeneralSubtrees(nameConstraints.getPermittedSubtrees()));
        }
        if (Utils.isCollectionNotEmpty((Collection)nameConstraints.getExcludedSubtrees())) {
            xmlNameConstraints.getExcludedSubtrees().addAll(this.getXmlGeneralSubtrees(nameConstraints.getExcludedSubtrees()));
        }
        return xmlNameConstraints;
    }

    private List<XmlGeneralSubtree> getXmlGeneralSubtrees(List<GeneralSubtree> generalSubtrees) {
        ArrayList<XmlGeneralSubtree> result = new ArrayList<XmlGeneralSubtree>();
        for (GeneralSubtree generalSubtree : generalSubtrees) {
            result.add(this.getXmlGeneralSubtree(generalSubtree));
        }
        return result;
    }

    private XmlGeneralSubtree getXmlGeneralSubtree(GeneralSubtree generalSubtree) {
        XmlGeneralSubtree xmlGeneralSubtree = new XmlGeneralSubtree();
        xmlGeneralSubtree.setType(generalSubtree.getGeneralNameType());
        xmlGeneralSubtree.setValue(generalSubtree.getValue());
        xmlGeneralSubtree.setMinimum(generalSubtree.getMinimum());
        xmlGeneralSubtree.setMaximum(generalSubtree.getMaximum());
        return xmlGeneralSubtree;
    }

    private XmlCRLDistributionPoints getXmlCRLDistributionPoints(CRLDistributionPoints crlDistributionPoints) {
        XmlCRLDistributionPoints xmlCRLDistributionPoints = new XmlCRLDistributionPoints();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlCRLDistributionPoints, (CertificateExtension)crlDistributionPoints);
        xmlCRLDistributionPoints.getCrlUrl().addAll(this.getCleanedUrls(crlDistributionPoints.getCrlUrls()));
        return xmlCRLDistributionPoints;
    }

    private XmlCRLDistributionPoints getXmlFreshestCRL(FreshestCRL freshestCRL) {
        XmlFreshestCRL xmlFreshestCRL = new XmlFreshestCRL();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlFreshestCRL, (CertificateExtension)freshestCRL);
        xmlFreshestCRL.getCrlUrl().addAll(this.getCleanedUrls(freshestCRL.getCrlUrls()));
        return xmlFreshestCRL;
    }

    private XmlAuthorityKeyIdentifier getXmlAuthorityKeyIdentifier(AuthorityKeyIdentifier aki) {
        XmlAuthorityKeyIdentifier xmlAuthorityKeyIdentifier = new XmlAuthorityKeyIdentifier();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlAuthorityKeyIdentifier, (CertificateExtension)aki);
        xmlAuthorityKeyIdentifier.setKeyIdentifier(aki.getKeyIdentifier());
        xmlAuthorityKeyIdentifier.setAuthorityCertIssuerSerial(aki.getAuthorityCertIssuerSerial());
        return xmlAuthorityKeyIdentifier;
    }

    private XmlSubjectKeyIdentifier getXmlSubjectKeyIdentifier(SubjectKeyIdentifier ski) {
        XmlSubjectKeyIdentifier xmlSubjectKeyIdentifier = new XmlSubjectKeyIdentifier();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlSubjectKeyIdentifier, (CertificateExtension)ski);
        xmlSubjectKeyIdentifier.setSki(ski.getSki());
        return xmlSubjectKeyIdentifier;
    }

    private XmlAuthorityInformationAccess getXmlAuthorityInformationAccess(AuthorityInformationAccess aia) {
        XmlAuthorityInformationAccess xmlAuthorityInformationAccess = new XmlAuthorityInformationAccess();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlAuthorityInformationAccess, (CertificateExtension)aia);
        xmlAuthorityInformationAccess.getCaIssuersUrls().addAll(this.getCleanedUrls(aia.getCaIssuers()));
        xmlAuthorityInformationAccess.getOcspUrls().addAll(this.getCleanedUrls(aia.getOcsp()));
        return xmlAuthorityInformationAccess;
    }

    private XmlIdPkixOcspNoCheck getXmlIdPkixOcspNoCheck(OCSPNoCheck ocspNoCheck) {
        XmlIdPkixOcspNoCheck xmlIdPkixOcspNoCheck = new XmlIdPkixOcspNoCheck();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlIdPkixOcspNoCheck, (CertificateExtension)ocspNoCheck);
        xmlIdPkixOcspNoCheck.setPresent(Boolean.valueOf(ocspNoCheck.isOcspNoCheck()));
        return xmlIdPkixOcspNoCheck;
    }

    private XmlValAssuredShortTermCertificate getXmlValAssuredShortTermCertificate(ValidityAssuredShortTerm valAssuredST) {
        XmlValAssuredShortTermCertificate xmlValAssuredShortTermCertificate = new XmlValAssuredShortTermCertificate();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlValAssuredShortTermCertificate, (CertificateExtension)valAssuredST);
        xmlValAssuredShortTermCertificate.setPresent(Boolean.valueOf(valAssuredST.isValAssuredSTCerts()));
        return xmlValAssuredShortTermCertificate;
    }

    private XmlNoRevAvail getXmlNoRevAvail(NoRevAvail noRevAvail) {
        XmlNoRevAvail xmlNoRevAvail = new XmlNoRevAvail();
        this.fillXmlCertificateExtension((XmlCertificateExtension)xmlNoRevAvail, (CertificateExtension)noRevAvail);
        xmlNoRevAvail.setPresent(Boolean.valueOf(noRevAvail.isNoRevAvail()));
        return xmlNoRevAvail;
    }

    private List<XmlCertificateExtension> getXmlOtherCertificateExtensions(List<CertificateExtension> otherCertificateExtensions) {
        ArrayList<XmlCertificateExtension> result = new ArrayList<XmlCertificateExtension>();
        for (CertificateExtension certificateExtension : otherCertificateExtensions) {
            XmlCertificateExtension xmlCertificateExtension = new XmlCertificateExtension();
            this.fillXmlCertificateExtension(xmlCertificateExtension, certificateExtension);
            xmlCertificateExtension.setOctets(certificateExtension.getOctets());
            result.add(xmlCertificateExtension);
        }
        return result;
    }

    private void fillXmlCertificateExtension(XmlCertificateExtension xmlCertificateExtension, CertificateExtension certificateExtension) {
        xmlCertificateExtension.setOID(certificateExtension.getOid());
        xmlCertificateExtension.setDescription(certificateExtension.getDescription());
        xmlCertificateExtension.setCritical(Boolean.valueOf(certificateExtension.isCritical()));
    }

    private XmlTrusted getXmlTrusted(CertificateToken certificateToken) {
        XmlTrusted xmlTrusted = new XmlTrusted();
        if (this.allCertificateSources.isTrusted(certificateToken)) {
            CertificateTrustTime certificateTrustTime = this.getCertificateTrustTime(certificateToken);
            if (certificateTrustTime != null) {
                xmlTrusted.setValue(certificateTrustTime.isTrusted());
                xmlTrusted.setStartDate(certificateTrustTime.getStartDate());
                xmlTrusted.setSunsetDate(certificateTrustTime.getEndDate());
            } else {
                xmlTrusted.setValue(true);
            }
        }
        return xmlTrusted;
    }

    private CertificateTrustTime getCertificateTrustTime(CertificateToken certificateToken) {
        CertificateTrustTime certificateTrustTime = null;
        for (CertificateSource trustedSource : this.allCertificateSources.getSources()) {
            if (!trustedSource.isTrusted(certificateToken)) continue;
            if (trustedSource instanceof TrustedCertificateSourceWithTime) {
                TrustedCertificateSourceWithTime trustedSourceWithTime = (TrustedCertificateSourceWithTime)trustedSource;
                CertificateTrustTime trustTime = trustedSourceWithTime.getTrustTime(certificateToken);
                if (certificateTrustTime == null || !certificateTrustTime.isTrusted()) {
                    certificateTrustTime = trustTime;
                    continue;
                }
                if (trustTime == null || !trustTime.isTrusted()) continue;
                certificateTrustTime = certificateTrustTime.getJointTrustTime(trustTime.getStartDate(), trustTime.getEndDate());
                continue;
            }
            certificateTrustTime = new CertificateTrustTime(true);
        }
        return certificateTrustTime;
    }

    private List<CertificateSourceType> getXmlCertificateSources(CertificateToken token) {
        Set sourceTypes;
        ArrayList<CertificateSourceType> certificateSources = new ArrayList<CertificateSourceType>();
        if (this.allCertificateSources != null && (sourceTypes = this.allCertificateSources.getCertificateSourceType(token)) != null) {
            certificateSources.addAll(sourceTypes);
        }
        if (Utils.isCollectionEmpty(certificateSources)) {
            certificateSources.add(CertificateSourceType.UNKNOWN);
        }
        return certificateSources;
    }

    private Set<RevocationToken<?>> getRevocationsForCert(CertificateToken certToken) {
        HashSet revocations = new HashSet();
        if (Utils.isCollectionNotEmpty(this.usedRevocations)) {
            for (RevocationToken<?> revocationToken : this.usedRevocations) {
                if (!Utils.areStringsEqual((String)certToken.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateId())) continue;
                revocations.add(revocationToken);
            }
        }
        return revocations;
    }

    private List<XmlOID> getXmlOids(Collection<String> oidList) {
        ArrayList<XmlOID> result = new ArrayList<XmlOID>();
        if (Utils.isCollectionNotEmpty(oidList)) {
            for (String oid : oidList) {
                XmlOID xmlOID = new XmlOID();
                xmlOID.setValue(oid);
                xmlOID.setDescription(OidRepository.getDescription((String)oid));
                result.add(xmlOID);
            }
        }
        return result;
    }

    protected XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(Digest digest) {
        if (digest == null) {
            return this.getXmlDigestAlgoAndValue(null, null);
        }
        return this.getXmlDigestAlgoAndValue(digest.getAlgorithm(), digest.getValue());
    }

    protected XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(DigestAlgorithm digestAlgo, byte[] digestValue) {
        XmlDigestAlgoAndValue xmlDigestAlgAndValue = new XmlDigestAlgoAndValue();
        xmlDigestAlgAndValue.setDigestMethod(digestAlgo);
        xmlDigestAlgAndValue.setDigestValue(digestValue == null ? DSSUtils.EMPTY_BYTE_ARRAY : digestValue);
        return xmlDigestAlgAndValue;
    }
}

