/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class EvidenceRecordValidationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final EvidenceRecordWrapper evidenceRecord;
    private final XmlValidationProcessEvidenceRecord erValidationResult;

    public EvidenceRecordValidationCheck(I18nProvider i18nProvider, T result, EvidenceRecordWrapper evidenceRecord, XmlValidationProcessEvidenceRecord erValidationResult, LevelRule constraint) {
        super(i18nProvider, result, constraint, evidenceRecord.getId());
        this.evidenceRecord = evidenceRecord;
        this.erValidationResult = erValidationResult;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.ER;
    }

    @Override
    protected boolean process() {
        return this.isValid((XmlConstraintsConclusion)this.erValidationResult);
    }

    @Override
    protected String buildAdditionalInfo() {
        String date = ValidationProcessUtils.getFormattedDate(this.erValidationResult.getProofOfExistence().getTime());
        return this.i18nProvider.getMessage(MessageTag.EVIDENCE_RECORD_VALIDATION, new Object[]{this.evidenceRecord.getId(), date});
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_IRERVPC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_IRERVPC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.erValidationResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.erValidationResult.getConclusion().getSubIndication();
    }
}

