/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.AbstractTrustServiceFilter;
import java.util.Collections;
import java.util.Set;

public class ServiceByCountryFilter
extends AbstractTrustServiceFilter {
    private final Set<String> countryCodes;

    public ServiceByCountryFilter(String countryCode) {
        this(Collections.singleton(countryCode));
    }

    public ServiceByCountryFilter(Set<String> countryCodes) {
        this.countryCodes = countryCodes;
    }

    @Override
    protected boolean isAcceptable(TrustServiceWrapper service) {
        for (String countryCode : this.countryCodes) {
            if (!Utils.areStringsEqualIgnoreCase((String)countryCode, (String)service.getCountryCode())) continue;
            return true;
        }
        return false;
    }
}

