/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.AdditionalServiceInformation;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustServiceCondition;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

class TrustServiceQualifierAndAdditionalServiceInfoConsistency
implements TrustServiceCondition {
    private static final Map<ServiceQualification, AdditionalServiceInformation> CORRESPONDENCE_MAP_QUALIFIER_ASI = new EnumMap<ServiceQualification, AdditionalServiceInformation>(ServiceQualification.class);

    @Override
    public boolean isConsistent(TrustServiceWrapper trustService) {
        List asis = trustService.getAdditionalServiceInfos();
        List qualifiers = ServiceQualification.getUsageQualifiers((List)trustService.getCapturedQualifierUris());
        return this.isQualifierInAdditionServiceInfos(qualifiers, asis);
    }

    private boolean isQualifierInAdditionServiceInfos(List<String> qualifiers, List<String> asis) {
        if (Utils.collectionSize(asis) >= 1 && Utils.collectionSize(qualifiers) == 1) {
            String currentUsage = qualifiers.get(0);
            ServiceQualification serviceQualification = ServiceQualification.getByUri((String)currentUsage);
            AdditionalServiceInformation expectedASI = CORRESPONDENCE_MAP_QUALIFIER_ASI.get(serviceQualification);
            return expectedASI != null && asis.contains(expectedASI.getUri());
        }
        return true;
    }

    static {
        CORRESPONDENCE_MAP_QUALIFIER_ASI.put(ServiceQualification.QC_FOR_ESIG, AdditionalServiceInformation.FOR_ESIGNATURES);
        CORRESPONDENCE_MAP_QUALIFIER_ASI.put(ServiceQualification.QC_FOR_ESEAL, AdditionalServiceInformation.FOR_ESEALS);
        CORRESPONDENCE_MAP_QUALIFIER_ASI.put(ServiceQualification.QC_FOR_WSA, AdditionalServiceInformation.FOR_WEB_AUTHENTICATION);
    }
}

