/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class RevocationIssuerValidAtProductionTimeCheck
extends ChainItem<XmlRAC> {
    private final RevocationWrapper revocationData;

    public RevocationIssuerValidAtProductionTimeCheck(I18nProvider i18nProvider, XmlRAC result, RevocationWrapper revocationData, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.revocationData = revocationData;
    }

    @Override
    protected boolean process() {
        return !RevocationType.OCSP.equals((Object)this.revocationData.getRevocationType()) || this.checkOCSPResponderValidAtRevocationProductionTime();
    }

    private boolean checkOCSPResponderValidAtRevocationProductionTime() {
        CertificateWrapper revocationIssuer = this.revocationData.getSigningCertificate();
        Date producedAt = this.revocationData.getProductionDate();
        return revocationIssuer != null && producedAt.compareTo(revocationIssuer.getNotBefore()) >= 0 && producedAt.compareTo(revocationIssuer.getNotAfter()) <= 0;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.revocationData.getSigningCertificate() != null) {
            MessageTag messageTag = this.process() ? MessageTag.REVOCATION_PRODUCED_AT_CERT_VALIDITY : MessageTag.REVOCATION_PRODUCED_AT_OUT_OF_BOUNDS;
            return this.i18nProvider.getMessage(messageTag, new Object[]{ValidationProcessUtils.getFormattedDate(this.revocationData.getProductionDate()), ValidationProcessUtils.getFormattedDate(this.revocationData.getSigningCertificate().getNotBefore()), ValidationProcessUtils.getFormattedDate(this.revocationData.getSigningCertificate().getNotAfter())});
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_REVOC_ISSUER_VALID_AT_PROD;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_REVOC_ISSUER_VALID_AT_PROD_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

