/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.Collection;
import java.util.List;

public class StructuralValidationCheck
extends ChainItem<XmlSAV> {
    private final SignatureWrapper signature;

    public StructuralValidationCheck(I18nProvider i18nProvider, XmlSAV result, SignatureWrapper signature, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        return this.signature.isStructuralValidationValid();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_ISSV;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_ISSV_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }

    @Override
    protected String buildAdditionalInfo() {
        List errorMessages = this.signature.getStructuralValidationMessages();
        if (Utils.isCollectionNotEmpty((Collection)errorMessages)) {
            return this.i18nProvider.getMessage(MessageTag.STRUCTURAL_VALIDATION_FAILURE, new Object[]{errorMessages.toString()});
        }
        return null;
    }
}

