/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.AbstractCryptographicCheckerResultCheck;
import java.util.Date;

public class DigestCryptographicCheckerResultCheck<T extends XmlConstraintsConclusion>
extends AbstractCryptographicCheckerResultCheck<T> {
    protected final Date validationDate;

    public DigestCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, Date validationDate, MessageTag position, XmlCC ccResult, LevelRule constraint) {
        super(i18nProvider, result, position, ccResult, constraint);
        this.validationDate = validationDate;
    }

    @Override
    protected String buildAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (this.isValid((XmlConstraintsConclusion)this.ccResult)) {
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_DM, new Object[]{this.ccResult.getVerifiedAlgorithm().getName(), dateTime, this.position});
        }
        return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_REF, new Object[]{this.getErrorMessage(), dateTime});
    }
}

