/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlStatus;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractCryptographicCheckerResultCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    protected final MessageTag position;
    protected final XmlCC ccResult;
    private final XmlMessage checkerResultMessage;

    protected AbstractCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, MessageTag position, XmlCC ccResult, LevelRule constraint) {
        this(i18nProvider, result, position, ccResult, constraint, null);
    }

    protected AbstractCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, MessageTag position, XmlCC ccResult, LevelRule constraint, String tokenId) {
        super(i18nProvider, result, constraint, tokenId);
        this.position = position;
        this.ccResult = ccResult;
        this.checkerResultMessage = AbstractCryptographicCheckerResultCheck.extractXmlMessage(ccResult, constraint);
    }

    private static XmlMessage extractXmlMessage(XmlCC ccResult, LevelRule constraint) {
        XmlConclusion conclusion = ccResult.getConclusion();
        if (conclusion != null && constraint != null && constraint.getLevel() != null) {
            ArrayList messages = new ArrayList();
            messages.addAll(conclusion.getErrors());
            messages.addAll(conclusion.getWarnings());
            messages.addAll(conclusion.getInfos());
            if (Utils.isCollectionNotEmpty(messages)) {
                return (XmlMessage)messages.iterator().next();
            }
        }
        return null;
    }

    @Override
    protected boolean process() {
        return this.isValid((XmlConstraintsConclusion)this.ccResult) && this.allConstraintsValid((XmlConstraintsConclusion)this.ccResult);
    }

    private boolean allConstraintsValid(XmlConstraintsConclusion result) {
        List constraints = result.getConstraint();
        if (Utils.isCollectionNotEmpty((Collection)constraints)) {
            for (XmlConstraint constraint : constraints) {
                if (XmlStatus.OK.equals((Object)constraint.getStatus()) || XmlStatus.IGNORED.equals((Object)constraint.getStatus())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected Level getLevel() {
        XmlConclusion conclusion = this.ccResult.getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty((Collection)conclusion.getErrors())) {
                return Level.FAIL;
            }
            if (Utils.isCollectionNotEmpty((Collection)conclusion.getWarnings())) {
                return Level.WARN;
            }
            if (Utils.isCollectionNotEmpty((Collection)conclusion.getInfos())) {
                return Level.INFORM;
            }
        }
        return super.getLevel();
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ACCM, this.position);
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.checkerResultMessage;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.ccResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.ccResult.getConclusion().getSubIndication();
    }

    @Override
    protected List<XmlMessage> getPreviousErrors() {
        return this.ccResult.getConclusion().getErrors();
    }

    protected String getErrorMessage() {
        XmlMessage errorMessage = this.buildErrorMessage();
        return errorMessage != null ? errorMessage.getValue() : "";
    }
}

