/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.isc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.detailedreport.jaxb.XmlChainItem;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.DigestValueMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.DigestValuePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.IssuerSerialMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.SigningCertificateRecognitionCheck;
import java.util.List;

public class IdentificationOfTheSigningCertificate
extends Chain<XmlISC> {
    private final TokenProxy token;
    private final ValidationPolicy validationPolicy;
    private final Context context;

    public IdentificationOfTheSigningCertificate(I18nProvider i18nProvider, TokenProxy token, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlISC());
        this.token = token;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.IDENTIFICATION_OF_THE_SIGNING_CERTIFICATE;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlISC> item = this.firstItem = this.signingCertificateRecognition();
        boolean isSignature = Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context);
        boolean isTimestamp = Context.TIMESTAMP.equals((Object)this.context);
        if (isSignature || isTimestamp) {
            if (!this.token.isSigningCertificateReferencePresent()) {
                return;
            }
            item = item.setNextItem(this.digestValuePresent());
            item = item.setNextItem(this.digestValueMatch());
            CertificateRefWrapper signingCertificateRef = this.token.getSigningCertificateReference();
            if (signingCertificateRef != null && signingCertificateRef.isIssuerSerialPresent()) {
                item = item.setNextItem(this.issuerSerialMatch());
            }
        }
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        if (this.token.getCertificateChain() != null) {
            XmlCertificateChain certificateChain = new XmlCertificateChain();
            for (CertificateWrapper certificate : this.token.getCertificateChain()) {
                XmlChainItem chainItem = new XmlChainItem();
                chainItem.setId(certificate.getId());
                List sources = certificate.getSources();
                if (sources.contains(CertificateSourceType.TRUSTED_LIST)) {
                    chainItem.setSource(CertificateSourceType.TRUSTED_LIST);
                } else if (sources.contains(CertificateSourceType.TRUSTED_STORE)) {
                    chainItem.setSource(CertificateSourceType.TRUSTED_STORE);
                } else {
                    chainItem.setSource((CertificateSourceType)sources.iterator().next());
                }
                certificateChain.getChainItem().add(chainItem);
            }
            ((XmlISC)this.result).setCertificateChain(certificateChain);
        }
    }

    private ChainItem<XmlISC> signingCertificateRecognition() {
        LevelRule constraint = this.validationPolicy.getSigningCertificateRecognitionConstraint(this.context);
        return new SigningCertificateRecognitionCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> digestValuePresent() {
        LevelRule constraint = this.validationPolicy.getSigningCertificateDigestValuePresentConstraint(this.context);
        return new DigestValuePresentCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> digestValueMatch() {
        LevelRule constraint = this.validationPolicy.getSigningCertificateDigestValueMatchConstraint(this.context);
        return new DigestValueMatchCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> issuerSerialMatch() {
        LevelRule constraint = this.validationPolicy.getSigningCertificateIssuerSerialMatchConstraint(this.context);
        return new IssuerSerialMatchCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }
}

