/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FilenameAdherenceCheck;

public class SignatureFilenameAdherenceCheck
extends FilenameAdherenceCheck<SignatureWrapper> {
    private static final String SIGNATURES_FILENAME = "signatures";
    private static final String CADES_SIGNATURE_EXTENSION = ".p7s";
    private static final String SIGNATURES_XML = "META-INF/signatures.xml";
    private static final String SIGNATURE_P7S = "META-INF/signature.p7s";

    public SignatureFilenameAdherenceCheck(I18nProvider i18nProvider, XmlFC result, DiagnosticData diagnosticData, SignatureWrapper token, LevelRule constraint) {
        super(i18nProvider, result, diagnosticData, token, constraint);
    }

    @Override
    protected boolean process() {
        String filename = ((SignatureWrapper)this.token).getFilename();
        if (Utils.isStringEmpty((String)filename)) {
            return false;
        }
        switch (this.diagnosticData.getContainerType()) {
            case ASiC_S: {
                switch (((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm()) {
                    case XAdES: {
                        return SIGNATURES_XML.equals(filename);
                    }
                    case CAdES: {
                        return SIGNATURE_P7S.equals(filename);
                    }
                }
                throw new UnsupportedOperationException(String.format("Only XAdES and CAdES ASiC container types are supported! Found : %s", ((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm()));
            }
            case ASiC_E: {
                switch (((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm()) {
                    case XAdES: {
                        return filename.startsWith("META-INF/") && filename.contains(SIGNATURES_FILENAME) && filename.endsWith(".xml");
                    }
                    case CAdES: {
                        return filename.startsWith("META-INF/") && filename.contains("signature") && filename.endsWith(CADES_SIGNATURE_EXTENSION);
                    }
                }
                throw new UnsupportedOperationException(String.format("Only XAdES and CAdES ASiC container types are supported! Found : %s", ((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm()));
            }
        }
        throw new UnsupportedOperationException(String.format("Container type '%s' is not supported!", this.diagnosticData.getContainerType()));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_ISFCS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_ISFCS_ANS;
    }
}

