/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public class ReferenceDataGroupCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final List<XmlDigestMatcher> digestMatchers;

    public ReferenceDataGroupCheck(I18nProvider i18nProvider, T result, List<XmlDigestMatcher> digestMatchers, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.digestMatchers = digestMatchers;
    }

    @Override
    protected boolean process() {
        return this.digestMatchers.stream().noneMatch(d -> DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE == d.getType());
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_CV_ER_DFHVLCDOG;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_CV_ER_DFHVLCDOG_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIGNED_DATA_NOT_FOUND;
    }
}

