/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlStatus;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChainItem<T extends XmlConstraintsConclusion> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainItem.class);
    protected final I18nProvider i18nProvider;
    private final LevelRule constraint;
    private ChainItem<T> nextItem;
    private T result;
    private String bbbId;

    protected ChainItem(I18nProvider i18nProvider, T result, LevelRule constraint) {
        this(i18nProvider, result, constraint, null);
    }

    protected ChainItem(I18nProvider i18nProvider, T result, LevelRule constraint, String bbbId) {
        Objects.requireNonNull(i18nProvider, "i18nProvider must be defined!");
        this.i18nProvider = i18nProvider;
        this.result = result;
        this.constraint = constraint;
        this.bbbId = bbbId;
    }

    public ChainItem<T> setNextItem(ChainItem<T> nextItem) {
        this.nextItem = nextItem;
        return nextItem;
    }

    public void execute() {
        Level level = this.getLevel();
        if (level == null) {
            LOG.trace("Check skipped : constraint not defined");
            this.callNext();
        } else {
            switch (level) {
                case IGNORE: {
                    this.ignore();
                    break;
                }
                case FAIL: {
                    this.fail();
                    break;
                }
                case INFORM: 
                case WARN: {
                    this.informOrWarn(level);
                    break;
                }
                default: {
                    LOG.warn("Unknown level : {}", (Object)level);
                }
            }
        }
    }

    protected abstract boolean process();

    protected Level getLevel() {
        return this.constraint != null ? this.constraint.getLevel() : null;
    }

    protected MessageTag getMessageTag() {
        return null;
    }

    protected MessageTag getErrorMessageTag() {
        return null;
    }

    protected List<XmlMessage> getPreviousErrors() {
        return Collections.emptyList();
    }

    protected abstract Indication getFailedIndicationForConclusion();

    protected abstract SubIndication getFailedSubIndicationForConclusion();

    private void recordIgnore() {
        this.recordConstraint(XmlStatus.IGNORED);
    }

    private void recordValid() {
        this.recordConstraint(XmlStatus.OK);
    }

    private void recordInvalid() {
        this.recordConstraint(XmlStatus.NOT_OK);
    }

    private void recordCustomSuccessConclusion() {
        XmlConclusion conclusion = new XmlConclusion();
        conclusion.setIndication(this.getSuccessIndication());
        conclusion.setSubIndication(this.getSuccessSubIndication());
        this.result.setConclusion(conclusion);
    }

    private void recordConclusion() {
        XmlConclusion conclusion = new XmlConclusion();
        conclusion.setIndication(this.getFailedIndicationForConclusion());
        conclusion.setSubIndication(this.getFailedSubIndicationForConclusion());
        List<XmlMessage> previousErrors = this.getPreviousErrors();
        if (Utils.isCollectionNotEmpty(previousErrors)) {
            conclusion.getErrors().addAll(previousErrors);
        } else {
            conclusion.getErrors().add(this.buildErrorMessage());
        }
        this.result.setConclusion(conclusion);
    }

    private void recordInfosOrWarns(Level level) {
        if (Level.INFORM.equals((Object)level)) {
            this.recordConstraint(XmlStatus.INFORMATION);
        } else if (Level.WARN.equals((Object)level)) {
            this.recordConstraint(XmlStatus.WARNING);
        }
    }

    private void recordConstraint(XmlStatus status) {
        XmlConstraint xmlConstraint = new XmlConstraint();
        xmlConstraint.setName(this.buildConstraintMessage());
        xmlConstraint.setStatus(status);
        xmlConstraint.setId(this.bbbId);
        xmlConstraint.setBlockType(this.getBlockType());
        if (XmlStatus.NOT_OK.equals((Object)status)) {
            xmlConstraint.setError(this.buildErrorMessage());
        } else if (XmlStatus.WARNING.equals((Object)status)) {
            xmlConstraint.setWarning(this.buildErrorMessage());
        } else if (XmlStatus.INFORMATION.equals((Object)status)) {
            xmlConstraint.setInfo(this.buildErrorMessage());
        }
        if (!XmlStatus.IGNORED.equals((Object)status)) {
            xmlConstraint.setAdditionalInfo(this.buildAdditionalInfo());
        }
        this.addConstraint(xmlConstraint);
    }

    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(this.getErrorMessageTag(), new Object[0]);
    }

    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(this.getMessageTag(), new Object[0]);
    }

    protected XmlBlockType getBlockType() {
        return null;
    }

    protected String buildAdditionalInfo() {
        return ValidationProcessUtils.buildStringMessage(this.i18nProvider, this.getAdditionalInfo(), new Object[0]);
    }

    protected MessageTag getAdditionalInfo() {
        return null;
    }

    private void addConstraint(XmlConstraint constraint) {
        this.result.getConstraint().add(constraint);
    }

    protected XmlMessage buildXmlMessage(MessageTag messageTag, Object ... args) {
        XmlMessage xmlMessage = new XmlMessage();
        String message = this.i18nProvider.getMessage(messageTag, args);
        if (message != null) {
            xmlMessage.setKey(messageTag.getId());
            xmlMessage.setValue(message);
        } else {
            LOG.error("MessageTag [{}] is not defined in dss-messages.properties!", (Object)messageTag);
        }
        return xmlMessage;
    }

    private void fail() {
        boolean valid = this.process();
        if (valid) {
            this.recordValid();
            if (!this.isCustomSuccessConclusion()) {
                this.callNext();
            } else {
                this.recordCustomSuccessConclusion();
            }
        } else {
            this.recordInvalid();
            this.recordConclusion();
        }
    }

    private boolean isCustomSuccessConclusion() {
        return this.getSuccessIndication() != null;
    }

    protected Indication getSuccessIndication() {
        return null;
    }

    protected SubIndication getSuccessSubIndication() {
        return null;
    }

    private void informOrWarn(Level level) {
        boolean valid = this.process();
        if (valid) {
            this.recordValid();
        } else {
            this.recordInfosOrWarns(level);
        }
        this.callNext();
    }

    private void ignore() {
        this.recordIgnore();
        this.callNext();
    }

    private void callNext() {
        if (this.nextItem != null) {
            this.nextItem.execute();
        }
    }

    protected boolean isValid(XmlConstraintsConclusion constraintConclusion) {
        return constraintConclusion != null && this.isValidConclusion(constraintConclusion.getConclusion());
    }

    protected boolean isValidConclusion(XmlConclusion conclusion) {
        return conclusion != null && Indication.PASSED.equals((Object)conclusion.getIndication());
    }

    protected boolean isInvalidConclusion(XmlConclusion conclusion) {
        return conclusion != null && Indication.FAILED.equals((Object)conclusion.getIndication());
    }

    protected boolean isIndeterminateConclusion(XmlConclusion conclusion) {
        return conclusion != null && Indication.INDETERMINATE.equals((Object)conclusion.getIndication());
    }
}

