/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.EncryptionAlgorithmWithMinKeySize;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class CryptographicSuiteUtils {
    private CryptographicSuiteUtils() {
    }

    public static boolean isEncryptionAlgorithmReliable(CryptographicSuite cryptographicSuite, EncryptionAlgorithm encryptionAlgorithm) {
        if (cryptographicSuite == null) {
            return true;
        }
        return encryptionAlgorithm != null && cryptographicSuite.getAcceptableEncryptionAlgorithms().contains(encryptionAlgorithm);
    }

    public static boolean isDigestAlgorithmReliable(CryptographicSuite cryptographicSuite, DigestAlgorithm digestAlgorithm) {
        if (cryptographicSuite == null) {
            return true;
        }
        if (digestAlgorithm != null) {
            for (DigestAlgorithm acceptableDigestAlgorithm : cryptographicSuite.getAcceptableDigestAlgorithms()) {
                if (digestAlgorithm != acceptableDigestAlgorithm) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEncryptionAlgorithmWithKeySizeReliable(CryptographicSuite cryptographicSuite, EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        int keySize = CryptographicSuiteUtils.parseKeySize(keyLength);
        return CryptographicSuiteUtils.isEncryptionAlgorithmWithKeySizeReliable(cryptographicSuite, encryptionAlgorithm, keySize);
    }

    public static boolean isEncryptionAlgorithmWithKeySizeReliable(CryptographicSuite cryptographicSuite, EncryptionAlgorithm encryptionAlgorithm, Integer keySize) {
        if (cryptographicSuite == null) {
            return true;
        }
        boolean foundAlgorithm = false;
        if (encryptionAlgorithm != null && keySize != 0) {
            for (EncryptionAlgorithmWithMinKeySize encryptionAlgorithmWithMinKeySize : cryptographicSuite.getAcceptableEncryptionAlgorithmsWithMinKeySizes()) {
                int minKeySize = encryptionAlgorithmWithMinKeySize.getMinKeySize();
                if (encryptionAlgorithm != encryptionAlgorithmWithMinKeySize.getEncryptionAlgorithm()) continue;
                foundAlgorithm = true;
                if (minKeySize > keySize) continue;
                return true;
            }
        }
        return !foundAlgorithm;
    }

    private static int parseKeySize(String keyLength) {
        return Utils.isStringDigits((String)keyLength) ? Integer.parseInt(keyLength) : 0;
    }

    public static Date getExpirationDate(CryptographicSuite cryptographicSuite, EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        int keySize = CryptographicSuiteUtils.parseKeySize(keyLength);
        return CryptographicSuiteUtils.getExpirationDate(cryptographicSuite, encryptionAlgorithm, keySize);
    }

    public static Date getExpirationDate(CryptographicSuite cryptographicSuite, EncryptionAlgorithm encryptionAlgorithm, Integer keySize) {
        TreeMap<Integer, Date> dates = new TreeMap<Integer, Date>();
        Map encryptionAlgorithmsWithExpirationDates = cryptographicSuite.getAcceptableEncryptionAlgorithmsWithExpirationDates();
        for (Map.Entry entry : encryptionAlgorithmsWithExpirationDates.entrySet()) {
            EncryptionAlgorithmWithMinKeySize encryptionAlgorithmWithMinKeySize = (EncryptionAlgorithmWithMinKeySize)entry.getKey();
            if (encryptionAlgorithm != encryptionAlgorithmWithMinKeySize.getEncryptionAlgorithm()) continue;
            dates.put(encryptionAlgorithmWithMinKeySize.getMinKeySize(), (Date)entry.getValue());
        }
        for (EncryptionAlgorithmWithMinKeySize encryptionAlgorithmWithMinKeySize : cryptographicSuite.getAcceptableEncryptionAlgorithmsWithMinKeySizes()) {
            Map.Entry ceilingEntry;
            Map.Entry floorEntry;
            if (encryptionAlgorithm != encryptionAlgorithmWithMinKeySize.getEncryptionAlgorithm() || (floorEntry = dates.floorEntry(encryptionAlgorithmWithMinKeySize.getMinKeySize())) != null || (ceilingEntry = dates.ceilingEntry(encryptionAlgorithmWithMinKeySize.getMinKeySize())) == null) continue;
            dates.put(encryptionAlgorithmWithMinKeySize.getMinKeySize(), (Date)ceilingEntry.getValue());
        }
        Map.Entry floorEntry = dates.floorEntry(keySize);
        if (floorEntry == null) {
            return null;
        }
        return (Date)floorEntry.getValue();
    }

    public static Date getExpirationDate(CryptographicSuite cryptographicSuite, DigestAlgorithm digestAlgorithm) {
        Map digestAlgorithmsWithExpirationDates = cryptographicSuite.getAcceptableDigestAlgorithmsWithExpirationDates();
        return (Date)digestAlgorithmsWithExpirationDates.get(digestAlgorithm);
    }

    public static List<DigestAlgorithm> getReliableDigestAlgorithmsAtTime(CryptographicSuite cryptographicSuite, Date validationTime) {
        ArrayList<DigestAlgorithm> reliableDigestAlgorithms = new ArrayList<DigestAlgorithm>();
        List acceptableDigestAlgorithms = cryptographicSuite.getAcceptableDigestAlgorithms();
        Map digestAlgorithmsWithExpirationDates = cryptographicSuite.getAcceptableDigestAlgorithmsWithExpirationDates();
        for (Map.Entry entry : digestAlgorithmsWithExpirationDates.entrySet()) {
            Date expirationDate;
            DigestAlgorithm digestAlgorithm = (DigestAlgorithm)entry.getKey();
            if (!acceptableDigestAlgorithms.contains(digestAlgorithm) || !CryptographicSuiteUtils.isReliableAtTime(expirationDate = (Date)entry.getValue(), validationTime)) continue;
            reliableDigestAlgorithms.add(digestAlgorithm);
        }
        for (DigestAlgorithm digestAlgorithm : acceptableDigestAlgorithms) {
            Date expirationDate;
            if (reliableDigestAlgorithms.contains(digestAlgorithm) || !CryptographicSuiteUtils.isReliableAtTime(expirationDate = (Date)digestAlgorithmsWithExpirationDates.get(digestAlgorithm), validationTime)) continue;
            reliableDigestAlgorithms.add(digestAlgorithm);
        }
        return reliableDigestAlgorithms;
    }

    private static boolean isReliableAtTime(Date expirationDate, Date validationTime) {
        return expirationDate == null || !expirationDate.before(validationTime);
    }

    public static List<EncryptionAlgorithmWithMinKeySize> getReliableEncryptionAlgorithmsWithMinimalKeyLengthAtTime(CryptographicSuite cryptographicSuite, Date validationTime) {
        EnumMap<EncryptionAlgorithm, Integer> reliableEncryptionAlgorithms = new EnumMap<EncryptionAlgorithm, Integer>(EncryptionAlgorithm.class);
        HashSet<EncryptionAlgorithm> processedEncryptionAlgorithms = new HashSet<EncryptionAlgorithm>();
        List acceptableEncryptionAlgorithms = cryptographicSuite.getAcceptableEncryptionAlgorithms();
        Map encryptionAlgorithmsWithExpirationDates = cryptographicSuite.getAcceptableEncryptionAlgorithmsWithExpirationDates();
        for (Map.Entry entry : encryptionAlgorithmsWithExpirationDates.entrySet()) {
            Date expirationDate;
            Integer minKeySize;
            EncryptionAlgorithmWithMinKeySize encryptionAlgorithmWithMinKeySize = (EncryptionAlgorithmWithMinKeySize)entry.getKey();
            EncryptionAlgorithm encryptionAlgorithm = encryptionAlgorithmWithMinKeySize.getEncryptionAlgorithm();
            int keySize = encryptionAlgorithmWithMinKeySize.getMinKeySize();
            if (acceptableEncryptionAlgorithms.contains(encryptionAlgorithm) && ((minKeySize = (Integer)reliableEncryptionAlgorithms.get(encryptionAlgorithm)) == null || minKeySize > keySize) && CryptographicSuiteUtils.isReliableAtTime(expirationDate = (Date)entry.getValue(), validationTime)) {
                reliableEncryptionAlgorithms.put(encryptionAlgorithm, keySize);
            }
            processedEncryptionAlgorithms.add(encryptionAlgorithm);
        }
        for (EncryptionAlgorithmWithMinKeySize encryptionAlgorithmWithMinKeySize : cryptographicSuite.getAcceptableEncryptionAlgorithmsWithMinKeySizes()) {
            Integer minKeySize;
            EncryptionAlgorithm encryptionAlgorithm = encryptionAlgorithmWithMinKeySize.getEncryptionAlgorithm();
            int keySize = encryptionAlgorithmWithMinKeySize.getMinKeySize();
            if (!processedEncryptionAlgorithms.contains(encryptionAlgorithm)) {
                reliableEncryptionAlgorithms.put(encryptionAlgorithm, keySize);
            } else if (reliableEncryptionAlgorithms.containsKey(encryptionAlgorithm) && ((minKeySize = (Integer)reliableEncryptionAlgorithms.get(encryptionAlgorithm)) == null || minKeySize < keySize)) {
                reliableEncryptionAlgorithms.put(encryptionAlgorithm, keySize);
            }
            processedEncryptionAlgorithms.add(encryptionAlgorithm);
        }
        for (EncryptionAlgorithm encryptionAlgorithm : acceptableEncryptionAlgorithms) {
            if (processedEncryptionAlgorithms.contains(encryptionAlgorithm)) continue;
            reliableEncryptionAlgorithms.put(encryptionAlgorithm, 0);
        }
        ArrayList<EncryptionAlgorithmWithMinKeySize> result = new ArrayList<EncryptionAlgorithmWithMinKeySize>();
        for (Map.Entry entry : reliableEncryptionAlgorithms.entrySet()) {
            result.add(new EncryptionAlgorithmWithMinKeySize((EncryptionAlgorithm)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        return result;
    }
}

