/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.certificate;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustServiceProvider;
import eu.europa.esig.dss.jaxb.object.Message;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlChainItem;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlDetails;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlMessage;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlRevocation;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSimpleCertificateReport;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSubject;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlTrustAnchor;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleReportForCertificateBuilder {
    private final DiagnosticData diagnosticData;
    private final DetailedReport detailedReport;
    private final ValidationPolicy policy;
    private final Date currentTime;
    private final String certificateId;

    public SimpleReportForCertificateBuilder(DiagnosticData diagnosticData, DetailedReport detailedReport, ValidationPolicy policy, Date currentTime, String certificateId) {
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
        this.policy = policy;
        this.currentTime = currentTime;
        this.certificateId = certificateId;
    }

    public XmlSimpleCertificateReport build() {
        XmlSimpleCertificateReport simpleReport = new XmlSimpleCertificateReport();
        this.addPolicyNode(simpleReport);
        this.addValidationTime(simpleReport);
        simpleReport.setValidationTime(this.currentTime);
        ArrayList<XmlChainItem> chain = new ArrayList<XmlChainItem>();
        CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(this.certificateId);
        XmlChainItem firstChainItem = this.getChainItem(certificate);
        this.addQualifications(firstChainItem, certificate);
        chain.add(firstChainItem);
        List certificateChain = certificate.getCertificateChain();
        for (CertificateWrapper cert : certificateChain) {
            chain.add(this.getChainItem(cert));
        }
        simpleReport.setChain(chain);
        return simpleReport;
    }

    private void addPolicyNode(XmlSimpleCertificateReport report) {
        XmlValidationPolicy xmlPolicy = new XmlValidationPolicy();
        xmlPolicy.setPolicyName(this.policy.getPolicyName());
        xmlPolicy.setPolicyDescription(this.policy.getPolicyDescription());
        report.setValidationPolicy(xmlPolicy);
    }

    private void addValidationTime(XmlSimpleCertificateReport report) {
        report.setValidationTime(this.currentTime);
    }

    private XmlChainItem getChainItem(CertificateWrapper certificate) {
        XmlChainItem item = new XmlChainItem();
        item.setId(certificate.getId());
        item.setSubject(this.getSubject(certificate));
        CertificateWrapper signingCertificate = certificate.getSigningCertificate();
        if (signingCertificate != null) {
            item.setIssuerId(signingCertificate.getId());
        }
        item.setNotBefore(certificate.getNotBefore());
        item.setNotAfter(certificate.getNotAfter());
        item.setKeyUsages(certificate.getKeyUsages());
        item.setExtendedKeyUsages(this.getReadable(certificate.getExtendedKeyUsages()));
        item.setAiaUrls(this.emptyToNull(certificate.getCAIssuersAccessUrls()));
        item.setOcspUrls(this.emptyToNull(certificate.getOCSPAccessUrls()));
        item.setCrlUrls(this.emptyToNull(certificate.getCRLDistributionPoints()));
        item.setCpsUrls(this.emptyToNull(certificate.getCpsUrls()));
        item.setPdsUrls(null);
        XmlRevocation revocation = new XmlRevocation();
        CertificateRevocationWrapper revocationData = this.diagnosticData.getLatestRevocationDataForCertificate(certificate);
        if (revocationData != null) {
            revocation.setThisUpdate(revocationData.getThisUpdate());
            revocation.setRevocationDate(revocationData.getRevocationDate());
            revocation.setRevocationReason(revocationData.getReason());
        }
        item.setRevocation(revocation);
        if (certificate.isTrusted()) {
            List<XmlTrustServiceProvider> trustServiceProviders = this.filterByCertificateId(certificate.getTrustServiceProviders(), certificate.getId());
            ArrayList<XmlTrustAnchor> trustAnchors = new ArrayList<XmlTrustAnchor>();
            for (XmlTrustServiceProvider xmlTrustServiceProvider : trustServiceProviders) {
                List trustServices = xmlTrustServiceProvider.getTrustServices();
                Set<String> uniqueServiceNames = this.getUniqueServiceNames(trustServices);
                for (String serviceName : uniqueServiceNames) {
                    XmlTrustAnchor trustAnchor = new XmlTrustAnchor();
                    if (xmlTrustServiceProvider.getTL() != null) {
                        trustAnchor.setCountryCode(xmlTrustServiceProvider.getTL().getCountryCode());
                        trustAnchor.setTslType(xmlTrustServiceProvider.getTL().getTSLType());
                    }
                    trustAnchor.setTrustServiceProvider(this.getEnOrFirst(xmlTrustServiceProvider.getTSPNames()));
                    List tspRegistrationIdentifiers = xmlTrustServiceProvider.getTSPRegistrationIdentifiers();
                    if (Utils.isCollectionNotEmpty((Collection)tspRegistrationIdentifiers)) {
                        trustAnchor.setTrustServiceProviderRegistrationId((String)tspRegistrationIdentifiers.get(0));
                    }
                    trustAnchor.setTrustServiceName(serviceName);
                    trustAnchors.add(trustAnchor);
                }
            }
            item.setTrustAnchors(trustAnchors);
            item.setTrustStartDate(certificate.getTrustStartDate());
            item.setTrustSunsetDate(certificate.getTrustSunsetDate());
        } else {
            item.setTrustAnchors(null);
        }
        XmlConclusion conclusion = this.detailedReport.getCertificateXCVConclusion(certificate.getId());
        item.setIndication(conclusion.getIndication());
        item.setSubIndication(conclusion.getSubIndication());
        XmlDetails validationDetails = this.getX509ValidationDetails(certificate.getId());
        if (this.isNotEmpty(validationDetails)) {
            item.setX509ValidationDetails(validationDetails);
        }
        return item;
    }

    private String getEnOrFirst(List<XmlLangAndValue> langAndValues) {
        if (Utils.isCollectionNotEmpty(langAndValues)) {
            for (XmlLangAndValue langAndValue : langAndValues) {
                if (langAndValue.getLang() == null || !"en".equalsIgnoreCase(langAndValue.getLang())) continue;
                return langAndValue.getValue();
            }
            return langAndValues.get(0).getValue();
        }
        return null;
    }

    private List<XmlTrustServiceProvider> filterByCertificateId(List<XmlTrustServiceProvider> trustServiceProviders, String certificateId) {
        ArrayList<XmlTrustServiceProvider> result = new ArrayList<XmlTrustServiceProvider>();
        for (XmlTrustServiceProvider xmlTrustServiceProvider : trustServiceProviders) {
            List trustServices = xmlTrustServiceProvider.getTrustServices();
            boolean foundCertId = false;
            for (XmlTrustService xmlTrustService : trustServices) {
                if (!Utils.areStringsEqual((String)certificateId, (String)xmlTrustService.getServiceDigitalIdentifier().getId())) continue;
                foundCertId = true;
                break;
            }
            if (!foundCertId) continue;
            result.add(xmlTrustServiceProvider);
        }
        return result;
    }

    private List<String> getReadable(List<XmlOID> oids) {
        if (Utils.isCollectionNotEmpty(oids)) {
            ArrayList<String> result = new ArrayList<String>();
            for (XmlOID xmlOID : oids) {
                if (Utils.isStringNotEmpty((String)xmlOID.getDescription())) {
                    result.add(xmlOID.getDescription());
                    continue;
                }
                result.add(xmlOID.getValue());
            }
            return result;
        }
        return null;
    }

    private Set<String> getUniqueServiceNames(List<XmlTrustService> trustServices) {
        HashSet<String> result = new HashSet<String>();
        for (XmlTrustService xmlTrustService : trustServices) {
            result.add(this.getEnOrFirst(xmlTrustService.getServiceNames()));
        }
        return result;
    }

    private XmlSubject getSubject(CertificateWrapper certificate) {
        XmlSubject subject = new XmlSubject();
        subject.setCommonName(certificate.getCommonName());
        subject.setPseudonym(certificate.getPseudo());
        subject.setSurname(certificate.getSurname());
        subject.setGivenName(certificate.getGivenName());
        subject.setOrganizationName(certificate.getOrganizationName());
        subject.setOrganizationUnit(certificate.getOrganizationalUnit());
        subject.setEmail(certificate.getEmail());
        subject.setLocality(certificate.getLocality());
        subject.setState(certificate.getState());
        subject.setCountry(certificate.getCountryName());
        return subject;
    }

    private List<String> emptyToNull(List<String> listUrls) {
        if (Utils.isCollectionEmpty(listUrls)) {
            return null;
        }
        return listUrls;
    }

    private void addQualifications(XmlChainItem firstChainItem, CertificateWrapper certificate) {
        XmlDetails qualificationDetailsAtValidationTime;
        firstChainItem.setQualificationAtIssuance(this.detailedReport.getCertificateQualificationAtIssuance(this.certificateId));
        firstChainItem.setQualificationAtValidation(this.detailedReport.getCertificateQualificationAtValidation(this.certificateId));
        XmlDetails qualificationDetailsAtIssuanceTime = this.getCertificateQualificationDetailsAtIssuanceTime(certificate.getId());
        if (this.isNotEmpty(qualificationDetailsAtIssuanceTime)) {
            firstChainItem.setQualificationDetailsAtIssuance(qualificationDetailsAtIssuanceTime);
        }
        if (this.isNotEmpty(qualificationDetailsAtValidationTime = this.getCertificateQualificationDetailsAtValidationTime(certificate.getId()))) {
            firstChainItem.setQualificationDetailsAtValidation(qualificationDetailsAtValidationTime);
        }
        Boolean enactedMRA = null;
        List trustServices = certificate.getTrustServices();
        for (TrustServiceWrapper trustServiceWrapper : trustServices) {
            if (!trustServiceWrapper.isEnactedMRA()) continue;
            enactedMRA = true;
            break;
        }
        firstChainItem.setEnactedMRA(enactedMRA);
    }

    private XmlDetails getX509ValidationDetails(String tokenId) {
        XmlDetails validationDetails = new XmlDetails();
        validationDetails.getError().addAll(this.convert(this.detailedReport.getAdESValidationErrors(tokenId)));
        validationDetails.getWarning().addAll(this.convert(this.detailedReport.getAdESValidationWarnings(tokenId)));
        validationDetails.getInfo().addAll(this.convert(this.detailedReport.getAdESValidationInfos(tokenId)));
        return validationDetails;
    }

    private XmlDetails getCertificateQualificationDetailsAtIssuanceTime(String tokenId) {
        XmlDetails qualificationDetails = new XmlDetails();
        qualificationDetails.getError().addAll(this.convert(this.detailedReport.getCertificateQualificationErrorsAtIssuanceTime(tokenId)));
        qualificationDetails.getWarning().addAll(this.convert(this.detailedReport.getCertificateQualificationWarningsAtIssuanceTime(tokenId)));
        qualificationDetails.getInfo().addAll(this.convert(this.detailedReport.getCertificateQualificationInfosAtIssuanceTime(tokenId)));
        return qualificationDetails;
    }

    private XmlDetails getCertificateQualificationDetailsAtValidationTime(String tokenId) {
        XmlDetails qualificationDetails = new XmlDetails();
        qualificationDetails.getError().addAll(this.convert(this.detailedReport.getCertificateQualificationErrorsAtValidationTime(tokenId)));
        qualificationDetails.getWarning().addAll(this.convert(this.detailedReport.getCertificateQualificationWarningsAtValidationTime(tokenId)));
        qualificationDetails.getInfo().addAll(this.convert(this.detailedReport.getCertificateQualificationInfosAtValidationTime(tokenId)));
        return qualificationDetails;
    }

    private List<XmlMessage> convert(Collection<Message> messages) {
        return messages.stream().map(m -> {
            XmlMessage xmlMessage = new XmlMessage();
            xmlMessage.setKey(m.getKey());
            xmlMessage.setValue(m.getValue());
            return xmlMessage;
        }).collect(Collectors.toList());
    }

    private boolean isNotEmpty(XmlDetails details) {
        return Utils.isCollectionNotEmpty((Collection)details.getError()) || Utils.isCollectionNotEmpty((Collection)details.getWarning()) || Utils.isCollectionNotEmpty((Collection)details.getInfo());
    }
}

