/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache.access;

import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.DownloadCache;
import eu.europa.esig.dss.tsl.cache.ParsingCache;
import eu.europa.esig.dss.tsl.cache.ValidationCache;
import eu.europa.esig.dss.tsl.cache.access.ReadOnlyCacheAccessByKey;
import eu.europa.esig.dss.tsl.download.XmlDownloadResult;
import eu.europa.esig.dss.tsl.parsing.AbstractParsingResult;
import eu.europa.esig.dss.tsl.validation.ValidationResult;

public class CacheAccessByKey
extends ReadOnlyCacheAccessByKey {
    public CacheAccessByKey(CacheKey key, DownloadCache downloadCache, ParsingCache parsingCache, ValidationCache validationCache) {
        super(key, downloadCache, parsingCache, validationCache);
    }

    public CacheKey getCacheKey() {
        return this.key;
    }

    public boolean isUpToDate(XmlDownloadResult xmlDownloadResult) {
        return this.downloadCache.isUpToDate(this.key, xmlDownloadResult);
    }

    public void update(XmlDownloadResult result) {
        this.downloadCache.update(this.key, result);
    }

    public void downloadError(Exception e) {
        this.downloadCache.error(this.key, e);
    }

    public boolean isParsingRefreshNeeded() {
        return this.parsingCache.isRefreshNeeded(this.key);
    }

    public void update(AbstractParsingResult parsingResult) {
        this.parsingCache.update(this.key, parsingResult);
    }

    public void expireParsing() {
        this.parsingCache.expire(this.key);
    }

    public void parsingError(Exception e) {
        this.parsingCache.error(this.key, e);
    }

    public boolean isValidationRefreshNeeded() {
        return this.validationCache.isRefreshNeeded(this.key);
    }

    public void expireValidation() {
        this.validationCache.expire(this.key);
    }

    public void update(ValidationResult validationResult) {
        this.validationCache.update(this.key, validationResult);
    }

    public void validationError(Exception e) {
        this.validationCache.error(this.key, e);
    }

    public boolean isFileNeedToBeDeleted() {
        return this.downloadCache.isToBeDeleted(this.key);
    }

    public void deleteDownloadCacheIfNeeded() {
        if (this.downloadCache.isToBeDeleted(this.key)) {
            this.downloadCache.remove(this.key);
        }
    }

    public void deleteParsingCacheIfNeeded() {
        if (this.parsingCache.isToBeDeleted(this.key)) {
            this.parsingCache.remove(this.key);
        }
    }

    public void deleteValidationCacheIfNeeded() {
        if (this.validationCache.isToBeDeleted(this.key)) {
            this.validationCache.remove(this.key);
        }
    }
}

