/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Store;

public interface CMSGenerator {
    public void setSignerInfoGenerator(SignerInfoGenerator var1);

    public void setCertificates(Store<X509CertificateHolder> var1);

    public void setSigners(SignerInformationStore var1);

    public void setAttributeCertificates(Store<X509AttributeCertificateHolder> var1);

    public void setCRLs(Store<X509CRLHolder> var1);

    public void setOcspBasicStore(Store<?> var1);

    public void setOcspResponsesStore(Store<?> var1);

    public void setDigestAlgorithmIDs(Collection<AlgorithmIdentifier> var1);

    public void setToBeSignedDocument(DSSDocument var1);

    public void setEncapsulate(boolean var1);

    public CMS generate();

    public static CMSGenerator loadCMSGenerator() {
        ServiceLoader<CMSGenerator> loader = ServiceLoader.load(CMSGenerator.class);
        Iterator<CMSGenerator> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new ExceptionInInitializerError("No implementation found for CMSGenerator in the classpath, please choose between 'dss-cms-object' or 'dss-cms-stream'!");
        }
        return iterator.next();
    }
}

