/*
 * Decompiled with CFR 0.152.
 */
package eu.aylett.atunit.spring;

import eu.aylett.atunit.core.Container;
import eu.aylett.atunit.spring.Bean;
import eu.aylett.atunit.spring.Context;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringContainer
implements Container {
    @Override
    public Object createTest(Class<?> testClass, Map<Field, Object> fieldValues) throws Exception {
        GenericApplicationContext ctx = new GenericApplicationContext();
        for (Field field : fieldValues.keySet()) {
            Bean beanAnno = field.getAnnotation(Bean.class);
            AbstractBeanDefinition beandef = this.defineInstanceHolderFactoryBean(field.getType(), fieldValues.get(field));
            if (beanAnno != null && !beanAnno.value().equals("")) {
                ctx.registerBeanDefinition(beanAnno.value(), (BeanDefinition)beandef);
                continue;
            }
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beandef, (BeanDefinitionRegistry)ctx);
        }
        this.loadBeanDefinitions(testClass, (BeanDefinitionRegistry)ctx);
        this.fillInMissingFieldBeans(testClass, ctx);
        ctx.refresh();
        Object test = testClass.newInstance();
        for (Field field : testClass.getDeclaredFields()) {
            field.setAccessible(true);
            Bean beanAnno = field.getAnnotation(Bean.class);
            if (beanAnno == null) {
                if (!fieldValues.containsKey(field)) continue;
                field.set(test, fieldValues.get(field));
                continue;
            }
            if (!beanAnno.value().equals("")) {
                field.set(test, ctx.getBean(beanAnno.value()));
                continue;
            }
            String[] beanNames = ctx.getBeanNamesForType(field.getType());
            if (beanNames.length < 1) {
                throw new BeanCreationException("There are no beans defined with type " + field.getType());
            }
            if (beanNames.length > 1) {
                throw new BeanCreationException("There are " + beanNames.length + " beans defined with type " + field.getType() + "; consider wiring by name instead");
            }
            field.set(test, ctx.getBean(beanNames[0]));
        }
        return test;
    }

    protected void loadBeanDefinitions(Class<?> testClass, BeanDefinitionRegistry registry) {
        URL xmlUrl;
        XmlBeanDefinitionReader xml = new XmlBeanDefinitionReader(registry);
        String resourceName = testClass.getSimpleName() + ".xml";
        Context ctxAnno = testClass.getAnnotation(Context.class);
        if (ctxAnno != null) {
            resourceName = ctxAnno.value();
        }
        if ((xmlUrl = testClass.getResource(resourceName)) != null) {
            xml.loadBeanDefinitions((Resource)new UrlResource(xmlUrl));
        } else if (ctxAnno != null) {
            throw new ApplicationContextException("Could not find context file named " + resourceName);
        }
    }

    protected void fillInMissingFieldBeans(Class<?> testClass, GenericApplicationContext ctx) throws Exception {
        for (Field field : testClass.getDeclaredFields()) {
            String name;
            Bean beanAnno = field.getAnnotation(Bean.class);
            if (beanAnno == null || (name = beanAnno.value()).equals("") || ctx.containsBean(name)) continue;
            ctx.registerBeanDefinition(name, (BeanDefinition)this.defineAutowireBean(field.getType()));
        }
    }

    protected AbstractBeanDefinition defineAutowireBean(Class<?> type) throws Exception {
        AbstractBeanDefinition beandef = BeanDefinitionReaderUtils.createBeanDefinition(null, (String)type.getName(), (ClassLoader)type.getClassLoader());
        beandef.setAutowireCandidate(true);
        beandef.setAutowireMode(0);
        return beandef;
    }

    protected AbstractBeanDefinition defineInstanceHolderFactoryBean(Class<?> type, Object instance) throws Exception {
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addIndexedArgumentValue(0, type);
        args.addIndexedArgumentValue(1, instance);
        AbstractBeanDefinition beandef = BeanDefinitionReaderUtils.createBeanDefinition(null, (String)InstanceHolderFactoryBean.class.getName(), (ClassLoader)this.getClass().getClassLoader());
        beandef.setConstructorArgumentValues(args);
        beandef.setAutowireCandidate(true);
        return beandef;
    }

    protected static class InstanceHolderFactoryBean
    implements FactoryBean {
        final Class<?> type;
        final Object instance;

        public InstanceHolderFactoryBean(Class<?> type, Object instance) {
            this.type = type;
            this.instance = instance;
        }

        public Object getObject() throws Exception {
            return this.instance;
        }

        public Class<?> getObjectType() {
            return this.type;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

