/*
 * Decompiled with CFR 0.152.
 */
package eu.aylett.atunit.jmock;

import eu.aylett.atunit.Mock;
import eu.aylett.atunit.Stub;
import eu.aylett.atunit.core.IncompatibleAnnotationException;
import eu.aylett.atunit.core.MockFramework;
import eu.aylett.atunit.jmock.NoMockeryException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;

public class JMockFramework
implements MockFramework {
    @Override
    public Map<Field, Object> getValues(Field[] fields) throws Exception {
        HashMap<Field, Object> jmockFields = new HashMap<Field, Object>();
        Object mockery = null;
        final HashSet<Object> ignored = new HashSet<Object>();
        for (Field field : fields) {
            if (!Mockery.class.isAssignableFrom(field.getType())) continue;
            if (field.getAnnotation(Mock.class) != null) {
                throw new IncompatibleAnnotationException(Mock.class, field.getType());
            }
            mockery = Mockery.class.equals(field.getType()) ? new JUnit4Mockery() : (Mockery)field.getType().newInstance();
            jmockFields.put(field, mockery);
            break;
        }
        for (Field field : fields) {
            Class<?> fieldType;
            boolean isStub;
            boolean isMock = field.getAnnotation(Mock.class) != null;
            boolean bl = isStub = field.getAnnotation(Stub.class) != null;
            if (!isMock && !isStub) continue;
            if (isMock && mockery == null) {
                throw new NoMockeryException();
            }
            if (isStub && mockery == null) {
                mockery = new JUnit4Mockery();
            }
            if ((fieldType = field.getType()).isArray()) {
                Object[] array = (Object[])Array.newInstance(fieldType.getComponentType(), 3);
                for (int i = 0; i < array.length; ++i) {
                    array[i] = mockery.mock(fieldType.getComponentType());
                    if (!isStub) continue;
                    ignored.add(array[i]);
                }
                jmockFields.put(field, array);
                continue;
            }
            Object mock = mockery.mock(field.getType());
            if (isStub) {
                ignored.add(mock);
            }
            jmockFields.put(field, mock);
        }
        if (!ignored.isEmpty()) {
            Expectations expectations = new Expectations(){
                {
                    ignored.forEach(arg_0 -> (this).ignoring(arg_0));
                }
            };
            mockery.checking((ExpectationBuilder)expectations);
        }
        return jmockFields;
    }
}

