/*
 * Decompiled with CFR 0.152.
 */
package eu.aylett.atunit.guice;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import eu.aylett.atunit.core.Container;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class GuiceContainer
implements Container {
    @Override
    public Object createTest(Class<?> testClass, Map<Field, Object> fieldValues) throws Exception {
        FieldModule fields = new FieldModule(fieldValues);
        Injector injector = Module.class.isAssignableFrom(testClass) ? Guice.createInjector((Module[])new Module[]{fields, (Module)testClass.newInstance()}) : Guice.createInjector((Module[])new Module[]{fields});
        return injector.getInstance(testClass);
    }

    protected class FieldModule
    extends AbstractModule {
        final Map<Field, Object> fields;

        public FieldModule(Map<Field, Object> fields) {
            this.fields = fields;
        }

        protected void configure() {
            HashMultimap fieldsByType = HashMultimap.create();
            for (Field field : this.fields.keySet()) {
                fieldsByType.put((Object)field.getGenericType(), (Object)field);
            }
            for (Type type : fieldsByType.keySet()) {
                Collection fields = fieldsByType.get((Object)type);
                if (fields.size() != 1) continue;
                Field field = (Field)Iterables.getOnlyElement((Iterable)fields);
                TypeLiteral literal = TypeLiteral.get((Type)type);
                this.bind(literal).toInstance(this.fields.get(field));
            }
        }
    }
}

