/*
 * Decompiled with CFR 0.152.
 */
package eu.aylett.atunit.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import eu.aylett.atunit.Container;
import eu.aylett.atunit.ContainerClass;
import eu.aylett.atunit.Mock;
import eu.aylett.atunit.MockFrameworkClass;
import eu.aylett.atunit.Stub;
import eu.aylett.atunit.Unit;
import eu.aylett.atunit.core.IncompatibleAnnotationException;
import eu.aylett.atunit.core.MockFramework;
import eu.aylett.atunit.core.NoContainer;
import eu.aylett.atunit.core.NoMockFramework;
import eu.aylett.atunit.core.NoUnitException;
import eu.aylett.atunit.core.TooManyUnitsException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class TestClassUtils {
    public static Class<? extends MockFramework> getMockFrameworkClass(Class<?> testClass) throws IncompatibleAnnotationException {
        Class mockFrameworkClass = NoMockFramework.class;
        eu.aylett.atunit.MockFramework mockFrameworkAnno = testClass.getAnnotation(eu.aylett.atunit.MockFramework.class);
        MockFrameworkClass mockFrameworkClassAnno = testClass.getAnnotation(MockFrameworkClass.class);
        if (mockFrameworkAnno != null && mockFrameworkClassAnno != null) {
            throw new IncompatibleAnnotationException(eu.aylett.atunit.MockFramework.class, MockFrameworkClass.class);
        }
        if (mockFrameworkAnno != null) {
            return mockFrameworkAnno.value().mockClass;
        }
        if (mockFrameworkClassAnno != null) {
            mockFrameworkClass = mockFrameworkClassAnno.value();
        }
        return mockFrameworkClass;
    }

    public static Set<Field> getFields(Class<?> testClass) {
        HashSet fields = Sets.newHashSet((Object[])testClass.getDeclaredFields());
        Class<?> c = testClass;
        while ((c = c.getSuperclass()) != null) {
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isPrivate(f.getModifiers())) continue;
                fields.add(f);
            }
        }
        return ImmutableSet.copyOf((Collection)fields);
    }

    public static Field getUnitField(Set<Field> fields) throws NoUnitException, TooManyUnitsException {
        Field unitField = null;
        for (Field field : fields) {
            for (Annotation anno : field.getAnnotations()) {
                if (!Unit.class.isAssignableFrom(anno.annotationType())) continue;
                if (unitField != null) {
                    throw new TooManyUnitsException("Already had field " + unitField + " when I found field " + field);
                }
                unitField = field;
            }
        }
        if (unitField == null) {
            throw new NoUnitException();
        }
        return unitField;
    }

    public static Class<? extends eu.aylett.atunit.core.Container> getContainerClass(Class<?> testClass) throws IncompatibleAnnotationException {
        Container containerAnno = testClass.getAnnotation(Container.class);
        ContainerClass containerClassAnno = testClass.getAnnotation(ContainerClass.class);
        if (containerAnno != null && containerClassAnno != null) {
            throw new IncompatibleAnnotationException(Container.class, ContainerClass.class);
        }
        if (containerAnno != null) {
            return containerAnno.value().containerClass;
        }
        if (containerClassAnno != null) {
            return containerClassAnno.value();
        }
        return NoContainer.class;
    }

    public static Set<Field> getMockFields(Set<Field> fields) {
        return fields.stream().filter(field -> field.getAnnotation(Mock.class) != null).collect(Collectors.toSet());
    }

    public static Set<Field> getStubFields(Set<Field> fields) {
        return fields.stream().filter(field -> field.getAnnotation(Stub.class) != null).collect(Collectors.toSet());
    }
}

