/*
 * Decompiled with CFR 0.152.
 */
package eu.aylett.atunit.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.aylett.atunit.Plugins;
import eu.aylett.atunit.spi.exception.IncompatiblePluginsException;
import eu.aylett.atunit.spi.plugin.AtUnitPlugin;
import eu.aylett.atunit.spi.plugin.ContainerPlugin;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class PluginUtils {
    public static Class<? extends ContainerPlugin> getContainerPluginClass(Class<?> testClass) throws IncompatiblePluginsException {
        HashSet containers = Sets.newHashSet();
        PluginUtils.getPluginClasses(testClass).stream().filter(ContainerPlugin.class::isAssignableFrom).forEach(plugin -> containers.add(plugin));
        Class[] containersArray = new Class[]{};
        switch (containers.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Class)Iterables.getOnlyElement((Iterable)containers);
            }
        }
        throw new IncompatiblePluginsException(containers.toArray(containersArray));
    }

    public static List<Class<? extends AtUnitPlugin>> getPluginClasses(Class<?> testClass) {
        Plugins anno = testClass.getAnnotation(Plugins.class);
        if (anno != null) {
            ImmutableSet plugins = ImmutableSet.copyOf((Object[])anno.value());
            return ImmutableList.copyOf((Collection)plugins);
        }
        return ImmutableList.of();
    }
}

