/*
 * Decompiled with CFR 0.152.
 */
package eu.aylett.atunit.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import eu.aylett.atunit.core.PluginUtils;
import eu.aylett.atunit.core.TestClassUtils;
import eu.aylett.atunit.spi.exception.InvalidTestException;
import eu.aylett.atunit.spi.model.TestFixture;
import eu.aylett.atunit.spi.plugin.AtUnitPlugin;
import eu.aylett.atunit.spi.plugin.ContainerPlugin;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CoreTestFixture
implements TestFixture {
    private final Class<?> testClass;
    private final Map<Field, Object> fields;
    private final Set<Field> mockFields;
    private final Set<Field> stubFields;
    private final Field unitField;
    private final Class<? extends ContainerPlugin> containerClass;
    private final List<Class<? extends AtUnitPlugin>> pluginClasses;

    public CoreTestFixture(Class<?> testClass) throws InvalidTestException {
        this.testClass = testClass;
        this.fields = Maps.newHashMap();
        for (Field field : TestClassUtils.getFields(testClass)) {
            this.fields.put(field, null);
        }
        this.mockFields = TestClassUtils.getMockFields(this.fields.keySet());
        this.stubFields = TestClassUtils.getStubFields(this.fields.keySet());
        this.unitField = TestClassUtils.getUnitField(this.fields.keySet());
        this.containerClass = PluginUtils.getContainerPluginClass(testClass);
        this.pluginClasses = PluginUtils.getPluginClasses(testClass);
    }

    @Override
    public Object getValue(Field field) {
        return this.fields.get(field);
    }

    @Override
    public void setValue(Field field, Object value) {
        this.fields.put(field, value);
    }

    @Override
    public Set<Field> getFields() {
        return ImmutableSet.copyOf(this.fields.keySet());
    }

    @Override
    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public Set<Field> getMockFields() {
        return this.mockFields;
    }

    @Override
    public Set<Field> getStubFields() {
        return this.stubFields;
    }

    @Override
    public Field getUnitField() {
        return this.unitField;
    }

    public Class<? extends ContainerPlugin> getContainerPluginClass() {
        return this.containerClass;
    }

    public List<Class<? extends AtUnitPlugin>> getPluginClasses() {
        return this.pluginClasses;
    }
}

