/*
 * Decompiled with CFR 0.152.
 */
package eu.aylett.atunit;

import com.google.common.collect.Sets;
import eu.aylett.atunit.Container;
import eu.aylett.atunit.ContainerClass;
import eu.aylett.atunit.Mock;
import eu.aylett.atunit.MockFrameworkClass;
import eu.aylett.atunit.NoUnitException;
import eu.aylett.atunit.TooManyUnitsException;
import eu.aylett.atunit.Unit;
import eu.aylett.atunit.core.IncompatibleAnnotationException;
import eu.aylett.atunit.core.MockFramework;
import eu.aylett.atunit.core.NoContainer;
import eu.aylett.atunit.core.NoMockFramework;
import eu.aylett.atunit.easymock.EasyMockFramework;
import eu.aylett.atunit.guice.GuiceContainer;
import eu.aylett.atunit.jmock.JMockFramework;
import eu.aylett.atunit.mockito.MockitoFramework;
import eu.aylett.atunit.spring.SpringContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class AtUnit
extends BlockJUnit4ClassRunner {
    public AtUnit(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected Object createTest() throws Exception {
        Class c = this.getTestClass().getJavaClass();
        Set<Field> testFields = this.getFields(c);
        eu.aylett.atunit.core.Container container = this.getContainerFor(c);
        MockFramework mockFramework = this.getMockFrameworkFor(c);
        Field unitField = this.getUnitField(testFields);
        if (unitField.getAnnotation(Mock.class) != null) {
            throw new IncompatibleAnnotationException(Unit.class, Mock.class);
        }
        Map<Field, Object> fieldValues = mockFramework.getValues(testFields.toArray(new Field[testFields.size()]));
        if (fieldValues.containsKey(unitField)) {
            throw new IncompatibleAnnotationException(Unit.class, unitField.getType());
        }
        Object test = container.createTest(c, fieldValues);
        for (Field field : fieldValues.keySet()) {
            field.setAccessible(true);
            if (field.get(test) != null) continue;
            field.set(test, fieldValues.get(field));
        }
        return test;
    }

    protected Set<Field> getFields(Class<?> c) {
        HashSet fields = Sets.newHashSet((Object[])c.getDeclaredFields());
        while ((c = c.getSuperclass()) != null) {
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isPrivate(f.getModifiers())) continue;
                fields.add(f);
            }
        }
        return fields;
    }

    protected Field getUnitField(Set<Field> fields) throws NoUnitException, TooManyUnitsException {
        Field unitField = null;
        for (Field field : fields) {
            for (Annotation anno : field.getAnnotations()) {
                if (!Unit.class.isAssignableFrom(anno.annotationType())) continue;
                if (unitField != null) {
                    throw new TooManyUnitsException("Already had field " + unitField + " when I found field " + field);
                }
                unitField = field;
            }
        }
        if (unitField == null) {
            throw new NoUnitException();
        }
        return unitField;
    }

    protected eu.aylett.atunit.core.Container getContainerFor(Class<?> testClass) throws Exception {
        Class containerClass = NoContainer.class;
        Container containerAnno = testClass.getAnnotation(Container.class);
        ContainerClass containerClassAnno = testClass.getAnnotation(ContainerClass.class);
        if (containerAnno != null && containerClassAnno != null) {
            throw new IncompatibleAnnotationException(Container.class, ContainerClass.class);
        }
        if (containerAnno != null) {
            switch (containerAnno.value()) {
                case GUICE: {
                    containerClass = GuiceContainer.class;
                    break;
                }
                case SPRING: {
                    containerClass = SpringContainer.class;
                }
            }
        }
        if (containerClassAnno != null) {
            containerClass = containerClassAnno.value();
        }
        return (eu.aylett.atunit.core.Container)containerClass.newInstance();
    }

    protected MockFramework getMockFrameworkFor(Class<?> testClass) throws Exception {
        Class mockFrameworkClass = NoMockFramework.class;
        eu.aylett.atunit.MockFramework mockFrameworkAnno = testClass.getAnnotation(eu.aylett.atunit.MockFramework.class);
        MockFrameworkClass mockFrameworkClassAnno = testClass.getAnnotation(MockFrameworkClass.class);
        if (mockFrameworkAnno != null && mockFrameworkClassAnno != null) {
            throw new IncompatibleAnnotationException(eu.aylett.atunit.MockFramework.class, MockFrameworkClass.class);
        }
        if (mockFrameworkAnno != null) {
            switch (mockFrameworkAnno.value()) {
                case EASYMOCK: {
                    mockFrameworkClass = EasyMockFramework.class;
                    break;
                }
                case JMOCK: {
                    mockFrameworkClass = JMockFramework.class;
                    break;
                }
                case MOCKITO: {
                    mockFrameworkClass = MockitoFramework.class;
                    break;
                }
                default: {
                    throw new IllegalStateException("Expected switch block to be exhaustive: " + (Object)((Object)mockFrameworkAnno.value()));
                }
            }
        }
        if (mockFrameworkClassAnno != null) {
            mockFrameworkClass = mockFrameworkClassAnno.value();
        }
        return (MockFramework)mockFrameworkClass.newInstance();
    }
}

