/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.xmpp;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppJob;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppMain;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class MembershipFullRefreshJob
implements Job,
StatefulJob {
    private static Log log = GrouperClientUtils.retrieveLog(MembershipFullRefreshJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String jobName = null;
        try {
            jobName = context.getJobDetail().getKey().getName();
            if (log.isDebugEnabled()) {
                log.debug("Full refresh on job: " + jobName);
            }
            if (!jobName.startsWith("fullRefresh_")) {
                throw new RuntimeException("Job name should start with fullRefresh_: " + jobName);
            }
            jobName = jobName.substring("fullRefresh_".length());
            GrouperClientXmppJob grouperClientXmppJob = GrouperClientXmppJob.retrieveJob(jobName, true);
            for (String groupName : grouperClientXmppJob.getGroupNames()) {
                GrouperClientXmppMain.fullRefreshGroup(grouperClientXmppJob, groupName);
            }
        }
        catch (RuntimeException re) {
            log.error("Error in job: " + jobName, re);
            throw re;
        }
    }
}

