/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.xmpp;

import edu.internet2.middleware.grouperClient.api.GcGetMembers;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubject;
import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.Crypto;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.util.JsonUtils;
import edu.internet2.middleware.grouperClientExt.xmpp.EsbEvent;
import edu.internet2.middleware.grouperClientExt.xmpp.EsbEvents;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppHandler;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppJob;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppMessageHandler;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppSubject;
import edu.internet2.middleware.grouperClientExt.xmpp.MembershipFullRefreshJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class GrouperClientXmppMain {
    private static Log log = GrouperClientUtils.retrieveLog(GrouperClientXmppMain.class);
    private static final Set<String> SUPPORTED_EVENT_TYPES = Collections.unmodifiableSet(GrouperClientUtils.toSet("MEMBERSHIP_ADD", "MEMBERSHIP_DELETE", "GROUP_ADD", "GROUP_DELETE", "GROUP_UPDATE"));
    private static XMPPConnection xmppConnection = null;
    private static Set<String> allowFromJabberIds = null;
    private static Map<String, List<GrouperClientXmppSubject>> groupMemberships = new HashMap<String, List<GrouperClientXmppSubject>>();
    private static SchedulerFactory schedulerFactory = null;

    public static boolean matchesFilter(EsbEvent esbEvent, String filterString) {
        try {
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            variableMap.put("event", esbEvent);
            variableMap.put("grouperClientUtils", new GrouperClientUtils());
            String elResultString = GrouperClientUtils.substituteExpressionLanguage(filterString, variableMap, true, false, false, true);
            return GrouperClientUtils.booleanValue(elResultString);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem seeing if matches filter for sequence: " + (esbEvent == null ? null : esbEvent.getSequenceNumber()) + ", '" + filterString + "'", e);
        }
    }

    private static synchronized XMPPConnection xmppConnection() {
        if (xmppConnection == null || !xmppConnection.isAuthenticated() || !xmppConnection.isConnected()) {
            String user = null;
            String pass = null;
            String resource = null;
            String server = null;
            int port = -1;
            try {
                if (xmppConnection != null) {
                    try {
                        xmppConnection.disconnect();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                server = GrouperClientXmppMain.xmppServer();
                port = GrouperClientXmppMain.xmppPort();
                ConnectionConfiguration config = new ConnectionConfiguration(server, port);
                boolean debuggerEnabled = GrouperClientConfig.retrieveConfig().propertyValueBoolean("grouperClient.xmpp.debuggerEnabled", false);
                config.setDebuggerEnabled(debuggerEnabled);
                config.setReconnectionAllowed(true);
                config.setSASLAuthenticationEnabled(true);
                SASLAuthentication.supportSASLMechanism((String)"PLAIN");
                config.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
                xmppConnection = new XMPPConnection(config);
                xmppConnection.connect();
                user = GrouperClientXmppMain.xmppUser();
                pass = GrouperClientXmppMain.xmppPass();
                resource = GrouperClientXmppMain.xmppResource();
                xmppConnection.login(user, pass, resource);
            }
            catch (XMPPException xe) {
                throw new RuntimeException("Problem connecting: server: " + server + ", port: " + port + ", user: " + user + ", pass not included, " + ", resource: " + resource, xe);
            }
        }
        return xmppConnection;
    }

    public static String xmppPass() {
        boolean disableExternalFileLookup = GrouperClientConfig.retrieveConfig().propertyValueBooleanRequired("encrypt.disableExternalFileLookup");
        String pass = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.xmpp.pass");
        String passFromFile = GrouperClientUtils.readFromFileIfFile(pass, disableExternalFileLookup);
        if (GrouperClientConfig.retrieveConfig().propertyValueBoolean("encrypt.encryptLikeServer", false)) {
            if (!GrouperClientUtils.equals(pass, passFromFile)) {
                String encryptKey = GrouperClientUtils.encryptKey();
                pass = new Crypto(encryptKey).decrypt(passFromFile);
            }
            return pass;
        }
        if (!GrouperClientUtils.equals(pass, passFromFile)) {
            String encryptKey = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("encrypt.key");
            encryptKey = GrouperClientUtils.readFromFileIfFile(encryptKey, disableExternalFileLookup);
            passFromFile = new Crypto(encryptKey).decrypt(passFromFile);
        }
        return passFromFile;
    }

    public static int xmppPort() {
        return GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.xmpp.server.port", 1522);
    }

    public static String xmppResource() {
        return GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.xmpp.resource");
    }

    public static String xmppServer() {
        return GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.xmpp.server.host");
    }

    public static String xmppUser() {
        return GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.xmpp.user");
    }

    public static void xmppConnect(final GrouperClientXmppMessageHandler grouperClientXmppMessageHandler) {
        XMPPConnection theXmppConnection = GrouperClientXmppMain.xmppConnection();
        theXmppConnection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Message message = null;
                try {
                    message = (Message)packet;
                    if (log.isDebugEnabled()) {
                        log.debug(message == null ? null : message.toXML());
                    }
                    grouperClientXmppMessageHandler.handleMessage(message);
                }
                catch (Throwable re) {
                    String messageXml = message == null ? null : message.toXML();
                    log.error("Problem with message: " + messageXml, re);
                    throw new RuntimeException(re);
                }
            }
        }, new PacketFilter(){

            public boolean accept(Packet packet) {
                Message message;
                Message.Type type;
                if (packet instanceof Message && (type = (message = (Message)packet).getType()) == Message.Type.chat && !GrouperClientUtils.isBlank(message.getBody())) {
                    if (GrouperClientXmppMain.allowFromJabberIds().contains(message.getFrom())) {
                        return true;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Not expecting message from: " + message.getFrom());
                    }
                }
                return false;
            }
        });
    }

    private static void xmppLoopForGroups() {
        GrouperClientXmppMain.xmppLoop(new GrouperClientXmppMessageHandler(){

            @Override
            public void handleMessage(Message message) {
                String body = message.getBody();
                EsbEvents esbEvents = (EsbEvents)JsonUtils.jsonConvertFrom(body, EsbEvents.class);
                for (EsbEvent esbEvent : GrouperClientUtils.nonNull(esbEvents.getEsbEvent(), EsbEvent.class)) {
                    for (GrouperClientXmppJob grouperClientXmppJob : GrouperClientXmppJob.retrieveXmppJobs()) {
                        String elfilter = grouperClientXmppJob.getElfilter();
                        Boolean matches = null;
                        String groupName = esbEvent.getGroupName();
                        if (GrouperClientUtils.isBlank(groupName) && ("GROUP_ADD".equals(esbEvent.getEventType()) || "GROUP_DELETE".equals(esbEvent.getEventType()) || "GROUP_UPDATE".equals(esbEvent.getEventType()))) {
                            groupName = esbEvent.getName();
                        }
                        if (!GrouperClientUtils.isBlank(elfilter)) {
                            if (!GrouperClientXmppMain.matchesFilter(esbEvent, elfilter)) {
                                matches = false;
                                if (log.isDebugEnabled()) {
                                    log.debug("skipping event to not match filter, sequence: " + (esbEvent == null ? null : esbEvent.getSequenceNumber()) + ", '" + elfilter + "', " + grouperClientXmppJob.getJobName());
                                }
                            } else {
                                matches = true;
                            }
                        }
                        if (GrouperClientXmppJob.XmppJobEventAction.incremental == grouperClientXmppJob.getEventAction() && grouperClientXmppJob.isAllowIncrementalNotInGroupNamesList()) {
                            if (log.isDebugEnabled()) {
                                log.debug("including since incremental and allowIncrementalNotInGroupNamesList is true: " + grouperClientXmppJob.getJobName());
                            }
                            matches = true;
                        } else if (GrouperClientUtils.nonNull(grouperClientXmppJob.getGroupNames()).size() > 0) {
                            if (grouperClientXmppJob.getGroupNames().contains(groupName)) {
                                if (matches == null) {
                                    matches = true;
                                }
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug("skipping event to not match group name list, sequence: " + (esbEvent == null ? null : esbEvent.getSequenceNumber()) + ", " + grouperClientXmppJob.getJobName());
                                }
                                matches = false;
                            }
                        }
                        if (matches != null && !matches.booleanValue()) continue;
                        if (GrouperClientXmppJob.XmppJobEventAction.reload_group == grouperClientXmppJob.getEventAction()) {
                            if (log.isDebugEnabled()) {
                                log.debug("performing a full reload on group: " + groupName + " for job: " + grouperClientXmppJob.getJobName() + ", subject: " + esbEvent.getSubjectId());
                            }
                            GrouperClientXmppMain.fullRefreshGroup(grouperClientXmppJob, groupName);
                            continue;
                        }
                        if (GrouperClientXmppJob.XmppJobEventAction.incremental == grouperClientXmppJob.getEventAction()) {
                            if (log.isDebugEnabled()) {
                                log.debug("performing an incremental reload on group: " + groupName + " for job: " + grouperClientXmppJob.getJobName() + ", subject: " + esbEvent.getSubjectId());
                            }
                            GrouperClientXmppSubject grouperClientXmppSubject = new GrouperClientXmppSubject(esbEvent);
                            GrouperClientXmppMain.incrementalRefreshGroup(grouperClientXmppJob, groupName, grouperClientXmppSubject, esbEvent.getEventType());
                            continue;
                        }
                        throw new RuntimeException("Not expecting event action: " + (Object)((Object)grouperClientXmppJob.getEventAction()));
                    }
                }
            }
        });
    }

    public static Set<String> allowFromJabberIds() {
        if (allowFromJabberIds == null) {
            HashSet<String> temp = new HashSet<String>();
            String allowFroms = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.xmpp.trustedMessagesFromJabberIds");
            temp.addAll(GrouperClientUtils.splitTrimToList(allowFroms, ","));
            allowFromJabberIds = temp;
        }
        return allowFromJabberIds;
    }

    public static void main(String[] args) {
        GrouperClientXmppMain.fullRefreshAll();
        GrouperClientXmppMain.scheduleFullRefreshJobs();
        GrouperClientXmppMain.xmppLoopForGroups();
    }

    public static void fullRefreshGroup(GrouperClientXmppJob grouperClientXmppJob, String groupName) {
        GcGetMembers gcGetMembers = new GcGetMembers();
        List<String> subjectAttributeNames = grouperClientXmppJob.getSubjectAttributeNames();
        if (GrouperClientUtils.length(subjectAttributeNames) > 0) {
            for (String subjectAttributeName : subjectAttributeNames) {
                gcGetMembers.addSubjectAttributeName(subjectAttributeName);
            }
        }
        WsGetMembersResults wsGetMembersResults = gcGetMembers.addGroupName(groupName).execute();
        WsGetMembersResult wsGetMembersResult = wsGetMembersResults.getResults()[0];
        ArrayList<GrouperClientXmppSubject> xmppSubjects = new ArrayList<GrouperClientXmppSubject>();
        for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsGetMembersResult.getWsSubjects(), WsSubject.class)) {
            GrouperClientXmppSubject xmppSubject = new GrouperClientXmppSubject(wsSubject, wsGetMembersResults.getSubjectAttributeNames());
            xmppSubjects.add(xmppSubject);
        }
        if (log.isDebugEnabled()) {
            log.debug("Refreshing all for " + groupName + " found " + GrouperClientUtils.length(xmppSubjects) + " subjects");
        }
        Class handlerClass = GrouperClientUtils.forName(grouperClientXmppJob.getHandlerClass());
        GrouperClientXmppHandler grouperClientXmppHandler = (GrouperClientXmppHandler)GrouperClientUtils.newInstance(handlerClass);
        groupMemberships.put(groupName, xmppSubjects);
        grouperClientXmppHandler.handleAll(grouperClientXmppJob, groupName, GrouperClientUtils.extensionFromName(groupName), xmppSubjects);
    }

    private static void fullRefreshAll() {
        for (GrouperClientXmppJob grouperClientXmppJob : GrouperClientXmppJob.retrieveXmppJobs()) {
            for (String groupName : GrouperClientUtils.nonNull(grouperClientXmppJob.getGroupNames())) {
                GrouperClientXmppMain.fullRefreshGroup(grouperClientXmppJob, groupName);
            }
        }
    }

    private static void pocEl() {
        String outputTemplate = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.xmpp.job.myJobName.fileHandler.iteratorEl");
        outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        GrouperClientXmppSubject xmppSubject = new GrouperClientXmppSubject();
        xmppSubject.getAttribute().put("loginid", "mchyzer");
        substituteMap.put("subject", xmppSubject);
        String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
        System.out.println(output);
    }

    public static void xmppLoop(GrouperClientXmppMessageHandler grouperClientXmppMessageHandler) {
        if (xmppConnection != null) {
            return;
        }
        while (true) {
            block7: {
                try {
                    if (xmppConnection != null && xmppConnection.isConnected() && xmppConnection.isAuthenticated()) break block7;
                    if (xmppConnection != null) {
                        log.error("xmpp connection is not connected");
                        try {
                            xmppConnection.disconnect();
                        }
                        catch (Exception e) {
                            log.error("error", e);
                        }
                        xmppConnection = null;
                    }
                    GrouperClientXmppMain.xmppConnect(grouperClientXmppMessageHandler);
                }
                catch (Exception e) {
                    log.error("Problem with xmpp", e);
                }
            }
            GrouperClientUtils.sleep(60000L);
        }
    }

    public static void scheduleJob(String jobName, String quartzCronString, Class<? extends Job> jobClass) {
        if (GrouperClientUtils.isBlank(quartzCronString)) {
            return;
        }
        String jobGroup = "DEFAULT";
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroup).storeDurably(true).build();
        Scheduler scheduler = GrouperClientXmppMain.scheduler();
        boolean uniqueTriggerNames = GrouperClientConfig.retrieveConfig().propertyValueBoolean("grouperClient.xmpp.uniqueQuartzTriggerNames", false);
        String triggerName = "trigger_" + jobName;
        if (uniqueTriggerNames) {
            triggerName = triggerName + GrouperClientUtils.uniqueId();
        }
        CronTrigger cronTrigger = null;
        if (!uniqueTriggerNames) {
            try {
                cronTrigger = (CronTrigger)scheduler.getTrigger(new TriggerKey(triggerName, jobGroup));
            }
            catch (SchedulerException se) {
                throw new RuntimeException("Problem with trigger: " + jobName, se);
            }
        }
        if (cronTrigger == null) {
            try {
                cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)quartzCronString)).build();
            }
            catch (RuntimeException pe) {
                throw new RuntimeException("Problems parsing: '" + quartzCronString + "'", pe);
            }
        }
        try {
            scheduler.scheduleJob(jobDetail, cronTrigger);
        }
        catch (SchedulerException se) {
            throw new RuntimeException("Problem with job: " + jobName, se);
        }
    }

    private static void scheduleFullRefreshJobs() {
        for (GrouperClientXmppJob grouperClientXmppJob : GrouperClientXmppJob.retrieveXmppJobs()) {
            String jobName = "fullRefresh_" + grouperClientXmppJob.getJobName();
            GrouperClientXmppMain.scheduleJob(jobName, grouperClientXmppJob.getFullRefreshQuartzCronString(), MembershipFullRefreshJob.class);
        }
    }

    public static Scheduler scheduler() {
        try {
            return GrouperClientXmppMain.schedulerFactory().getScheduler();
        }
        catch (SchedulerException se) {
            throw new RuntimeException(se);
        }
    }

    public static SchedulerFactory schedulerFactory() {
        if (schedulerFactory == null) {
            schedulerFactory = new StdSchedulerFactory();
            try {
                schedulerFactory.getScheduler().start();
            }
            catch (SchedulerException se) {
                throw new RuntimeException(se);
            }
        }
        return schedulerFactory;
    }

    private static void incrementalRefreshGroup(GrouperClientXmppJob grouperClientXmppJob, String groupName, GrouperClientXmppSubject grouperClientXmppSubject, String eventType) {
        List<GrouperClientXmppSubject> toRemove;
        boolean changed;
        if (!SUPPORTED_EVENT_TYPES.contains(eventType)) {
            throw new RuntimeException("Not expecting action: '" + eventType + "'");
        }
        List<GrouperClientXmppSubject> oldList = Collections.EMPTY_LIST;
        if (eventType.equals("MEMBERSHIP_ADD") || eventType.equals("MEMBERSHIP_DELETE")) {
            oldList = groupMemberships.get(groupName);
            if (oldList == null) {
                GrouperClientXmppMain.fullRefreshGroup(grouperClientXmppJob, groupName);
                oldList = groupMemberships.get(groupName);
            }
            if (oldList == null) {
                throw new NullPointerException("Why is old list null????");
            }
        }
        ArrayList<GrouperClientXmppSubject> newList = new ArrayList<GrouperClientXmppSubject>(oldList);
        if (GrouperClientUtils.equals(eventType, "MEMBERSHIP_ADD")) {
            boolean changed2 = newList.add(grouperClientXmppSubject);
            if (changed2 && log.isDebugEnabled()) {
                log.debug("Group " + groupName + " already contains subject: " + grouperClientXmppSubject.getSubjectId());
            }
        } else if (GrouperClientUtils.equals(eventType, "MEMBERSHIP_DELETE") && !(changed = newList.removeAll(toRemove = GrouperClientUtils.toList(grouperClientXmppSubject))) && log.isDebugEnabled()) {
            log.debug("Group " + groupName + " already doesnt contain subject: " + grouperClientXmppSubject.getSubjectId());
        }
        groupMemberships.put(groupName, newList);
        if (log.isDebugEnabled()) {
            log.debug("Event: " + eventType + " for " + groupName + ", memberships list was " + GrouperClientUtils.length(oldList) + " and is now " + GrouperClientUtils.length(newList) + " subjects");
        }
        Class handlerClass = GrouperClientUtils.forName(grouperClientXmppJob.getHandlerClass());
        GrouperClientXmppHandler grouperClientXmppHandler = (GrouperClientXmppHandler)GrouperClientUtils.newInstance(handlerClass);
        grouperClientXmppHandler.handleIncremental(grouperClientXmppJob, groupName, GrouperClientUtils.extensionFromName(groupName), newList, oldList, grouperClientXmppSubject, eventType);
    }
}

