/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.xmpp;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppHandler;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppJob;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppSubject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class GrouperClientXmppFileHandler
implements GrouperClientXmppHandler {
    @Override
    public void handleAll(GrouperClientXmppJob grouperClientXmppJob, String groupName, String groupExtension, List<GrouperClientXmppSubject> newSubjectList) {
        this.handleList(grouperClientXmppJob, newSubjectList);
    }

    private void handleList(GrouperClientXmppJob grouperClientXmppJob, List<GrouperClientXmppSubject> subjects) {
        String pre = "";
        if (!GrouperClientUtils.isBlank(grouperClientXmppJob.getFilePrefix())) {
            pre = GrouperClientUtils.readFileIntoString(new File(grouperClientXmppJob.getFilePrefix()));
        }
        String post = "";
        if (!GrouperClientUtils.isBlank(grouperClientXmppJob.getFileSuffix())) {
            post = GrouperClientUtils.readFileIntoString(new File(grouperClientXmppJob.getFileSuffix()));
        }
        StringBuilder result = new StringBuilder(pre);
        ArrayList<String> resultList = new ArrayList<String>();
        for (GrouperClientXmppSubject xmppSubject : GrouperClientUtils.nonNull(subjects)) {
            String outputTemplate = grouperClientXmppJob.getIteratorEl();
            outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
            LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
            substituteMap.put("grouperClientUtils", new GrouperClientUtils());
            substituteMap.put("subject", xmppSubject);
            String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
            resultList.add(output);
        }
        Collections.sort(resultList);
        for (String resultItem : resultList) {
            result.append(resultItem);
        }
        result.append(post);
        GrouperClientUtils.saveStringIntoFile(new File(grouperClientXmppJob.getTargetFile()), result.toString());
    }

    @Override
    public void handleIncremental(GrouperClientXmppJob grouperClientXmppJob, String groupName, String groupExtension, List<GrouperClientXmppSubject> newSubjectList, List<GrouperClientXmppSubject> previousSubjectList, GrouperClientXmppSubject changeSubject, String action) {
        this.handleList(grouperClientXmppJob, newSubjectList);
    }
}

