/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString;

import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.MorphPropertyFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class MorphStringUtils {
    public static final String EMPTY = "";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    static final String WRAPPED_MARKER = " [wrapped] ";
    private static String[] CAUSE_METHOD_NAMES;
    public static final String TEMP_DIR_NAME = "fastTemp";
    public static final String CONFIG_CACHE_DIR_NAME = "fastConfigCache";
    private static final Method THROWABLE_CAUSE_METHOD;
    private static final String[] SPECIAL_CHARS_FROM;
    private static final String[] SPECIAL_CHARS_TO;

    public static String encodeForUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static void initFile(File file) {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new RuntimeException("Cannot create parent dirs: " + parentFile.getAbsolutePath());
            }
            if (!parentFile.isDirectory()) {
                throw new RuntimeException("Parent file is not a directory! " + parentFile.getAbsolutePath());
            }
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void addCauseMethodName(String methodName) {
        ArrayList list;
        if (MorphStringUtils.isNotEmpty(methodName) && !MorphStringUtils.isCauseMethodName(methodName) && (list = MorphStringUtils.getCauseMethodNameList()).add(methodName)) {
            CAUSE_METHOD_NAMES = MorphStringUtils.toArray(list);
        }
    }

    public static void removeCauseMethodName(String methodName) {
        ArrayList list;
        if (MorphStringUtils.isNotEmpty(methodName) && (list = MorphStringUtils.getCauseMethodNameList()).remove(methodName)) {
            CAUSE_METHOD_NAMES = MorphStringUtils.toArray(list);
        }
    }

    private static String[] toArray(List list) {
        return list.toArray(new String[list.size()]);
    }

    private static ArrayList getCauseMethodNameList() {
        return new ArrayList<String>(Arrays.asList(CAUSE_METHOD_NAMES));
    }

    public static boolean isCauseMethodName(String methodName) {
        return MorphStringUtils.indexOf(CAUSE_METHOD_NAMES, methodName) >= 0;
    }

    public static Throwable getCause(Throwable throwable) {
        return MorphStringUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static String className(Object object) {
        return object == null ? null : object.getClass().getName();
    }

    public static Object executeMethod(Object object, String methodName) {
        try {
            Class<?> theClass = object.getClass();
            Method method = theClass.getDeclaredMethod(methodName, null);
            return method.invoke(object, (Object[])null);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem calling class method: " + MorphStringUtils.className(object) + "." + methodName, e);
        }
    }

    public static Object executeMethod(Object object, String methodName, Class argumentType, Object argument) {
        try {
            Class<?> theClass = object.getClass();
            Method method = theClass.getDeclaredMethod(methodName, argumentType);
            return method.invoke(object, argument);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem calling class method: " + MorphStringUtils.className(object) + "." + methodName, e);
        }
    }

    public static Throwable getCause(Throwable throwable, String[] methodNames) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = MorphStringUtils.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            String methodName;
            if (methodNames == null) {
                methodNames = CAUSE_METHOD_NAMES;
            }
            for (int i = 0; i < methodNames.length && ((methodName = methodNames[i]) == null || (cause = MorphStringUtils.getCauseUsingMethodName(throwable, methodName)) == null); ++i) {
            }
            if (cause == null) {
                cause = MorphStringUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause = MorphStringUtils.getCause(throwable);
        if (cause != null) {
            throwable = cause;
            while ((throwable = MorphStringUtils.getCause(throwable)) != null) {
                cause = throwable;
            }
        }
        return cause;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        if (MorphStringUtils.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        int isize = CAUSE_METHOD_NAMES.length;
        for (int i = 0; i < isize; ++i) {
            try {
                Method method = cls.getMethod(CAUSE_METHOD_NAMES[i], null);
                if (method == null || !Throwable.class.isAssignableFrom(method.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException ignored) {
                continue;
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        try {
            Field field = cls.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static int getThrowableCount(Throwable throwable) {
        int count = 0;
        while (throwable != null) {
            ++count;
            throwable = MorphStringUtils.getCause(throwable);
        }
        return count;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null) {
            list.add(throwable);
            throwable = MorphStringUtils.getCause(throwable);
        }
        return list.toArray(new Throwable[list.size()]);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz) {
        return MorphStringUtils.indexOf(throwable, clazz, 0, false);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz, int fromIndex) {
        return MorphStringUtils.indexOf(throwable, clazz, fromIndex, false);
    }

    public static int indexOfType(Throwable throwable, Class type) {
        return MorphStringUtils.indexOf(throwable, type, 0, true);
    }

    public static int indexOfType(Throwable throwable, Class type, int fromIndex) {
        return MorphStringUtils.indexOf(throwable, type, fromIndex, true);
    }

    private static int indexOf(Throwable throwable, Class type, int fromIndex, boolean subclass) {
        Throwable[] throwables;
        if (throwable == null || type == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = MorphStringUtils.getThrowables(throwable)).length) {
            return -1;
        }
        if (subclass) {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.isAssignableFrom(throwables[i].getClass())) continue;
                return i;
            }
        } else {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.equals(throwables[i].getClass())) continue;
                return i;
            }
        }
        return -1;
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        MorphStringUtils.printRootCauseStackTrace(throwable, System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintStream stream) {
        if (throwable == null) {
            return;
        }
        if (stream == null) {
            throw new IllegalArgumentException("The PrintStream must not be null");
        }
        String[] trace = MorphStringUtils.getRootCauseStackTrace(throwable);
        for (int i = 0; i < trace.length; ++i) {
            stream.println(trace[i]);
        }
        stream.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintWriter writer) {
        if (throwable == null) {
            return;
        }
        if (writer == null) {
            throw new IllegalArgumentException("The PrintWriter must not be null");
        }
        String[] trace = MorphStringUtils.getRootCauseStackTrace(throwable);
        for (int i = 0; i < trace.length; ++i) {
            writer.println(trace[i]);
        }
        writer.flush();
    }

    public static String[] split(String str) {
        return MorphStringUtils.split(str, null, -1);
    }

    public static String[] split(String str, char separatorChar) {
        return MorphStringUtils.splitWorker(str, separatorChar, false);
    }

    public static String[] split(String str, String separatorChars) {
        return MorphStringUtils.splitWorker(str, separatorChars, -1, false);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String str, String separatorChars, int max) {
        return MorphStringUtils.splitWorker(str, separatorChars, max, false);
    }

    public static String[] splitByWholeSeparator(String str, String separator) {
        return MorphStringUtils.splitByWholeSeparator(str, separator, -1);
    }

    public static String[] splitByWholeSeparator(String str, String separator, int max) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        if (separator == null || EMPTY.equals(separator)) {
            return MorphStringUtils.split(str, null, max);
        }
        int separatorLength = separator.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(separator, beg);
            if (end > -1) {
                if (end > beg) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                        continue;
                    }
                    substrings.add(str.substring(beg, end));
                    beg = end + separatorLength;
                    continue;
                }
                beg = end + separatorLength;
                continue;
            }
            substrings.add(str.substring(beg));
            end = len;
        }
        return substrings.toArray(new String[substrings.size()]);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitTrim(String input, String separator) {
        if (input == null) {
            return null;
        }
        String[] items = MorphStringUtils.split(input, separator);
        for (int i = 0; items != null && i < items.length; ++i) {
            items[i] = MorphStringUtils.trim(items[i]);
        }
        return items;
    }

    public static String[] getRootCauseStackTrace(Throwable throwable) {
        if (throwable == null) {
            return new String[0];
        }
        Throwable[] throwables = MorphStringUtils.getThrowables(throwable);
        int count = throwables.length;
        ArrayList<String> frames = new ArrayList<String>();
        List nextTrace = MorphStringUtils.getStackFrameList(throwables[count - 1]);
        int i = count;
        while (--i >= 0) {
            List trace = nextTrace;
            if (i != 0) {
                nextTrace = MorphStringUtils.getStackFrameList(throwables[i - 1]);
                MorphStringUtils.removeCommonFrames(trace, nextTrace);
            }
            if (i == count - 1) {
                frames.add(throwables[i].toString());
            } else {
                frames.add(WRAPPED_MARKER + throwables[i].toString());
            }
            for (int j = 0; j < trace.size(); ++j) {
                frames.add((String)trace.get(j));
            }
        }
        return frames.toArray(new String[0]);
    }

    public static void removeCommonFrames(List causeFrames, List wrapperFrames) {
        if (causeFrames == null || wrapperFrames == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int causeFrameIndex = causeFrames.size() - 1;
        for (int wrapperFrameIndex = wrapperFrames.size() - 1; causeFrameIndex >= 0 && wrapperFrameIndex >= 0; --causeFrameIndex, --wrapperFrameIndex) {
            String wrapperFrame;
            String causeFrame = (String)causeFrames.get(causeFrameIndex);
            if (!causeFrame.equals(wrapperFrame = (String)wrapperFrames.get(wrapperFrameIndex))) continue;
            causeFrames.remove(causeFrameIndex);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Throwable[] ts = MorphStringUtils.getThrowables(throwable);
        for (int i = 0; i < ts.length; ++i) {
            ts[i].printStackTrace(pw);
            if (MorphStringUtils.isNestedThrowable(ts[i])) break;
        }
        return sw.getBuffer().toString();
    }

    public static String[] getStackFrames(Throwable throwable) {
        if (throwable == null) {
            return new String[0];
        }
        return MorphStringUtils.getStackFrames(MorphStringUtils.getStackTrace(throwable));
    }

    public static String[] getStackFrames(String stackTrace) {
        String linebreak = MorphStringUtils.getSystemProperty("line.separator");
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        LinkedList<String> list = new LinkedList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return MorphStringUtils.toArray(list);
    }

    public static List getStackFrameList(Throwable t) {
        String stackTrace = MorphStringUtils.getStackTrace(t);
        String linebreak = MorphStringUtils.getSystemProperty("line.separator");
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        LinkedList<String> list = new LinkedList<String>();
        boolean traceStarted = false;
        while (frames.hasMoreTokens()) {
            String token = frames.nextToken();
            int at = token.indexOf("at");
            if (at != -1 && token.substring(0, at).trim().length() == 0) {
                traceStarted = true;
                list.add(token);
                continue;
            }
            if (!traceStarted) continue;
            break;
        }
        return list;
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return MorphStringUtils.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String replace(String text, String repl, String with) {
        return MorphStringUtils.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || MorphStringUtils.isEmpty(repl) || with == null || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String readFileIntoString(File file) {
        if (file == null) {
            return null;
        }
        try {
            return MorphStringUtils.readFileToString(file, "ISO-8859-1");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String encoding) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            String string = MorphStringUtils.toString(in, encoding);
            return string;
        }
        finally {
            MorphStringUtils.closeQuietly(in);
        }
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        MorphStringUtils.copy(input, sw, encoding);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        MorphStringUtils.copy(in, output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static void closeQuietly(Reader input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = MorphStringUtils.trim(str);
        return MorphStringUtils.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static boolean hasWhitespace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }

    public static Object next(Object arrayOrCollection, Iterator iterator, int index) {
        if (arrayOrCollection.getClass().isArray()) {
            return Array.get(arrayOrCollection, index);
        }
        if (arrayOrCollection instanceof ArrayList) {
            return ((ArrayList)arrayOrCollection).get(index);
        }
        if (arrayOrCollection instanceof Collection) {
            return iterator.next();
        }
        if (0 == index) {
            return arrayOrCollection;
        }
        throw new RuntimeException("Invalid class type: " + arrayOrCollection.getClass().getName());
    }

    public static Iterator iterator(Object collection) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof Collection && !(collection instanceof ArrayList)) {
            return ((Collection)collection).iterator();
        }
        return null;
    }

    public static int length(Object arrayOrCollection) {
        if (arrayOrCollection == null) {
            return 0;
        }
        if (arrayOrCollection.getClass().isArray()) {
            return Array.getLength(arrayOrCollection);
        }
        if (arrayOrCollection instanceof Collection) {
            return ((Collection)arrayOrCollection).size();
        }
        if (arrayOrCollection instanceof Map) {
            return ((Map)arrayOrCollection).size();
        }
        return 1;
    }

    public static long lastModifiedResources(Object resourceNames) {
        long lastModified = 0L;
        if (resourceNames == null) {
            throw new NullPointerException();
        }
        Iterator resourceIterator = MorphStringUtils.iterator(resourceNames);
        int resourceLength = MorphStringUtils.length(resourceNames);
        String current = null;
        for (int i = 0; i < resourceLength; ++i) {
            current = (String)MorphStringUtils.next(resourceNames, resourceIterator, i);
            File configFile = MorphStringUtils.fileFromResourceNameHelper(current, null, false, false);
            if (configFile.getAbsolutePath().indexOf(33) != -1) {
                return 0L;
            }
            if (!configFile.exists() || !configFile.isFile()) {
                String error = "Cannot find resource file: " + (configFile == null ? "null" : configFile.getPath());
                throw new RuntimeException(error);
            }
            lastModified = Math.max(lastModified, configFile.lastModified());
        }
        return lastModified;
    }

    public static File fileFromResourceNameHelper(String resourceName, StringBuffer log, boolean isDebug, boolean isInfo) {
        isDebug = isDebug && log != null;
        isInfo = isInfo && log != null;
        URL url = MorphStringUtils.computeUrl(resourceName, true);
        if (url == null) {
            if (isInfo) {
                log.append(", Could not find the URL of resource when converting to file: " + resourceName);
            }
            return null;
        }
        if (isDebug) {
            log.append(", URL from FileUtils.url() is: " + url);
        }
        String fileName = null;
        File configFile = null;
        try {
            fileName = URLDecoder.decode(url.getFile(), "UTF-8");
            configFile = new File(fileName);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        if (configFile == null) {
            if (isInfo) {
                log.append(", Could not find the File of URL when converting to file: " + resourceName + ", " + url);
            }
            return null;
        }
        return configFile;
    }

    public static ClassLoader fastClassLoader() {
        return MorphStringUtils.class.getClassLoader();
    }

    public static URL computeUrl(String resourceName, boolean canBeNull) {
        ClassLoader cl = MorphStringUtils.fastClassLoader();
        URL url = null;
        try {
            url = cl.getResource(resourceName);
        }
        catch (NullPointerException npe) {
            String error = "getUrl() Could not find resource file: " + resourceName;
            throw new RuntimeException(error, npe);
        }
        if (!canBeNull && url == null) {
            throw new RuntimeException("Cant find resource: " + resourceName);
        }
        return url;
    }

    public static Object get(Object arrayOrCollection, int index) {
        if (arrayOrCollection == null) {
            if (index == 0) {
                return null;
            }
            throw new RuntimeException("Trying to access index " + index + " of null");
        }
        if (arrayOrCollection instanceof ArrayList) {
            return ((ArrayList)arrayOrCollection).get(index);
        }
        if (arrayOrCollection instanceof Collection) {
            Iterator iterator = MorphStringUtils.iterator(arrayOrCollection);
            for (int i = 0; i < index; ++i) {
                MorphStringUtils.next(arrayOrCollection, iterator, i);
            }
            return MorphStringUtils.next(arrayOrCollection, iterator, index);
        }
        if (arrayOrCollection.getClass().isArray()) {
            return Array.get(arrayOrCollection, index);
        }
        if (index == 0) {
            return arrayOrCollection;
        }
        throw new RuntimeException("Trying to access index " + index + " of and object: " + arrayOrCollection);
    }

    private static long findNextIndexHelper(int searchForLength, Object searchFor, Object replaceWith, Iterator iteratorSearchFor, Iterator iteratorReplaceWith, boolean[] noMoreMatchesForReplIndex, String input, int start) {
        int inputIndex = -1;
        int replaceIndex = -1;
        String currentSearchFor = null;
        String currentReplaceWith = null;
        int tempIndex = -1;
        for (int i = 0; i < searchForLength; ++i) {
            currentSearchFor = (String)MorphStringUtils.next(searchFor, iteratorSearchFor, i);
            currentReplaceWith = (String)MorphStringUtils.next(replaceWith, iteratorReplaceWith, i);
            if (noMoreMatchesForReplIndex[i] || MorphStringUtils.isEmpty(currentSearchFor) || currentReplaceWith == null) continue;
            tempIndex = input.indexOf(currentSearchFor, start);
            boolean bl = noMoreMatchesForReplIndex[i] = tempIndex == -1;
            if (tempIndex == -1 || inputIndex != -1 && tempIndex >= inputIndex) continue;
            inputIndex = tempIndex;
            replaceIndex = i;
        }
        long resultPacked = MorphStringUtils.packInts(inputIndex, replaceIndex);
        return resultPacked;
    }

    public static long packInts(int first, int second) {
        long result = first;
        result <<= 32;
        return result |= (long)second;
    }

    public static void replace(StringBuffer outBuffer, String text, Object searchFor, Object replaceWith, boolean recurse) {
        MorphStringUtils.replace(outBuffer, null, text, searchFor, replaceWith, recurse, recurse ? MorphStringUtils.length(searchFor) : 0);
    }

    public static void replace(StringBuffer outBuffer, String text, Object searchFor, Object replaceWith) {
        MorphStringUtils.replace(outBuffer, null, text, searchFor, replaceWith, false, 0);
    }

    public static void replace(Writer outWriter, String text, Object searchFor, Object replaceWith, boolean recurse) {
        MorphStringUtils.replace(null, outWriter, text, searchFor, replaceWith, recurse, recurse ? MorphStringUtils.length(searchFor) : 0);
    }

    public static void replace(Writer outWriter, String text, Object searchFor, Object replaceWith) {
        MorphStringUtils.replace(null, outWriter, text, searchFor, replaceWith, false, 0);
    }

    public static String replace(String text, Object searchFor, Object replaceWith, boolean recurse) {
        return MorphStringUtils.replace(null, null, text, searchFor, replaceWith, recurse, recurse ? MorphStringUtils.length(searchFor) : 0);
    }

    public static String replace(String text, Object searchFor, Object replaceWith) {
        return MorphStringUtils.replace(null, null, text, searchFor, replaceWith, false, 0);
    }

    private static String replace(StringBuffer outBuffer, Writer outWriter, String text, Object searchFor, Object replaceWith, boolean recurse, int timeToLive) {
        if (!recurse) {
            return MorphStringUtils.replaceHelper(outBuffer, outWriter, text, searchFor, replaceWith, recurse, timeToLive);
        }
        String result = MorphStringUtils.replaceHelper(null, null, text, searchFor, replaceWith, recurse, timeToLive);
        if (outBuffer != null) {
            outBuffer.append(result);
            return null;
        }
        if (outWriter != null) {
            try {
                outWriter.write(result);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return null;
        }
        return result;
    }

    public static int unpackInt(long theLong, boolean isFirst) {
        int result = 0;
        if (isFirst) {
            theLong >>= 32;
        }
        result = (int)(theLong & 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    private static String replaceHelper(StringBuffer outBuffer, Writer outWriter, String text, Object searchFor, Object replaceWith, boolean recurse, int timeToLive) {
        try {
            boolean writeToWriter;
            if (timeToLive < 0) {
                throw new IllegalArgumentException("TimeToLive under 0: " + timeToLive + ", " + text);
            }
            int searchForLength = MorphStringUtils.length(searchFor);
            boolean done = false;
            if (MorphStringUtils.isEmpty(text)) {
                return text;
            }
            if (searchForLength == 0) {
                done = true;
            }
            boolean[] noMoreMatchesForReplIndex = null;
            int inputIndex = -1;
            int replaceIndex = -1;
            long resultPacked = -1L;
            Iterator iteratorSearchFor = null;
            Iterator iteratorReplaceWith = null;
            if (!done) {
                if (searchForLength != MorphStringUtils.length(replaceWith)) {
                    throw new IndexOutOfBoundsException("Lengths dont match: " + searchForLength + ", " + MorphStringUtils.length(replaceWith));
                }
                noMoreMatchesForReplIndex = new boolean[searchForLength];
                iteratorSearchFor = MorphStringUtils.iterator(searchFor);
                iteratorReplaceWith = MorphStringUtils.iterator(replaceWith);
                resultPacked = MorphStringUtils.findNextIndexHelper(searchForLength, searchFor, replaceWith, iteratorSearchFor, iteratorReplaceWith, noMoreMatchesForReplIndex, text, 0);
                inputIndex = MorphStringUtils.unpackInt(resultPacked, true);
                replaceIndex = MorphStringUtils.unpackInt(resultPacked, false);
            }
            boolean bl = writeToWriter = outWriter != null;
            if (done || inputIndex == -1) {
                if (writeToWriter) {
                    outWriter.write(text, 0, text.length());
                    return null;
                }
                if (outBuffer != null) {
                    MorphStringUtils.appendSubstring(outBuffer, text, 0, text.length());
                    return null;
                }
                return text;
            }
            StringBuffer bufferToWriteTo = outBuffer != null ? outBuffer : (writeToWriter ? null : new StringBuffer(text.length() + MorphStringUtils.replaceStringsBufferIncrease(text, searchFor, replaceWith)));
            String searchString = null;
            String replaceString = null;
            int start = 0;
            while (inputIndex != -1) {
                searchString = (String)MorphStringUtils.get(searchFor, replaceIndex);
                replaceString = (String)MorphStringUtils.get(replaceWith, replaceIndex);
                if (writeToWriter) {
                    outWriter.write(text, start, inputIndex - start);
                    outWriter.write(replaceString);
                } else {
                    MorphStringUtils.appendSubstring(bufferToWriteTo, text, start, inputIndex).append(replaceString);
                }
                start = inputIndex + searchString.length();
                resultPacked = MorphStringUtils.findNextIndexHelper(searchForLength, searchFor, replaceWith, iteratorSearchFor, iteratorReplaceWith, noMoreMatchesForReplIndex, text, start);
                inputIndex = MorphStringUtils.unpackInt(resultPacked, true);
                replaceIndex = MorphStringUtils.unpackInt(resultPacked, false);
            }
            if (writeToWriter) {
                outWriter.write(text, start, text.length() - start);
            } else {
                MorphStringUtils.appendSubstring(bufferToWriteTo, text, start, text.length());
            }
            if (writeToWriter || outBuffer != null) {
                if (recurse) {
                    throw new IllegalArgumentException("Cannot recurse and write to existing buffer or writer!");
                }
                return null;
            }
            String resultString = bufferToWriteTo.toString();
            if (recurse) {
                return MorphStringUtils.replaceHelper(outBuffer, outWriter, resultString, searchFor, replaceWith, recurse, timeToLive - 1);
            }
            return resultString;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static StringBuffer appendSubstring(StringBuffer buf, String string, int start, int end) {
        for (int i = start; i < end; ++i) {
            buf.append(string.charAt(i));
        }
        return buf;
    }

    static int replaceStringsBufferIncrease(String text, Object repl, Object with) {
        int increase = 0;
        Iterator iteratorReplace = MorphStringUtils.iterator(repl);
        Iterator iteratorWith = MorphStringUtils.iterator(with);
        int replLength = MorphStringUtils.length(repl);
        String currentRepl = null;
        String currentWith = null;
        for (int i = 0; i < replLength; ++i) {
            currentRepl = (String)MorphStringUtils.next(repl, iteratorReplace, i);
            currentWith = (String)MorphStringUtils.next(with, iteratorWith, i);
            int greater = currentWith.length() - currentRepl.length();
            increase += greater > 0 ? 3 * greater : 0;
        }
        increase = Math.min(increase, text.length() / 5);
        return increase;
    }

    public static void assertDirExists(String path) {
        File theDir = new File(path);
        if (!theDir.exists() && !theDir.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + theDir);
        }
    }

    public static int collectionLength(Collection arrayList) {
        if (arrayList == null) {
            return 0;
        }
        return arrayList.size();
    }

    public static Object growArrayOrList(Object currentArray, int newSize) {
        int numberToCopyOver;
        if (currentArray == null) {
            return null;
        }
        int oldArraySize = MorphStringUtils.length(currentArray);
        if (oldArraySize == newSize) {
            return currentArray;
        }
        if (!currentArray.getClass().isArray() && !(currentArray instanceof List)) {
            throw new RuntimeException("You can't grow a non-array or list as an array or list! " + currentArray.getClass());
        }
        Object newArray = null;
        if (currentArray.getClass().isArray()) {
            newArray = Array.newInstance(currentArray.getClass().getComponentType(), newSize);
        } else {
            newArray = new ArrayList();
            for (int i = 0; i < newSize; ++i) {
                ((List)newArray).add(null);
            }
        }
        int n = numberToCopyOver = newSize > oldArraySize ? oldArraySize : newSize;
        if (currentArray.getClass().isArray()) {
            System.arraycopy(currentArray, 0, newArray, 0, numberToCopyOver);
        } else {
            List currentList = (List)currentArray;
            List newList = (List)newArray;
            for (int i = 0; i < numberToCopyOver; ++i) {
                newList.set(i, currentList.get(i));
            }
        }
        return newArray;
    }

    public static boolean isNewline(char input) {
        return input == '\n' || input == '\r';
    }

    public static void mkdirs(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create directory : " + dir.getParentFile());
            }
            return;
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("Should be a directory but is not: " + dir);
        }
    }

    public static void saveStringIntoFile(File file, String contents) {
        try {
            MorphStringUtils.writeStringToFile(file, contents, "ISO-8859-1");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(data.getBytes(encoding));
        }
        finally {
            MorphStringUtils.closeQuietly(out);
        }
    }

    public static Object set(Object arrayOrList, int index, Object value) {
        if (arrayOrList == null) {
            arrayOrList = Array.newInstance(value == null ? Object.class : value.getClass(), index + 1);
        }
        if (arrayOrList instanceof Set) {
            ((Set)arrayOrList).add(value);
            return arrayOrList;
        }
        if (arrayOrList instanceof List) {
            List list = (List)arrayOrList;
            if (index >= list.size()) {
                while (index > list.size()) {
                    list.add(null);
                }
                list.add(index, value);
            } else {
                list.set(index, value);
            }
            return list;
        }
        if (arrayOrList.getClass().isArray()) {
            if (index >= Array.getLength(arrayOrList)) {
                arrayOrList = MorphStringUtils.growArrayOrList(arrayOrList, index + 1);
            }
            Array.set(arrayOrList, index, value);
            return arrayOrList;
        }
        if (index == 0) {
            return value;
        }
        throw new RuntimeException("Invalid arguments: " + arrayOrList + ", " + index + ", " + value);
    }

    public static String specialChars(String input, boolean isToSpecialChars) {
        if (MorphStringUtils.isEmpty(input)) {
            return input;
        }
        input = isToSpecialChars ? MorphStringUtils.replace(input, SPECIAL_CHARS_FROM, SPECIAL_CHARS_TO) : MorphStringUtils.replace(input, SPECIAL_CHARS_TO, SPECIAL_CHARS_FROM);
        return input;
    }

    public static File[] listFilesByExtension(File dir, String extension) {
        final String finalExtension = extension;
        FilenameFilter fileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File theDir, String name) {
                if (name != null && name.endsWith(finalExtension)) {
                    if (MorphStringUtils.contains(finalExtension, "..")) {
                        return true;
                    }
                    return !MorphStringUtils.contains(name, "..");
                }
                return false;
            }
        };
        return dir.listFiles(fileFilter);
    }

    public static File[] listFilesByPrefix(File dir, final String prefix) {
        FilenameFilter fileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File theDir, String name) {
                if (name != null && name.startsWith(prefix)) {
                    if (MorphStringUtils.contains(prefix, "..")) {
                        return true;
                    }
                    return !MorphStringUtils.contains(name, "..");
                }
                return false;
            }
        };
        return dir.listFiles(fileFilter);
    }

    public static List listFilesByExtensionRecursive(File dir, String extension) {
        ArrayList theList = new ArrayList();
        MorphStringUtils.listFilesByExtensionRecursiveHelper(dir, extension, theList);
        return theList;
    }

    private static void listFilesByExtensionRecursiveHelper(File dir, String extension, List theList) {
        if (!dir.exists()) {
            throw new RuntimeException("The directory: " + dir + " does not exist");
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("The directory: " + dir + " is not a directory");
        }
        File[] allFiles = MorphStringUtils.listFilesByExtension(dir, extension);
        for (int i = 0; i < allFiles.length; ++i) {
            if (MorphStringUtils.contains(allFiles[i].getName(), "..") || !allFiles[i].isFile()) continue;
            if (theList.size() > 10000) {
                throw new RuntimeException("File list too large: " + dir.getAbsolutePath() + ", " + extension);
            }
            theList.add(allFiles[i]);
        }
        File[] allSubdirs = MorphStringUtils.listSubdirs(dir);
        int allSubdirsLength = allSubdirs == null ? 0 : allSubdirs.length;
        for (int i = 0; i < allSubdirsLength; ++i) {
            MorphStringUtils.listFilesByExtensionRecursiveHelper(allSubdirs[i], extension, theList);
        }
    }

    public static File[] listSubdirs(File dir) {
        if (!dir.exists()) {
            throw new RuntimeException("The directory: " + dir + " does not exist");
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("The directory: " + dir + " is not a directory");
        }
        File[] subdirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (MorphStringUtils.contains(pathname.getName(), "..")) {
                    return false;
                }
                return pathname.isDirectory();
            }
        });
        return subdirs;
    }

    public static boolean isWindows() {
        String osname = System.getProperty("os.name");
        return MorphStringUtils.contains(osname, "Windows");
    }

    public static String execCommand(String command) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        BufferedReader reader = null;
        StringBuffer result = new StringBuffer();
        try {
            process = runtime.exec(command);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String resultString = result.toString();
        return resultString.trim();
    }

    public static String readFromFileIfFile(String in) {
        return MorphStringUtils.readFromFileIfFile(in, MorphPropertyFileUtils.retrievePropertyBoolean("grouper.encrypt.disableExternalFileLookup", false));
    }

    public static String readFromFileIfFile(String in, boolean disableExternalFileLookup) {
        String newIn = in;
        newIn = File.separatorChar == '/' ? MorphStringUtils.replace(newIn, "\\", "/") : MorphStringUtils.replace(newIn, "/", "\\");
        if (newIn.indexOf(File.separatorChar) != -1 && !disableExternalFileLookup) {
            newIn = MorphStringUtils.readFileIntoString(new File(newIn));
            return newIn;
        }
        return in;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String fileCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static {
        Method getCauseMethod;
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            getCauseMethod = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception e) {
            getCauseMethod = null;
        }
        THROWABLE_CAUSE_METHOD = getCauseMethod;
        SPECIAL_CHARS_FROM = new String[]{"%", "(", ")", ",", "\\", ";", "\"", "'", "_"};
        SPECIAL_CHARS_TO = new String[]{"%25", "%28", "%29", "%2C", "%5C", "%3B", "%22", "%27", "%5F"};
    }
}

