/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString;

import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.Morph;
import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.MorphPropertyFileUtils;
import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.MorphStringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.Arrays;

public class Encrypt {
    public static void main(String[] args) {
        boolean dontMask = args.length == 1 && MorphStringUtils.equals("dontMask", args[0]);
        try {
            MorphPropertyFileUtils.retrieveProperties();
        }
        catch (Exception e) {
            System.out.print("Enter the location of morphString.properties: ");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String configLocation = null;
            try {
                configLocation = br.readLine();
            }
            catch (IOException ioe) {
                System.out.println("IO error trying to read config file location! " + MorphStringUtils.getFullStackTrace(ioe));
                System.exit(1);
            }
            MorphPropertyFileUtils.retrievePropertiesFromFile(MorphStringUtils.trimToEmpty(configLocation));
        }
        Encrypt.encryptInput(dontMask);
    }

    public static void encryptInput(boolean dontMask) {
        String passwordString = null;
        String prompt = "Type the string to encrypt (note: pasting might echo it back): ";
        if (dontMask) {
            System.out.print(prompt);
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                passwordString = br.readLine();
            }
            catch (IOException ioe) {
                System.out.println("IO error trying to read your name! " + MorphStringUtils.getFullStackTrace(ioe));
                System.exit(1);
            }
        } else {
            char[] password = null;
            try {
                password = Encrypt.password(System.in, prompt);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            passwordString = String.valueOf(password);
        }
        if (MorphStringUtils.isBlank(passwordString)) {
            System.out.println("No input entered");
        } else {
            System.out.println("The encrypted string is: " + Morph.encrypt(passwordString));
        }
    }

    public static final char[] password(InputStream in, String prompt) throws IOException {
        char[] lineBuffer;
        MaskingThread maskingthread = new MaskingThread(prompt);
        Thread thread = new Thread(maskingthread);
        thread.start();
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        maskingthread.stopMasking();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    static class MaskingThread
    extends Thread {
        private volatile boolean stop;
        private char echochar = (char)32;

        public MaskingThread(String prompt) {
            System.out.print(prompt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = true;
                while (this.stop) {
                    System.out.print("\b" + this.echochar);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }
}

