/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.GcElUtilsSafe;
import edu.internet2.middleware.grouperClient.util.GcExpressionLanguageMissingVariableException;
import edu.internet2.middleware.grouperClient.util.GrouperClientCommonUtils;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientLog;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubject;
import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.Crypto;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.codec.binary.Base64;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.codec.digest.DigestUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl2.Expression;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl2.JexlEngine;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl2.JexlException;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl2.MapContext;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.impl.Jdk14Logger;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrouperClientUtils
extends GrouperClientCommonUtils {
    private static boolean configuredLogs = false;
    private static Log LOG = GrouperClientUtils.retrieveLog(GrouperClientUtils.class);
    private static Map<String, Class<?>> jexlClass = new HashMap();
    private static Pattern jexlClassPattern = Pattern.compile("^[a-zA-Z0-9_.]*\\.[A-Z][a-zA-Z0-9_]*$");
    private static Map<String, Boolean> jexlKnowsIfClass = new HashMap<String, Boolean>();
    private static String cacheDirectoryName = null;

    public static Log retrieveLog(Class<?> theClass) {
        Log theLog = LogFactory.getLog(theClass);
        if (GrouperClientUtils.isBlank(GrouperClientConfig.retrieveConfig().propertyValueString("encrypt.disableExternalFileLookup")) || theClass.equals(GrouperClientCommonUtils.class)) {
            return new GrouperClientLog(theLog);
        }
        if (!configuredLogs) {
            boolean hasGrouperClientLogLevel;
            String logLevel = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.logging.logLevel");
            String logFile = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.logging.logFile");
            String grouperClientLogLevel = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.logging.grouperClientOnly.logLevel");
            boolean hasLogLevel = !GrouperClientUtils.isBlank(logLevel);
            boolean hasLogFile = !GrouperClientUtils.isBlank(logFile);
            boolean bl = hasGrouperClientLogLevel = !GrouperClientUtils.isBlank(grouperClientLogLevel);
            if ((hasLogLevel || hasLogFile) && theLog instanceof Jdk14Logger) {
                Jdk14Logger jdkLogger = (Jdk14Logger)theLog;
                Logger logger = jdkLogger.getLogger();
                long timeToLive = 60L;
                while (logger.getParent() != null && timeToLive-- > 0L) {
                    logger = logger.getParent();
                }
                if (GrouperClientUtils.length(logger.getHandlers()) == 1 && logger.getHandlers()[0].getClass() == ConsoleHandler.class) {
                    logger.removeHandler(logger.getHandlers()[0]);
                }
                if (GrouperClientUtils.length(logger.getHandlers()) == 0) {
                    StreamHandler handler = null;
                    if (hasLogFile) {
                        try {
                            handler = new FileHandler(logFile, true);
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    } else {
                        handler = new ConsoleHandler();
                    }
                    handler.setFormatter(new SimpleFormatter());
                    handler.setLevel(Level.ALL);
                    logger.addHandler(handler);
                    logger.setUseParentHandlers(false);
                }
                if (hasLogLevel) {
                    Level level = Level.parse(logLevel);
                    logger.setLevel(level);
                }
            }
            if (hasGrouperClientLogLevel) {
                Level level = Level.parse(grouperClientLogLevel);
                Log grouperClientLog = LogFactory.getLog("edu.internet2.middleware.grouperClient");
                if (grouperClientLog instanceof Jdk14Logger) {
                    Jdk14Logger jdkLogger = (Jdk14Logger)grouperClientLog;
                    Logger logger = jdkLogger.getLogger();
                    logger.setLevel(level);
                }
            }
            configuredLogs = true;
        }
        return new GrouperClientLog(theLog);
    }

    @Deprecated
    public static Map<String, String> grouperClientOverrideMap() {
        return GrouperClientConfig.retrieveConfig().propertiesOverrideMap();
    }

    @Deprecated
    public static Properties grouperClientProperties() {
        return GrouperClientConfig.retrieveConfig().properties();
    }

    @Deprecated
    public static String propertiesValue(String key, boolean required) {
        if (required) {
            return GrouperClientConfig.retrieveConfig().propertyValueStringRequired(key);
        }
        return GrouperClientConfig.retrieveConfig().propertyValueString(key);
    }

    @Deprecated
    public static boolean propertiesValueBoolean(String key, boolean defaultValue, boolean required) {
        if (required) {
            return GrouperClientConfig.retrieveConfig().propertyValueBooleanRequired(key);
        }
        return GrouperClientConfig.retrieveConfig().propertyValueBoolean(key, defaultValue);
    }

    @Deprecated
    public static int propertiesValueInt(String key, int defaultValue, boolean required) {
        if (required) {
            return GrouperClientConfig.retrieveConfig().propertyValueIntRequired(key);
        }
        return GrouperClientConfig.retrieveConfig().propertyValueInt(key, defaultValue);
    }

    public static String substituteExpressionLanguage(String stringToParse, Map<String, Object> variableMap) {
        return GrouperClientUtils.substituteExpressionLanguage(stringToParse, variableMap, true, true, true, false);
    }

    public static String substituteExpressionLanguage(String stringToParse, Map<String, Object> variableMap, boolean allowStaticClasses, boolean silent, boolean lenient, boolean logOnNull) {
        String string;
        block25: {
            LinkedHashSet<String> keysSet;
            if (GrouperClientUtils.isBlank(stringToParse)) {
                return stringToParse;
            }
            String overallResult = null;
            Exception exception = null;
            try {
                MapContext jc = allowStaticClasses ? new ElMapContext() : new MapContext();
                int index = 0;
                variableMap = GrouperClientUtils.nonNull(variableMap);
                for (String key : variableMap.keySet()) {
                    jc.set(key, variableMap.get(key));
                }
                jc.set("elUtils", new GcElUtilsSafe());
                Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
                Matcher matcher = pattern.matcher(stringToParse);
                StringBuilder result = new StringBuilder();
                while (matcher.find()) {
                    result.append(stringToParse.substring(index, matcher.start()));
                    String script = matcher.group(1);
                    index = matcher.end();
                    if (script.contains("{")) {
                        int scriptStart = matcher.start(1);
                        int openCurlyCount = 0;
                        for (int i = scriptStart; i < stringToParse.length(); ++i) {
                            char curChar = stringToParse.charAt(i);
                            if (curChar == '{') {
                                ++openCurlyCount;
                            }
                            if (curChar != '}' || --openCurlyCount > -1) continue;
                            script = stringToParse.substring(scriptStart, i);
                            index = i + 1;
                            break;
                        }
                    }
                    JexlEngine jexlEngine = new JexlEngine();
                    jexlEngine.setSilent(silent);
                    jexlEngine.setLenient(lenient);
                    Expression e = jexlEngine.createExpression(script);
                    Object o = null;
                    try {
                        o = e.evaluate(jc);
                    }
                    catch (JexlException je) {
                        if (!lenient && GrouperClientUtils.trimToEmpty(je.getMessage()).contains("undefined variable")) {
                            String message = je.getMessage();
                            Pattern exceptionPattern = Pattern.compile("^.*undefined variable (.*)");
                            Matcher exceptionMatcher = exceptionPattern.matcher(message);
                            if (exceptionMatcher.matches()) {
                                message = "variable '" + exceptionMatcher.group(1) + "' is not defined in script: '" + script + "'";
                            }
                            throw new GcExpressionLanguageMissingVariableException(message, je);
                        }
                        throw je;
                    }
                    if (o == null) {
                        if (logOnNull) {
                            LOG.warn("expression returned null: " + script + ", in pattern: '" + stringToParse + "', available variables are: " + GrouperClientUtils.toStringForLog(variableMap.keySet()));
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("expression returned null: " + script + ", in pattern: '" + stringToParse + "', available variables are: " + GrouperClientUtils.toStringForLog(variableMap.keySet()));
                        }
                        o = "";
                    }
                    if (o instanceof RuntimeException) {
                        throw (RuntimeException)o;
                    }
                    result.append(o);
                }
                result.append(stringToParse.substring(index, stringToParse.length()));
                string = overallResult = result.toString();
                if (!LOG.isDebugEnabled()) break block25;
                keysSet = new LinkedHashSet<String>(GrouperClientUtils.nonNull(variableMap).keySet());
                keysSet.add("elUtils");
            }
            catch (Exception e) {
                try {
                    exception = e;
                    if (e instanceof GcExpressionLanguageMissingVariableException) {
                        throw (GcExpressionLanguageMissingVariableException)e;
                    }
                    throw new RuntimeException("Error substituting string: '" + stringToParse + "'", e);
                }
                catch (Throwable throwable) {
                    if (LOG.isDebugEnabled()) {
                        LinkedHashSet<String> keysSet2 = new LinkedHashSet<String>(GrouperClientUtils.nonNull(variableMap).keySet());
                        keysSet2.add("elUtils");
                        StringBuilder logMessage = new StringBuilder();
                        logMessage.append("Subsituting EL: '").append(stringToParse).append("', and with env vars: ");
                        String[] keys = keysSet2.toArray(new String[0]);
                        for (int i = 0; i < keys.length; ++i) {
                            logMessage.append(keys[i]);
                            if (i == keys.length - 1) continue;
                            logMessage.append(", ");
                        }
                        logMessage.append(" with result: '" + overallResult + "'");
                        if (exception != null) {
                            logMessage.append(", and exception: " + exception + ", " + GrouperClientUtils.getFullStackTrace(exception));
                        }
                        LOG.debug(logMessage.toString());
                    }
                    throw throwable;
                }
            }
            StringBuilder logMessage = new StringBuilder();
            logMessage.append("Subsituting EL: '").append(stringToParse).append("', and with env vars: ");
            String[] keys = keysSet.toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                logMessage.append(keys[i]);
                if (i == keys.length - 1) continue;
                logMessage.append(", ");
            }
            logMessage.append(" with result: '" + overallResult + "'");
            if (exception != null) {
                logMessage.append(", and exception: " + exception + ", " + GrouperClientUtils.getFullStackTrace(exception));
            }
            LOG.debug(logMessage.toString());
        }
        return string;
    }

    public static String subjectAttributeValue(WsSubject wsSubject, String[] attributeNames, String attributeName) {
        if (GrouperClientUtils.equals("subject__id", attributeName)) {
            return wsSubject.getId();
        }
        if (GrouperClientUtils.equals("subject__name", attributeName)) {
            return wsSubject.getName();
        }
        for (int i = 0; i < GrouperClientUtils.length(attributeNames); ++i) {
            if (!GrouperClientUtils.equalsIgnoreCase(attributeName, attributeNames[i]) || GrouperClientUtils.length(wsSubject.getAttributeValues()) <= i) continue;
            return wsSubject.getAttributeValue(i);
        }
        return null;
    }

    public static String encryptKey() {
        String encryptKey = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("encrypt.key");
        boolean disableExternalFileLookup = GrouperClientConfig.retrieveConfig().propertyValueBoolean("encrypt.disableExternalFileLookup", false);
        encryptKey = GrouperClientUtils.readFromFileIfFile(encryptKey, disableExternalFileLookup);
        if (GrouperClientConfig.retrieveConfig().propertyValueBoolean("encrypt.encryptLikeServer", false)) {
            encryptKey = encryptKey + "w";
        }
        return encryptKey;
    }

    public static String decryptFromFileIfFileExists(String pass, StringBuilder logInfo) {
        boolean disableExternalFileLookup = GrouperClientUtils.propertiesValueBoolean("encrypt.disableExternalFileLookup", false, false);
        String passFromFile = GrouperClientUtils.readFromFileIfFileExists(pass, disableExternalFileLookup);
        if (!GrouperClientUtils.equals(pass, passFromFile)) {
            if (logInfo != null) {
                logInfo.append("reading encrypted value from file: " + pass);
            }
            String encryptKey = GrouperClientUtils.encryptKey();
            pass = new Crypto(encryptKey).decrypt(passFromFile);
        } else if (logInfo != null) {
            logInfo.append("pass is a scalar");
        }
        return pass;
    }

    public static String cacheDirectoryName() {
        if (cacheDirectoryName == null) {
            String directoryName = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.cacheDirectory");
            if (GrouperClientCommonUtils.isBlank(directoryName)) {
                throw new RuntimeException("grouperClient.cacheDirectory is required in grouper.client.properties");
            }
            directoryName = GrouperClientCommonUtils.stripEnd(directoryName, "/");
            directoryName = GrouperClientCommonUtils.stripEnd(directoryName, "\\");
            File discoveryDir = new File(directoryName);
            if ((directoryName = discoveryDir.getAbsolutePath()).endsWith("/.")) {
                directoryName = directoryName.substring(0, directoryName.length() - 2);
            }
            if (directoryName.endsWith("\\.")) {
                directoryName = directoryName.substring(0, directoryName.length() - 2);
            }
            cacheDirectoryName = directoryName;
        }
        return cacheDirectoryName;
    }

    public static synchronized String encryptSha(String plaintext) {
        try {
            byte[] sha1bytes = DigestUtils.sha(plaintext.getBytes("UTF-8"));
            return new String(Base64.encodeBase64(sha1bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ElMapContext
    extends MapContext {
        private ElMapContext() {
        }

        private static Object retrieveClass(String name) {
            if (GrouperClientCommonUtils.isBlank(name)) {
                return null;
            }
            Boolean knowsIfClass = (Boolean)jexlKnowsIfClass.get(name);
            if (knowsIfClass != null) {
                return jexlClass.get(name);
            }
            if (jexlClassPattern.matcher(name).matches()) {
                jexlKnowsIfClass.put(name, true);
                try {
                    Class<?> theClass = Class.forName(name);
                    jexlClass.put(name, theClass);
                    return theClass;
                }
                catch (Exception e) {
                    LOG.info("Cant load what looks like class: " + name, e);
                }
            }
            return null;
        }

        @Override
        public Object get(String name) {
            Object object = super.get(name);
            if (object != null) {
                return object;
            }
            return ElMapContext.retrieveClass(name);
        }

        @Override
        public boolean has(String name) {
            boolean superHas = super.has(name);
            if (superHas) {
                return true;
            }
            return ElMapContext.retrieveClass(name) != null;
        }
    }
}

