/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;

public class GrouperClientLog
implements Log {
    private static ThreadLocal<Boolean> debugToConsole = new ThreadLocal();
    private Log enclosedLog;

    public static void assignDebugToConsole(boolean theDebugToConsole) {
        debugToConsole.set(theDebugToConsole);
    }

    public static boolean debugToConsole() {
        Boolean debugToConsoleBoolean = debugToConsole.get();
        return GrouperClientUtils.defaultIfNull(debugToConsoleBoolean, false);
    }

    private static void debugToConsoleIfNeeded(String prefix, Object message, Throwable t) {
        if (GrouperClientLog.debugToConsole()) {
            System.err.print(prefix);
            System.err.println(message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public GrouperClientLog(Log theLog) {
        this.enclosedLog = theLog;
    }

    @Override
    public void debug(Object message) {
        GrouperClientLog.debugToConsoleIfNeeded("DEBUG: ", message, null);
        this.enclosedLog.debug(message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        GrouperClientLog.debugToConsoleIfNeeded("DEBUG: ", message, t);
        this.enclosedLog.debug(message, t);
    }

    @Override
    public void error(Object message) {
        GrouperClientLog.debugToConsoleIfNeeded("ERROR: ", message, null);
        this.enclosedLog.error(message);
    }

    @Override
    public void error(Object message, Throwable t) {
        GrouperClientLog.debugToConsoleIfNeeded("ERROR: ", message, t);
        this.enclosedLog.error(message, t);
    }

    @Override
    public void fatal(Object message) {
        GrouperClientLog.debugToConsoleIfNeeded("FATAL: ", message, null);
        this.enclosedLog.fatal(message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        GrouperClientLog.debugToConsoleIfNeeded("FATAL: ", message, t);
        this.enclosedLog.fatal(message, t);
    }

    @Override
    public void info(Object message) {
        GrouperClientLog.debugToConsoleIfNeeded("INFO: ", message, null);
        this.enclosedLog.info(message);
    }

    @Override
    public void info(Object message, Throwable t) {
        GrouperClientLog.debugToConsoleIfNeeded("INFO: ", message, t);
        this.enclosedLog.info(message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.enclosedLog.isDebugEnabled() || GrouperClientLog.debugToConsole();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.enclosedLog.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.enclosedLog.isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.enclosedLog.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.enclosedLog.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.enclosedLog.isWarnEnabled();
    }

    @Override
    public void trace(Object message) {
        GrouperClientLog.debugToConsoleIfNeeded("TRACE: ", message, null);
        this.enclosedLog.trace(message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        GrouperClientLog.debugToConsoleIfNeeded("TRACE: ", message, t);
        this.enclosedLog.trace(message, t);
    }

    @Override
    public void warn(Object message) {
        GrouperClientLog.debugToConsoleIfNeeded("WARN: ", message, null);
        this.enclosedLog.warn(message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        GrouperClientLog.debugToConsoleIfNeeded("WARN: ", message, t);
        this.enclosedLog.warn(message, t);
    }
}

